/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.heap.UnknownObjectField;
import java.util.function.Function;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class RuntimeModuleSupport {
    @UnknownObjectField
    private ModuleLayer bootLayer;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Function<Module, Module> hostedToRuntimeModuleMapper;

    public static RuntimeModuleSupport instance() {
        return (RuntimeModuleSupport)ImageSingletons.lookup(RuntimeModuleSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setBootLayer(ModuleLayer bootLayer) {
        this.bootLayer = bootLayer;
    }

    public ModuleLayer getBootLayer() {
        return this.bootLayer;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setHostedToRuntimeModuleMapper(Function<Module, Module> hostedToRuntimeModuleMapper) {
        this.hostedToRuntimeModuleMapper = hostedToRuntimeModuleMapper;
    }

    public Module getRuntimeModuleForHostedModule(Module hostedModule) {
        return this.hostedToRuntimeModuleMapper.apply(hostedModule);
    }
}

