/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JavaLoggingModule;
import com.oracle.svm.core.jdk.Target_java_util_logging_LogManager_Cleaner;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetClass(className="java.util.logging.LogManager", onlyWith={JavaLoggingModule.IsPresent.class})
final class Target_java_util_logging_LogManager {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=AtomicBoolean.class)
    private AtomicBoolean addedShutdownHook = new AtomicBoolean();
    @Alias
    static Target_java_util_logging_LogManager manager;

    Target_java_util_logging_LogManager() {
    }

    @Alias
    native void ensureLogManagerInitialized();

    @Substitute
    public static Target_java_util_logging_LogManager getLogManager() {
        if (manager == null) {
            return manager;
        }
        manager.ensureLogManagerInitialized();
        if (!Target_java_util_logging_LogManager.manager.addedShutdownHook.getAndSet(true)) {
            try {
                Runtime.getRuntime().addShutdownHook(SubstrateUtil.cast(new Target_java_util_logging_LogManager_Cleaner(manager), Thread.class));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return manager;
    }
}

