/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

class SamplingStackVisitor
extends ParameterizedStackFrameVisitor {
    SamplingStackVisitor() {
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate within the safepoint sampler.")
    protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, Object data) {
        StackTrace stackTrace = (StackTrace)data;
        if (stackTrace.num < stackTrace.buffer.length) {
            stackTrace.buffer[stackTrace.num++] = ip.rawValue();
            return true;
        }
        stackTrace.overflow = true;
        return false;
    }

    @Override
    protected boolean unknownFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, Object data) {
        return false;
    }

    static class StackTrace {
        final long[] buffer;
        int num;
        boolean overflow;

        StackTrace(long stackSizeInBytes) {
            this.buffer = new long[(int)stackSizeInBytes / 4];
            this.num = 0;
            this.overflow = false;
        }

        public void reset() {
            this.num = 0;
            this.overflow = false;
        }

        public String toString() {
            return "StackTrace<buffer length = " + this.buffer.length + ", num = " + this.num + ">";
        }
    }
}

