/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JavaStackWalker {
    private JavaStackWalker() {
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static void initWalk(JavaStackWalk walk, Pointer startSP, CodePointer startIP) {
        JavaStackWalker.initWalk(walk, startSP, (Pointer)WordFactory.nullPointer(), startIP, JavaFrameAnchors.getFrameAnchor());
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    private static void initWalk(JavaStackWalk walk, Pointer startSP, Pointer endSP, CodePointer startIP, JavaFrameAnchor anchor) {
        walk.setSP(startSP);
        walk.setPossiblyStaleIP(startIP);
        walk.setStartSP(startSP);
        walk.setStartIP(startIP);
        walk.setAnchor(anchor);
        walk.setEndSP(endSP);
        if (startIP.isNonNull()) {
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(startIP));
        } else {
            walk.setIPCodeInfo((UntetheredCodeInfo)WordFactory.nullPointer());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initWalkStoredContinuation(JavaStackWalk walk, Pointer startSP, Pointer endSP, CodePointer startIP) {
        JavaStackWalker.initWalk(walk, startSP, endSP, startIP, (JavaFrameAnchor)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Must be uninterruptible because it calls `initWalk`.")
    public static void initWalk(JavaStackWalk walk, Pointer startSP) {
        JavaStackWalker.initWalk(walk, startSP, (CodePointer)WordFactory.nullPointer());
        assert (walk.getIPCodeInfo().isNull()) : "otherwise, the caller would have to be uninterruptible as well";
    }

    @Uninterruptible(reason="Must be uninterruptible because it calls `initWalk`.")
    public static void initWalk(JavaStackWalk walk, Pointer startSP, Pointer endSP) {
        JavaStackWalker.initWalk(walk, startSP);
        walk.setEndSP(endSP);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean initWalk(JavaStackWalk walk, IsolateThread thread) {
        assert (thread.notEqual((ComparableWord)CurrentIsolate.getCurrentThread())) : "Cannot walk the current stack with this method, it would miss all frames after the last frame anchor";
        assert (VMOperation.isInProgressAtSafepoint()) : "Walking the stack of another thread is only safe when that thread is stopped at a safepoint";
        if (VMThreads.SafepointBehavior.isCrashedThread(thread)) {
            return false;
        }
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        boolean result = anchor.isNonNull();
        Pointer sp = (Pointer)WordFactory.nullPointer();
        CodePointer ip = (CodePointer)WordFactory.nullPointer();
        if (result) {
            sp = anchor.getLastJavaSP();
            ip = anchor.getLastJavaIP();
        }
        walk.setSP(sp);
        walk.setPossiblyStaleIP(ip);
        walk.setStartSP(sp);
        walk.setStartIP(ip);
        walk.setAnchor(anchor);
        walk.setEndSP((Pointer)WordFactory.nullPointer());
        walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(ip));
        return result;
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean continueWalk(JavaStackWalk walk, CodeInfo info) {
        if (walk.getSP().isNull() || walk.getPossiblyStaleIP().isNull()) {
            return false;
        }
        Pointer sp = walk.getSP();
        SimpleCodeInfoQueryResult queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
        if (deoptFrame == null) {
            JavaStackWalker.lookupCodeInfoInterruptible(info, walk.getPossiblyStaleIP(), queryResult);
        }
        return JavaStackWalker.continueWalk(walk, queryResult, deoptFrame);
    }

    @Uninterruptible(reason="Wrap call to interruptible code.", calleeMustBe=false)
    private static void lookupCodeInfoInterruptible(CodeInfo codeInfo, CodePointer ip, SimpleCodeInfoQueryResult queryResult) {
        CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean continueWalk(JavaStackWalk walk, SimpleCodeInfoQueryResult queryResult, DeoptimizedFrame deoptFrame) {
        boolean moreFrames;
        Pointer sp = walk.getSP();
        long encodedFrameSize = deoptFrame != null ? deoptFrame.getSourceEncodedFrameSize() : queryResult.getEncodedFrameSize();
        if (!CodeInfoQueryResult.isEntryPoint(encodedFrameSize)) {
            long totalFrameSize = CodeInfoQueryResult.getTotalFrameSize(encodedFrameSize);
            sp = sp.add(WordFactory.unsigned((long)totalFrameSize));
            CodePointer ip = FrameAccess.singleton().readReturnAddress(sp);
            walk.setSP(sp);
            walk.setPossiblyStaleIP(ip);
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(ip));
            moreFrames = true;
        } else {
            JavaFrameAnchor anchor = walk.getAnchor();
            while (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)sp)) {
                anchor = anchor.getPreviousAnchor();
            }
            if (anchor.isNonNull()) {
                assert (anchor.getLastJavaSP().aboveThan((UnsignedWord)sp));
                walk.setSP(anchor.getLastJavaSP());
                walk.setPossiblyStaleIP(anchor.getLastJavaIP());
                walk.setAnchor(anchor.getPreviousAnchor());
                walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(anchor.getLastJavaIP()));
                moreFrames = true;
            } else {
                walk.setSP((Pointer)WordFactory.nullPointer());
                walk.setPossiblyStaleIP((CodePointer)WordFactory.nullPointer());
                walk.setAnchor((JavaFrameAnchor)WordFactory.nullPointer());
                walk.setIPCodeInfo((UntetheredCodeInfo)WordFactory.nullPointer());
                moreFrames = false;
            }
        }
        if (moreFrames && walk.getEndSP().isNonNull() && walk.getSP().aboveOrEqual((UnsignedWord)walk.getEndSP())) {
            moreFrames = false;
        }
        return moreFrames;
    }

    @Uninterruptible(reason="Not really uninterruptible, but we are about to fatally fail.", calleeMustBe=false)
    public static RuntimeException reportUnknownFrameEncountered(Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
        Log log = Log.log().string("Stack walk must walk only frames of known code:");
        log.string("  sp=").hex((WordBase)sp).string("  ip=").hex((WordBase)ip);
        if (DeoptimizationSupport.enabled()) {
            log.string("  deoptFrame=").object(deoptFrame);
        }
        log.newline();
        throw VMError.shouldNotReachHere("Stack walk must walk only frames of known code");
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, StackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThread(startSP, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, Pointer endSP, StackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThread(startSP, endSP, FrameAccess.singleton().readReturnAddress(startSP), visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, ParameterizedStackFrameVisitor visitor, Object data) {
        return JavaStackWalker.walkCurrentThread(startSP, (Pointer)WordFactory.nullPointer(), FrameAccess.singleton().readReturnAddress(startSP), visitor, data);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkCurrentThread(Pointer startSP, CodePointer startIP, ParameterizedStackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThread(startSP, (Pointer)WordFactory.nullPointer(), startIP, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, Pointer endSP, CodePointer startIP, ParameterizedStackFrameVisitor visitor, Object data) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        JavaStackWalker.initWalk(walk, startSP, endSP, startIP, JavaFrameAnchors.getFrameAnchor());
        return JavaStackWalker.doWalk(walk, visitor, data);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkThread(IsolateThread thread, StackFrameVisitor visitor) {
        return JavaStackWalker.walkThread(thread, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkThread(IsolateThread thread, ParameterizedStackFrameVisitor visitor, Object data) {
        return JavaStackWalker.walkThread(thread, (Pointer)WordFactory.nullPointer(), visitor, data);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkThread(IsolateThread thread, Pointer endSP, ParameterizedStackFrameVisitor visitor, Object data) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        if (JavaStackWalker.initWalk(walk, thread)) {
            walk.setEndSP(endSP);
            return JavaStackWalker.doWalk(walk, visitor, data);
        }
        return true;
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static void walkThreadAtSafepoint(Pointer startSP, Pointer endSP, CodePointer startIP, StackFrameVisitor visitor) {
        assert (VMOperation.isInProgressAtSafepoint());
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        JavaStackWalker.initWalk(walk, startSP, endSP, startIP, JavaFrameAnchors.getFrameAnchor());
        JavaStackWalker.doWalk(walk, visitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    static boolean doWalk(JavaStackWalk walk, ParameterizedStackFrameVisitor visitor, Object data) {
        UntetheredCodeInfo untetheredInfo;
        while (!(untetheredInfo = walk.getIPCodeInfo()).isNull()) {
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            try {
                CodeInfo tetheredInfo = CodeInfoAccess.convert(untetheredInfo, tether);
                if (!JavaStackWalker.callVisitor(walk, tetheredInfo, visitor, data)) {
                    boolean bl = false;
                    return bl;
                }
                if (JavaStackWalker.continueWalk(walk, tetheredInfo)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
                continue;
            }
            break;
        }
        return JavaStackWalker.callUnknownFrame(walk, visitor, data);
    }

    @Uninterruptible(reason="CodeInfo in JavaStackWalk is currently null, and we are going to abort the stack walking.", calleeMustBe=false)
    private static boolean callUnknownFrame(JavaStackWalk walk, ParameterizedStackFrameVisitor visitor, Object data) {
        return visitor.unknownFrame(walk.getSP(), walk.getPossiblyStaleIP(), Deoptimizer.checkDeoptimized(walk.getSP()), data);
    }

    @Uninterruptible(reason="Wraps the now safe call to the possibly interruptible visitor.", callerMustBe=true, calleeMustBe=false)
    @RestrictHeapAccess(reason="Whitelisted because some StackFrameVisitor implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
    public static boolean callVisitor(JavaStackWalk walk, CodeInfo info, ParameterizedStackFrameVisitor visitor, Object data) {
        return visitor.visitFrame(walk.getSP(), walk.getPossiblyStaleIP(), info, Deoptimizer.checkDeoptimized(walk.getSP()), data);
    }
}

