/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.DeoptimizationFeature;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.SVMParsingSupport;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class ParseOnceDeoptTestFeature
implements InternalFeature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(DeoptimizationFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SVMParsingSupport.class, (Object)new DeoptTestingParsingSupport());
        ImageSingletons.add(HostVM.MultiMethodAnalysisPolicy.class, (Object)new DeoptTestingAnalysisPolicy());
    }

    private class DeoptTestingParsingSupport
    implements SVMParsingSupport {
        private DeoptTestingParsingSupport() {
        }

        @Override
        public Object parseGraph(BigBang bb, DebugContext debug, AnalysisMethod method) {
            return HostVM.PARSING_UNHANDLED;
        }

        @Override
        public GraphBuilderConfiguration updateGraphBuilderConfiguration(GraphBuilderConfiguration config, AnalysisMethod method) {
            if (method.isDeoptTarget()) {
                return config.withRetainLocalVariables(false);
            }
            return config;
        }

        @Override
        public boolean validateGraph(PointsToAnalysis bb, StructuredGraph graph) {
            boolean canDeoptForTesting;
            PointsToAnalysisMethod aMethod = (PointsToAnalysisMethod)graph.method();
            Supplier<Boolean> graphInvalidator = DeoptimizationUtils.createGraphInvalidator(graph);
            if (aMethod.isDeoptTarget()) {
                return graphInvalidator.get() == false;
            }
            boolean bl = canDeoptForTesting = aMethod.isOriginalMethod() && DeoptimizationUtils.canDeoptForTesting((AnalysisMethod)aMethod, DeoptTester.enabled(), graphInvalidator);
            if (canDeoptForTesting) {
                DeoptimizationUtils.registerDeoptEntriesForDeoptTesting(bb, graph, aMethod);
            }
            return true;
        }

        @Override
        public boolean allowAssumptions(AnalysisMethod method) {
            return false;
        }

        @Override
        public boolean recordInlinedMethods(AnalysisMethod method) {
            return false;
        }

        @Override
        public HostedProviders getHostedProviders(MultiMethod.MultiMethodKey key) {
            return null;
        }

        @Override
        public void initializeInlineBeforeAnalysisPolicy(SVMHost svmHost, InlineBeforeAnalysisPolicyUtils inliningUtils) {
        }

        @Override
        public InlineBeforeAnalysisPolicy inlineBeforeAnalysisPolicy(MultiMethod.MultiMethodKey multiMethodKey, InlineBeforeAnalysisPolicy defaultPolicy) {
            if (multiMethodKey == MultiMethod.ORIGINAL_METHOD) {
                return InlineBeforeAnalysisPolicy.NO_INLINING;
            }
            if (multiMethodKey == MultiMethod.DEOPT_TARGET_METHOD) {
                return InlineBeforeAnalysisPolicy.NO_INLINING;
            }
            throw VMError.shouldNotReachHere("Unexpected method key: %s", multiMethodKey);
        }

        @Override
        public Function<AnalysisType, ResolvedJavaType> getStrengthenGraphsToTargetFunction(MultiMethod.MultiMethodKey key) {
            return null;
        }
    }

    private static class DeoptTestingAnalysisPolicy
    implements HostVM.MultiMethodAnalysisPolicy {
        private DeoptTestingAnalysisPolicy() {
        }

        public <T extends AnalysisMethod> Collection<T> determineCallees(BigBang bb, T implementation, T target, MultiMethod.MultiMethodKey callerMultiMethodKey, InvokeTypeFlow invokeFlow) {
            if (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD) {
                if (DeoptimizationUtils.canDeoptForTesting(implementation, DeoptTester.enabled(), () -> false)) {
                    return List.of(implementation, this.getDeoptVersion(implementation));
                }
                return List.of(implementation);
            }
            assert (callerMultiMethodKey == MultiMethod.DEOPT_TARGET_METHOD);
            return List.of(implementation, this.getDeoptVersion(implementation));
        }

        protected <T extends AnalysisMethod> T getDeoptVersion(T implementation) {
            return (T)implementation.getOrCreateMultiMethod(MultiMethod.DEOPT_TARGET_METHOD, newMethod -> ((PointsToAnalysisMethod)newMethod).getTypeFlow().setAsStubFlow());
        }

        public boolean performParameterLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            if (callerMultiMethodKey == MultiMethod.DEOPT_TARGET_METHOD) {
                return calleeMultiMethodKey == MultiMethod.ORIGINAL_METHOD;
            }
            assert (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD);
            return true;
        }

        public boolean performReturnLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            if (callerMultiMethodKey == MultiMethod.DEOPT_TARGET_METHOD) {
                return true;
            }
            assert (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD);
            return true;
        }

        public boolean canComputeReturnedParameterIndex(MultiMethod.MultiMethodKey multiMethodKey) {
            return multiMethodKey != MultiMethod.DEOPT_TARGET_METHOD;
        }

        public boolean insertPlaceholderParamAndReturnFlows(MultiMethod.MultiMethodKey multiMethodKey) {
            return multiMethodKey == MultiMethod.DEOPT_TARGET_METHOD;
        }
    }
}

