/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.query;

import com.oracle.svm.hosted.c.info.PropertyInfo;

public class QueryParserUtil {
    static final int SIZE_OF_LONG_HEX = 16;

    static void parseSigned(PropertyInfo<Object> info, String hex) {
        if (QueryParserUtil.isNegative(hex)) {
            if (hex.length() < 16) {
                String extended = QueryParserUtil.signedExtend(hex);
                QueryParserUtil.parseHexToLong(info, extended);
            } else {
                QueryParserUtil.parseHexToLong(info, hex);
            }
        } else {
            QueryParserUtil.parseHexToLong(info, hex);
        }
    }

    static boolean isNegative(String hex) {
        int mostSignificantDigit = Integer.parseInt(hex.substring(0, 1), 16);
        return mostSignificantDigit >= 8;
    }

    static String unsignedExtend(String hex) {
        int numOfMissingHexDigit = 16 - hex.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numOfMissingHexDigit; ++i) {
            sb.append('0');
        }
        return sb.append(hex).toString();
    }

    static String unsignedExtendToSize(int sizeInByte, String hex) {
        int numOfMissingHexDigit = sizeInByte * 2 - hex.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numOfMissingHexDigit; ++i) {
            sb.append('0');
        }
        return sb.append(hex).toString();
    }

    static String signedExtend(String hex) {
        int numOfMissingHexDigit = 16 - hex.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numOfMissingHexDigit; ++i) {
            sb.append('F');
        }
        return sb.append(hex).toString();
    }

    static void parseHexToLong(PropertyInfo<Object> info, String hex) {
        String extended = QueryParserUtil.unsignedExtend(hex);
        try {
            String msb = extended.substring(0, 8);
            String lsb = extended.substring(8);
            long msbValue = Long.parseLong(msb, 16);
            long lsbValue = Long.parseLong(lsb, 16);
            long value = msbValue << 32 | lsbValue;
            info.setProperty(value);
        }
        catch (NumberFormatException e) {
            QueryParserUtil.parseHexToLongUnsafe(info, hex);
        }
    }

    static void parseHexToLongUnsafe(PropertyInfo<Object> info, String hex) {
        long value = 0L;
        for (int i = 0; i < hex.length(); ++i) {
            char digit = hex.charAt(i);
            value = 16L * value + (long)Character.getNumericValue(digit);
        }
        info.setProperty(value);
    }
}

