/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisGraphDecoder;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerAbortException;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerClusterMember;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerPolicy;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.fieldfolding.IsStaticFinalFieldInitializedNode;
import com.oracle.svm.hosted.fieldfolding.MarkStaticFinalFieldInitializedNode;
import java.lang.constant.Constable;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.type.TypedConstant;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualBoxingNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyNode;
import org.graalvm.compiler.replacements.nodes.ObjectClone;
import org.graalvm.nativeimage.ImageSingletons;

public class SimulateClassInitializerGraphDecoder
extends InlineBeforeAnalysisGraphDecoder {
    protected final SimulateClassInitializerSupport support;
    protected final SimulateClassInitializerClusterMember clusterMember;
    protected final MetaAccessProvider metaAccess;
    protected final EconomicMap<VirtualObjectNode, ImageHeapConstant> allVirtualObjects = EconomicMap.create();
    protected final EconomicMap<AnalysisField, Object> currentStaticFields = EconomicMap.create();
    protected final EconomicSet<ImageHeapConstant> currentActiveObjects = EconomicSet.create();
    protected final EconomicMap<AnalysisField, Boolean> isStaticFinalFieldInitializedStates = EconomicMap.create();

    protected SimulateClassInitializerGraphDecoder(BigBang bb, SimulateClassInitializerPolicy policy, SimulateClassInitializerClusterMember clusterMember, StructuredGraph graph) {
        super(bb, (InlineBeforeAnalysisPolicy)policy, graph, clusterMember.cluster.providers, unused -> LoopExplosionPlugin.LoopExplosionKind.FULL_UNROLL);
        this.support = clusterMember.cluster.support;
        this.clusterMember = clusterMember;
        this.metaAccess = this.providers.getMetaAccess();
    }

    public void decode(ResolvedJavaMethod classInitializer) {
        for (ResolvedJavaField f : classInitializer.getDeclaringClass().getStaticFields()) {
            AnalysisField field = (AnalysisField)f;
            JavaConstant initialValue = field.getConstantValue();
            if (initialValue == null) {
                initialValue = JavaConstant.defaultForKind((JavaKind)field.getStorageKind());
            }
            this.currentStaticFields.put((Object)field, (Object)initialValue);
            this.isStaticFinalFieldInitializedStates.put((Object)field, (Object)Boolean.FALSE);
        }
        super.decode(classInitializer);
    }

    protected void maybeAbortInlining(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope, Node node) {
        InlineBeforeAnalysisGraphDecoder.InlineBeforeAnalysisMethodScope methodScope = this.cast(ms);
        if (node instanceof ControlSplitNode || node instanceof AccessMonitorNode) {
            if (this.support.collectAllReasons) {
                if (methodScope.isInlinedMethod()) {
                    this.abortInlining(methodScope);
                    return;
                }
                if (loopScope.loopDepth == 0) {
                    return;
                }
            }
            throw SimulateClassInitializerAbortException.doAbort(this.clusterMember, this.graph, node);
        }
    }

    protected void checkLoopExplosionIteration(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope) {
        if (loopScope.loopIteration > this.support.maxLoopIterations) {
            throw SimulateClassInitializerAbortException.doAbort(this.clusterMember, this.graph, "Loop iteration count exceeding unrolling limit");
        }
    }

    protected Node handleFloatingNodeBeforeAdd(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node n) {
        Node node = n;
        if (node instanceof AllocatedObjectNode) {
            AllocatedObjectNode allocatedObjectNode = (AllocatedObjectNode)node;
            node = this.handleAllocatedObjectNode(allocatedObjectNode);
        }
        return super.handleFloatingNodeBeforeAdd(methodScope, loopScope, node);
    }

    protected Node doCanonicalizeFixedNode(InlineBeforeAnalysisGraphDecoder.InlineBeforeAnalysisMethodScope methodScope, GraphDecoder.LoopScope loopScope, Node initialNode) {
        Node node = super.doCanonicalizeFixedNode(methodScope, loopScope, initialNode);
        SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope = (SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope)methodScope.policyScope;
        if (node instanceof StoreFieldNode) {
            StoreFieldNode storeFieldNode = (StoreFieldNode)node;
            node = this.handleStoreFieldNode(storeFieldNode);
        } else if (node instanceof LoadFieldNode) {
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            node = this.handleLoadFieldNode(loadFieldNode);
        } else if (node instanceof StoreIndexedNode) {
            StoreIndexedNode storeIndexedNode = (StoreIndexedNode)node;
            node = this.handleStoreIndexedNode(storeIndexedNode);
        } else if (node instanceof LoadIndexedNode) {
            LoadIndexedNode loadIndexedNode = (LoadIndexedNode)node;
            node = this.handleLoadIndexedNode(loadIndexedNode);
        } else if (node instanceof ArrayCopyNode) {
            ArrayCopyNode arrayCopyNode = (ArrayCopyNode)node;
            node = this.handleArrayCopyNode(arrayCopyNode);
        } else if (node instanceof EnsureClassInitializedNode) {
            EnsureClassInitializedNode ensureClassInitializedNode = (EnsureClassInitializedNode)node;
            node = this.handleEnsureClassInitializedNode(ensureClassInitializedNode);
        } else if (node instanceof IsStaticFinalFieldInitializedNode) {
            IsStaticFinalFieldInitializedNode isStaticFinalFieldInitializedNode = (IsStaticFinalFieldInitializedNode)node;
            node = this.handleIsStaticFinalFieldInitializedNode(isStaticFinalFieldInitializedNode);
        } else if (node instanceof MarkStaticFinalFieldInitializedNode) {
            MarkStaticFinalFieldInitializedNode markStaticFinalFieldInitializedNode = (MarkStaticFinalFieldInitializedNode)node;
            node = this.handleMarkStaticFinalFieldInitializedNode(markStaticFinalFieldInitializedNode);
        } else if (node instanceof AccessMonitorNode) {
            AccessMonitorNode accessMonitorNode = (AccessMonitorNode)node;
            node = this.handleAccessMonitorNode(accessMonitorNode);
        } else if (node instanceof CommitAllocationNode) {
            CommitAllocationNode commitAllocationNode = (CommitAllocationNode)node;
            this.handleCommitAllocationNode(countersScope, commitAllocationNode);
        } else if (node instanceof NewInstanceNode) {
            NewInstanceNode newInstanceNode = (NewInstanceNode)node;
            node = this.handleNewInstanceNode(countersScope, newInstanceNode);
        } else if (node instanceof NewArrayNode) {
            NewArrayNode newArrayNode = (NewArrayNode)node;
            node = this.handleNewArrayNode(countersScope, newArrayNode);
        } else if (node instanceof NewMultiArrayNode) {
            NewMultiArrayNode newMultiArrayNode = (NewMultiArrayNode)node;
            node = this.handleNewMultiArrayNode(countersScope, newMultiArrayNode);
        } else if (node instanceof BoxNode) {
            BoxNode boxNode = (BoxNode)node;
            node = this.handleBoxNode(boxNode);
        } else if (node instanceof ObjectClone) {
            ObjectClone objectClone = (ObjectClone)node;
            node = this.handleObjectClone(countersScope, objectClone);
        }
        if (node instanceof AbstractBeginNode && node.predecessor() instanceof ControlSplitNode) {
            if (!this.support.collectAllReasons) {
                throw SimulateClassInitializerAbortException.doAbort(this.clusterMember, this.graph, node.predecessor());
            }
            this.currentActiveObjects.clear();
            this.currentStaticFields.clear();
            this.isStaticFinalFieldInitializedStates.clear();
        }
        return node;
    }

    private Node handleStoreFieldNode(StoreFieldNode node) {
        AnalysisField field = (AnalysisField)node.field();
        if (field.isStatic()) {
            this.currentStaticFields.put((Object)field, (Object)node.value());
        } else {
            ImageHeapInstance object = this.asActiveImageHeapInstance(node.object());
            JavaConstant value = node.value().asJavaConstant();
            if (object != null && value != null) {
                object.setFieldValue(field, this.adaptForImageHeap(value, field.getStorageKind()));
                return null;
            }
        }
        return node;
    }

    private Node handleLoadFieldNode(LoadFieldNode node) {
        AnalysisField field = (AnalysisField)node.field();
        if (field.isStatic()) {
            Object currentValue = this.currentStaticFields.get((Object)field);
            if (currentValue instanceof ValueNode) {
                ValueNode currentValueNode = (ValueNode)currentValue;
                return currentValueNode;
            }
            if (currentValue instanceof JavaConstant) {
                JavaConstant currentConstant = (JavaConstant)currentValue;
                return ConstantNode.forConstant((JavaConstant)currentConstant, (MetaAccessProvider)this.metaAccess);
            }
            assert (currentValue == null) : "Unexpected static field value: " + currentValue;
            ConstantNode canonicalized = this.support.tryCanonicalize(this.bb, node);
            if (canonicalized != null) {
                return canonicalized;
            }
        } else {
            ImageHeapInstance object = this.asActiveImageHeapInstance(node.object());
            if (object != null) {
                JavaConstant currentValue = (JavaConstant)object.getFieldValue(field);
                return ConstantNode.forConstant((JavaConstant)currentValue, (MetaAccessProvider)this.metaAccess);
            }
        }
        return node;
    }

    private Node handleStoreIndexedNode(StoreIndexedNode node) {
        ImageHeapArray array = this.asActiveImageHeapArray(node.array());
        JavaConstant value = node.value().asJavaConstant();
        int idx = SimulateClassInitializerGraphDecoder.asIntegerOrMinusOne(node.index());
        if (array != null && value != null && idx >= 0 && idx < array.getLength()) {
            AnalysisType componentType = (AnalysisType)array.getType(this.metaAccess).getComponentType();
            if (node.elementKind().isPrimitive() || value.isNull() || componentType.isAssignableFrom(((TypedConstant)value).getType(this.metaAccess))) {
                array.setElement(idx, this.adaptForImageHeap(value, componentType.getStorageKind()));
                return null;
            }
        }
        return node;
    }

    private Node handleLoadIndexedNode(LoadIndexedNode node) {
        ImageHeapArray array = this.asActiveImageHeapArray(node.array());
        int idx = SimulateClassInitializerGraphDecoder.asIntegerOrMinusOne(node.index());
        if (array != null && idx >= 0 && idx < array.getLength()) {
            JavaConstant currentValue = (JavaConstant)array.getElement(idx);
            return ConstantNode.forConstant((JavaConstant)currentValue, (MetaAccessProvider)this.metaAccess);
        }
        return node;
    }

    private Node handleArrayCopyNode(ArrayCopyNode node) {
        if (this.handleArrayCopy(this.asActiveImageHeapArray(node.getSource()), SimulateClassInitializerGraphDecoder.asIntegerOrMinusOne(node.getSourcePosition()), this.asActiveImageHeapArray(node.getDestination()), SimulateClassInitializerGraphDecoder.asIntegerOrMinusOne(node.getDestinationPosition()), SimulateClassInitializerGraphDecoder.asIntegerOrMinusOne(node.getLength()))) {
            return null;
        }
        return node;
    }

    protected boolean handleArrayCopy(ImageHeapArray source, int sourcePos, ImageHeapArray dest, int destPos, int length) {
        int i;
        if (source == null || sourcePos < 0 || sourcePos >= source.getLength() || dest == null || destPos < 0 || destPos >= dest.getLength() || length < 0 || sourcePos > source.getLength() - length || destPos > dest.getLength() - length) {
            return false;
        }
        AnalysisType sourceComponentType = (AnalysisType)source.getType(this.metaAccess).getComponentType();
        AnalysisType destComponentType = (AnalysisType)dest.getType(this.metaAccess).getComponentType();
        if (sourceComponentType.getJavaKind() != destComponentType.getJavaKind()) {
            return false;
        }
        if (destComponentType.getJavaKind() == JavaKind.Object && !destComponentType.isJavaLangObject() && !sourceComponentType.equals((Object)destComponentType)) {
            for (i = 0; i < length; ++i) {
                ResolvedJavaType elementValueType;
                JavaConstant elementValue = (JavaConstant)source.getElement(sourcePos + i);
                if (!elementValue.isNonNull() || destComponentType.isAssignableFrom(elementValueType = ((TypedConstant)elementValue).getType(this.metaAccess))) continue;
                return false;
            }
        }
        if (source == dest && sourcePos < destPos) {
            for (i = length - 1; i >= 0; --i) {
                dest.setElement(destPos + i, (JavaConstant)source.getElement(sourcePos + i));
            }
        } else {
            for (i = 0; i < length; ++i) {
                dest.setElement(destPos + i, (JavaConstant)source.getElement(sourcePos + i));
            }
        }
        return true;
    }

    private Node handleEnsureClassInitializedNode(EnsureClassInitializedNode node) {
        AnalysisType classInitType = (AnalysisType)node.constantTypeOrNull(this.providers.getConstantReflection());
        if (classInitType != null) {
            if (this.support.trySimulateClassInitializer(this.graph.getDebug(), classInitType, this.clusterMember)) {
                return null;
            }
            SimulateClassInitializerClusterMember classInitTypeMember = (SimulateClassInitializerClusterMember)this.clusterMember.cluster.clusterMembers.get((Object)classInitType);
            if (classInitTypeMember != null && !classInitTypeMember.status.published) {
                this.clusterMember.dependencies.add((Object)classInitTypeMember);
                return null;
            }
        }
        return node;
    }

    private Node handleIsStaticFinalFieldInitializedNode(IsStaticFinalFieldInitializedNode node) {
        AnalysisField field = (AnalysisField)node.getField();
        Boolean isStaticFinalFieldInitialized = (Boolean)this.isStaticFinalFieldInitializedStates.get((Object)field);
        if (isStaticFinalFieldInitialized != null) {
            return ConstantNode.forBoolean((boolean)isStaticFinalFieldInitialized);
        }
        if (this.support.trySimulateClassInitializer(this.graph.getDebug(), field.getDeclaringClass(), this.clusterMember)) {
            return ConstantNode.forBoolean((boolean)true);
        }
        return node;
    }

    private Node handleMarkStaticFinalFieldInitializedNode(MarkStaticFinalFieldInitializedNode node) {
        AnalysisField field = (AnalysisField)node.getField();
        this.isStaticFinalFieldInitializedStates.put((Object)field, (Object)Boolean.TRUE);
        return node;
    }

    private Node handleAccessMonitorNode(AccessMonitorNode node) {
        ImageHeapConstant object = this.asActiveImageHeapConstant(node.object());
        if (object != null) {
            return null;
        }
        return node;
    }

    private Node handleAllocatedObjectNode(AllocatedObjectNode node) {
        ImageHeapConstant imageHeapConstant = (ImageHeapConstant)this.allVirtualObjects.get((Object)node.getVirtualObject());
        if (imageHeapConstant != null) {
            return ConstantNode.forConstant((JavaConstant)imageHeapConstant, (MetaAccessProvider)this.metaAccess);
        }
        return node;
    }

    private ValueNode handleNewInstanceNode(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, NewInstanceNode node) {
        AnalysisType type = (AnalysisType)node.instanceClass();
        if (this.accumulateNewInstanceSize(countersScope, type, (Node)node)) {
            ImageHeapInstance instance = new ImageHeapInstance((ResolvedJavaType)type);
            for (ResolvedJavaField field : type.getInstanceFields(true)) {
                AnalysisField aField = (AnalysisField)field;
                instance.setFieldValue(aField, JavaConstant.defaultForKind((JavaKind)aField.getStorageKind()));
            }
            this.currentActiveObjects.add((Object)instance);
            return ConstantNode.forConstant((JavaConstant)instance, (MetaAccessProvider)this.metaAccess);
        }
        return node;
    }

    private ValueNode handleNewArrayNode(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, NewArrayNode node) {
        int length;
        AnalysisType arrayType = (AnalysisType)node.elementType().getArrayClass();
        if (this.accumulateNewArraySize(countersScope, arrayType, length = SimulateClassInitializerGraphDecoder.asIntegerOrMinusOne(node.length()), (Node)node)) {
            ImageHeapArray array = this.createNewArray(arrayType, length);
            return ConstantNode.forConstant((JavaConstant)array, (MetaAccessProvider)this.metaAccess);
        }
        return node;
    }

    protected ImageHeapArray createNewArray(AnalysisType arrayType, int length) {
        ImageHeapArray array = ImageHeapArray.create((AnalysisType)arrayType, (int)length);
        JavaConstant defaultValue = JavaConstant.defaultForKind((JavaKind)arrayType.getComponentType().getStorageKind());
        for (int i = 0; i < length; ++i) {
            array.setElement(i, defaultValue);
        }
        this.currentActiveObjects.add((Object)array);
        return array;
    }

    private ValueNode handleNewMultiArrayNode(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, NewMultiArrayNode node) {
        int[] dimensions = new int[node.dimensionCount()];
        long totalLength = 1L;
        AnalysisType curArrayType = (AnalysisType)node.type();
        for (int i = 0; i < dimensions.length; ++i) {
            int length = SimulateClassInitializerGraphDecoder.asIntegerOrMinusOne(node.dimension(i));
            if (!this.accumulateNewArraySize(countersScope, curArrayType, totalLength *= (long)length, (Node)node)) {
                return node;
            }
            dimensions[i] = length;
            curArrayType = curArrayType.getComponentType();
        }
        ImageHeapArray array = this.createNewMultiArray((AnalysisType)node.type(), 0, dimensions);
        return ConstantNode.forConstant((JavaConstant)array, (MetaAccessProvider)this.metaAccess);
    }

    private ImageHeapArray createNewMultiArray(AnalysisType curArrayType, int curDimension, int[] dimensions) {
        int curLength = dimensions[curDimension];
        int nextDimension = curDimension + 1;
        if (nextDimension == dimensions.length) {
            return this.createNewArray(curArrayType, curLength);
        }
        AnalysisType nextArrayType = curArrayType.getComponentType();
        ImageHeapArray array = ImageHeapArray.create((AnalysisType)curArrayType, (int)dimensions[curDimension]);
        for (int i = 0; i < curLength; ++i) {
            array.setElement(i, (JavaConstant)this.createNewMultiArray(nextArrayType, nextDimension, dimensions));
        }
        this.currentActiveObjects.add((Object)array);
        return array;
    }

    private ValueNode handleBoxNode(BoxNode node) {
        JavaConstant value = node.getValue().asJavaConstant();
        if (value == null || node.hasIdentity()) {
            return node;
        }
        Constable boxedValue = switch (node.getBoxingKind()) {
            case JavaKind.Byte -> (byte)value.asInt();
            case JavaKind.Boolean -> Boolean.valueOf(value.asInt() != 0);
            case JavaKind.Short -> (short)value.asInt();
            case JavaKind.Char -> Character.valueOf((char)value.asInt());
            case JavaKind.Int -> value.asInt();
            case JavaKind.Long -> value.asLong();
            case JavaKind.Float -> Float.valueOf(value.asFloat());
            case JavaKind.Double -> value.asDouble();
            default -> throw VMError.shouldNotReachHere("Unexpected kind", node.getBoxingKind());
        };
        return ConstantNode.forConstant((JavaConstant)this.providers.getSnippetReflection().forObject((Object)boxedValue), (MetaAccessProvider)this.metaAccess);
    }

    private ValueNode handleObjectClone(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, ObjectClone node) {
        JavaConstant original;
        ImageHeapConstant originalImageHeapConstant = this.asActiveImageHeapConstant(node.getObject());
        if (originalImageHeapConstant != null) {
            ImageHeapArray originalArray;
            AnalysisType type = (AnalysisType)originalImageHeapConstant.getType(this.metaAccess);
            if (originalImageHeapConstant instanceof ImageHeapArray && this.accumulateNewArraySize(countersScope, type, (originalArray = (ImageHeapArray)originalImageHeapConstant).getLength(), (Node)node.asNode()) || type.isCloneableWithAllocation() && this.accumulateNewInstanceSize(countersScope, type, (Node)node.asNode())) {
                ImageHeapConstant cloned = originalImageHeapConstant.forObjectClone();
                this.currentActiveObjects.add((Object)cloned);
                return ConstantNode.forConstant((JavaConstant)cloned, (MetaAccessProvider)this.metaAccess);
            }
        }
        if ((original = node.getObject().asJavaConstant()) != null && ((ConstantNode)node.getObject()).getStableDimension() > 0) {
            AnalysisType arrayType = (AnalysisType)this.metaAccess.lookupJavaType(original);
            Integer length = this.providers.getConstantReflection().readArrayLength(original);
            if (length != null && this.accumulateNewArraySize(countersScope, arrayType, length.intValue(), (Node)node.asNode())) {
                ImageHeapArray array = ImageHeapArray.create((AnalysisType)arrayType, (int)length);
                for (int i = 0; i < length; ++i) {
                    array.setElement(i, this.adaptForImageHeap(this.providers.getConstantReflection().readArrayElement(original, i), arrayType.getComponentType().getStorageKind()));
                }
                this.currentActiveObjects.add((Object)array);
                return ConstantNode.forConstant((JavaConstant)array, (MetaAccessProvider)this.metaAccess);
            }
        }
        return node.asNode();
    }

    private void handleCommitAllocationNode(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, CommitAllocationNode node) {
        boolean progress;
        do {
            progress = false;
            int pos = 0;
            for (int i = 0; i < node.getVirtualObjects().size(); ++i) {
                VirtualObjectNode virtualObject = (VirtualObjectNode)node.getVirtualObjects().get(i);
                int entryCount = virtualObject.entryCount();
                List<ValueNode> entries = node.getValues().subList(pos, pos + entryCount);
                pos += entryCount;
                if (!node.getLocks(i).isEmpty() || ((Boolean)node.getEnsureVirtual().get(i)).booleanValue() || this.allVirtualObjects.containsKey((Object)virtualObject)) continue;
                if (virtualObject instanceof VirtualBoxingNode) {
                    VMError.shouldNotReachHere("For testing: check if this is reachable");
                    continue;
                }
                if (virtualObject instanceof VirtualInstanceNode) {
                    VirtualInstanceNode virtualInstance = (VirtualInstanceNode)virtualObject;
                    progress |= this.handleVirtualInstance(countersScope, virtualInstance, entries, (Node)node);
                    continue;
                }
                if (virtualObject instanceof VirtualArrayNode) {
                    VirtualArrayNode virtualArray = (VirtualArrayNode)virtualObject;
                    progress |= this.handleVirtualArray(countersScope, virtualArray, entries, (Node)node);
                    continue;
                }
                throw VMError.shouldNotReachHere(virtualObject.toString());
            }
        } while (progress);
    }

    private boolean handleVirtualInstance(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, VirtualInstanceNode virtualInstance, List<ValueNode> entries, Node reason) {
        AnalysisType type = (AnalysisType)virtualInstance.type();
        if (!this.accumulateNewInstanceSize(countersScope, type, reason)) {
            return false;
        }
        ImageHeapInstance instance = new ImageHeapInstance((ResolvedJavaType)type);
        for (int j = 0; j < virtualInstance.entryCount(); ++j) {
            JavaConstant entry = this.lookupConstantEntry(j, entries);
            if (entry == null) {
                return false;
            }
            AnalysisField field = (AnalysisField)virtualInstance.field(j);
            instance.setFieldValue(field, this.adaptForImageHeap(entry, field.getStorageKind()));
        }
        this.allVirtualObjects.put((Object)virtualInstance, (Object)instance);
        this.currentActiveObjects.add((Object)instance);
        return true;
    }

    private boolean handleVirtualArray(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, VirtualArrayNode virtualArray, List<ValueNode> entries, Node reason) {
        int length;
        AnalysisType arrayType = (AnalysisType)virtualArray.type();
        if (!this.accumulateNewArraySize(countersScope, arrayType, length = virtualArray.entryCount(), reason)) {
            return false;
        }
        ImageHeapArray array = ImageHeapArray.create((AnalysisType)arrayType, (int)length);
        for (int j = 0; j < length; ++j) {
            JavaConstant entry = this.lookupConstantEntry(j, entries);
            if (entry == null) {
                return false;
            }
            array.setElement(j, this.adaptForImageHeap(entry, arrayType.getComponentType().getStorageKind()));
        }
        this.allVirtualObjects.put((Object)virtualArray, (Object)array);
        this.currentActiveObjects.add((Object)array);
        return true;
    }

    private JavaConstant lookupConstantEntry(int index, List<ValueNode> entries) {
        ValueNode entry = entries.get(index);
        if (entry instanceof VirtualObjectNode) {
            VirtualObjectNode virtualObjectNode = (VirtualObjectNode)entry;
            return (JavaConstant)this.allVirtualObjects.get((Object)virtualObjectNode);
        }
        return entry.asJavaConstant();
    }

    protected boolean accumulateNewInstanceSize(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, AnalysisType type, Node reason) {
        assert (type.isInstanceClass()) : type;
        ObjectLayout objectLayout = (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class);
        long allocationSize = objectLayout.getFirstFieldOffset();
        for (ResolvedJavaField field : type.getInstanceFields(true)) {
            allocationSize += (long)objectLayout.sizeInBytes(((AnalysisField)field).getStorageKind());
        }
        return this.accumulatedNewObjectSize(countersScope, allocationSize, reason);
    }

    protected boolean accumulateNewArraySize(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, AnalysisType arrayType, long length, Node reason) {
        if (length < 0L) {
            return false;
        }
        ObjectLayout objectLayout = (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class);
        long allocationSize = objectLayout.getArraySize(arrayType.getComponentType().getStorageKind(), (int)length, true);
        return this.accumulatedNewObjectSize(countersScope, allocationSize, reason);
    }

    private boolean accumulatedNewObjectSize(SimulateClassInitializerPolicy.SimulateClassInitializerInlineScope countersScope, long allocationSize, Node reason) {
        if (countersScope.accumulativeCounters.allocatedBytes + allocationSize > (long)this.support.maxAllocatedBytes) {
            if (this.debug.isLogEnabled(1)) {
                this.debug.log("object size %s too large since already %s allocated: %s %s", (Object)allocationSize, (Object)countersScope.accumulativeCounters.allocatedBytes, (Object)reason, (Object)reason.getNodeSourcePosition());
            }
            if (this.support.collectAllReasons) {
                return false;
            }
            throw SimulateClassInitializerAbortException.doAbort(this.clusterMember, this.graph, reason);
        }
        countersScope.accumulativeCounters.allocatedBytes += allocationSize;
        countersScope.allocatedBytes += allocationSize;
        return true;
    }

    protected ImageHeapConstant asActiveImageHeapConstant(ValueNode node) {
        ImageHeapConstant imageHeapConstant;
        JavaConstant constant = node.asJavaConstant();
        if (constant instanceof ImageHeapConstant && this.currentActiveObjects.contains((Object)(imageHeapConstant = (ImageHeapConstant)constant))) {
            return imageHeapConstant;
        }
        return null;
    }

    protected ImageHeapInstance asActiveImageHeapInstance(ValueNode node) {
        ImageHeapInstance imageHeapInstance;
        JavaConstant constant = node.asJavaConstant();
        if (constant instanceof ImageHeapInstance && this.currentActiveObjects.contains((Object)(imageHeapInstance = (ImageHeapInstance)constant))) {
            return imageHeapInstance;
        }
        return null;
    }

    protected ImageHeapArray asActiveImageHeapArray(ValueNode node) {
        ImageHeapArray imageHeapArray;
        JavaConstant constant = node.asJavaConstant();
        if (constant instanceof ImageHeapArray && this.currentActiveObjects.contains((Object)(imageHeapArray = (ImageHeapArray)constant))) {
            return imageHeapArray;
        }
        return null;
    }

    protected static int asIntegerOrMinusOne(ValueNode node) {
        JavaConstant constant = node.asJavaConstant();
        if (constant != null) {
            return constant.asInt();
        }
        return -1;
    }

    private JavaConstant adaptForImageHeap(JavaConstant value, JavaKind storageKind) {
        if (value.getJavaKind() != storageKind) {
            assert (value instanceof PrimitiveConstant && value.getJavaKind().getStackKind() == storageKind.getStackKind()) : "only sub-int values can have a mismatch of the JavaKind: " + value.getJavaKind() + ", " + storageKind;
            return JavaConstant.forPrimitive((JavaKind)storageKind, (long)value.asLong());
        }
        if (storageKind == JavaKind.Object && !(value instanceof ImageHeapConstant)) {
            return this.bb.getUniverse().getHeapScanner().createImageHeapConstant(value, (ObjectScanner.ScanReason)new ObjectScanner.OtherReason("SimulateClassInitializerGraphDecoder"));
        }
        return value;
    }
}

