/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.HeapSizeVerifier;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.NotifyGCRuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.word.WordFactory;

public class SubstrateGCOptions {
    public static final RuntimeOptionKey<Long> MinHeapSize = new NotifyGCRuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable}){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                HeapSizeVerifier.verifyMinHeapSizeAgainstAddressSpace(WordFactory.unsigned((long)newValue));
            }
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final RuntimeOptionKey<Long> MaxHeapSize = new NotifyGCRuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable}){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                HeapSizeVerifier.verifyMaxHeapSizeAgainstAddressSpace(WordFactory.unsigned((long)newValue));
            }
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final RuntimeOptionKey<Long> MaxNewSize = new NotifyGCRuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable}){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                HeapSizeVerifier.verifyMaxNewSizeAgainstAddressSpace(WordFactory.unsigned((long)newValue));
            }
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final RuntimeOptionKey<Long> ReservedAddressSpaceSize = new RuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> ExitOnOutOfMemoryError = new NotifyGCRuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> ReportFatalErrorOnOutOfMemoryError = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> DisableExplicitGC = new NotifyGCRuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> PrintGC = new NotifyGCRuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> VerboseGC = new NotifyGCRuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> VerifyHeap = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> TreatRuntimeCodeInfoReferencesAsWeak = new HostedOptionKey<Boolean>(true);
}

