/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ConfigurationFiles {
    public static List<Path> findConfigurationFiles(String fileName) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (Path configDir : Options.ConfigurationFileDirectories.getValue().values()) {
            if (Files.exists(configDir.resolve(".lock"), new LinkOption[0])) {
                throw ConfigurationFiles.foundLockFile("Configuration file directory '" + configDir + "'");
            }
            Path path = configDir.resolve(fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            files.add(path);
        }
        return files;
    }

    public static List<URL> findConfigurationResources(String fileName, ClassLoader classLoader) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (String root : Options.ConfigurationResourceRoots.getValue().values()) {
            String separator = "/";
            String relativeRoot = Stream.of(root.split("/")).filter(part -> !part.isEmpty() && !part.equals(".")).collect(Collectors.joining("/"));
            try {
                Object lockPath = relativeRoot.isEmpty() ? ".lock" : relativeRoot + "/.lock";
                Enumeration<URL> resource = classLoader.getResources((String)lockPath);
                if (resource != null && resource.hasMoreElements()) {
                    throw ConfigurationFiles.foundLockFile("Configuration resource root '" + root + "'");
                }
            }
            catch (IOException lockPath) {
                // empty catch block
            }
            String relativePath = relativeRoot.isEmpty() ? fileName : relativeRoot + "/" + fileName;
            try {
                Enumeration<URL> e = classLoader.getResources(relativePath);
                while (e.hasMoreElements()) {
                    resources.add(e.nextElement());
                }
            }
            catch (IOException e) {
                throw UserError.abort(e, "Error while looking for %s in %s", fileName, root);
            }
        }
        return resources;
    }

    private static UserError.UserException foundLockFile(String container) {
        throw UserError.abort("%s contains file '%s', which means an agent is currently writing to it.The agent must finish execution before its generated configuration can be used to build a native image.Unless the lock file is a leftover from an earlier process that terminated abruptly, it is unsafe to delete it.", container, ".lock");
    }

    public static final class Options {
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<LocatableMultiOptionValue.Paths> ConfigurationFileDirectories = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ConfigurationResourceRoots = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> ReflectionConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ReflectionConfigurationResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> DynamicProxyConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DynamicProxyConfigurationResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> SerializationConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> SerializationConfigurationResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> SerializationDenyConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> SerializationDenyConfigurationResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> ResourceConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ResourceConfigurationResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> JNIConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> JNIConfigurationResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> ForeignConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ForeignResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<LocatableMultiOptionValue.Paths> PredefinedClassesConfigurationFiles = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> PredefinedClassesConfigurationResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        public static final HostedOptionKey<Boolean> StrictConfiguration = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> WarnAboutMissingReflectionOrJNIMetadataElements = new HostedOptionKey<Boolean>(false);
    }
}

