/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.graal.stackvalue.LoweredStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;

public class StackValueRecursionDepthPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (LoweredStackValueNode node : graph.getNodes(LoweredStackValueNode.TYPE)) {
            if (node.slotIdentity.shared) continue;
            int recursionDepth = StackValueRecursionDepthPhase.computeRecursionDepth(node);
            node.setRecursionDepth(recursionDepth);
        }
    }

    private static int computeRecursionDepth(StackValueNode node) {
        int result = 0;
        FrameState cur = node.stateAfter();
        ResolvedJavaMethod method = cur.getMethod();
        while ((cur = cur.outerFrameState()) != null) {
            if (!method.equals(cur.getMethod())) continue;
            ++result;
        }
        return result;
    }
}

