/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.URLProtocolsSupport;
import com.oracle.svm.core.jdk.resources.ResourceURLConnection;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JavaNetSubstitutions {
    public static final String FILE_PROTOCOL = "file";
    public static final String RESOURCE_PROTOCOL = "resource";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    static final List<String> defaultProtocols = Arrays.asList("file", "resource");
    static final List<String> onDemandProtocols = Arrays.asList("http", "https");
    static final String enableProtocolsOption = SubstrateOptionsParser.commandArgument(SubstrateOptions.EnableURLProtocols, "");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static boolean addURLStreamHandler(String protocol) {
        if (RESOURCE_PROTOCOL.equals(protocol)) {
            URLStreamHandler resourcesURLStreamHandler = JavaNetSubstitutions.createResourcesURLStreamHandler();
            URLProtocolsSupport.put(RESOURCE_PROTOCOL, resourcesURLStreamHandler);
            return true;
        }
        try {
            URLStreamHandler handler = (URLStreamHandler)ReflectionUtil.lookupMethod(URL.class, (String)"getURLStreamHandler", (Class[])new Class[]{String.class}).invoke(null, protocol);
            if (handler != null) {
                URLProtocolsSupport.put(protocol, handler);
                return true;
            }
            return false;
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    static URLStreamHandler getURLStreamHandler(String protocol) throws MalformedURLException {
        URLStreamHandler result = URLProtocolsSupport.get(protocol);
        if (result == null) {
            if (onDemandProtocols.contains(protocol)) {
                JavaNetSubstitutions.unsupported("Accessing a URL protocol that was not enabled. The URL protocol " + protocol + " is supported but not enabled by default. It must be enabled by adding the " + enableProtocolsOption + protocol + " option to the native-image command.");
            } else {
                JavaNetSubstitutions.unsupported("Accessing a URL protocol that was not enabled. The URL protocol " + protocol + " is not tested and might not work as expected. It can be enabled by adding the " + enableProtocolsOption + protocol + " option to the native-image command.");
            }
        }
        return result;
    }

    static URLStreamHandler createResourcesURLStreamHandler() {
        return new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) {
                return new ResourceURLConnection(url);
            }
        };
    }

    private static void unsupported(String message) throws MalformedURLException {
        throw new MalformedURLException(message);
    }

    static String supportedProtocols() {
        return "Supported URL protocols enabled by default: " + String.join((CharSequence)",", defaultProtocols) + ". Supported URL protocols available on demand: " + String.join((CharSequence)",", onDemandProtocols) + ".";
    }
}

