/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrRepository;
import com.oracle.svm.core.jfr.JfrSymbolRepository;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.JfrTypeRepository;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.jfr.utils.JfrVisited;
import com.oracle.svm.core.jfr.utils.JfrVisitedTable;
import com.oracle.svm.core.locks.VMMutex;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

public class JfrMethodRepository
implements JfrRepository {
    private final VMMutex mutex;
    private final JfrMethodEpochData epochData0 = new JfrMethodEpochData();
    private final JfrMethodEpochData epochData1 = new JfrMethodEpochData();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrMethodRepository() {
        this.mutex = new VMMutex("jfrMethodRepository");
    }

    @Uninterruptible(reason="Releasing repository buffers.")
    public void teardown() {
        this.epochData0.teardown();
        this.epochData1.teardown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition and result is only valid until epoch changes.", callerMustBe=true)
    public long getMethodId(Class<?> clazz, String methodName, int methodId) {
        assert (clazz != null);
        assert (methodName != null);
        assert (methodId > 0);
        JfrVisited jfrVisited = (JfrVisited)StackValue.get(JfrVisited.class);
        jfrVisited.setId(methodId);
        jfrVisited.setHash(methodId);
        this.mutex.lockNoTransition();
        try {
            JfrMethodEpochData epochData = this.getEpochData(false);
            if (!epochData.table.putIfAbsent(jfrVisited)) {
                long l = methodId;
                return l;
            }
            if (epochData.buffer.isNull()) {
                epochData.buffer = JfrBufferAccess.allocate(JfrBufferType.C_HEAP);
            }
            JfrSymbolRepository symbolRepo = SubstrateJVM.getSymbolRepository();
            JfrTypeRepository typeRepo = SubstrateJVM.getTypeRepository();
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initialize(data, epochData.buffer);
            JfrNativeEventWriter.putLong(data, methodId);
            JfrNativeEventWriter.putLong(data, typeRepo.getClassId(clazz));
            JfrNativeEventWriter.putLong(data, symbolRepo.getSymbolId(methodName, false));
            JfrNativeEventWriter.putLong(data, symbolRepo.getSymbolId("()V", false));
            JfrNativeEventWriter.putShort(data, (short)0);
            JfrNativeEventWriter.putBoolean(data, false);
            if (!JfrNativeEventWriter.commit(data)) {
                long l = methodId;
                return l;
            }
            ++epochData.unflushedEntries;
            epochData.buffer = data.getJfrBuffer();
            long l = methodId;
            return l;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public int write(JfrChunkWriter writer, boolean flushpoint) {
        this.mutex.lockNoTransition();
        try {
            JfrMethodEpochData epochData = this.getEpochData(!flushpoint);
            int count = epochData.unflushedEntries;
            if (count != 0) {
                writer.writeCompressedLong(JfrType.Method.getId());
                writer.writeCompressedInt(count);
                writer.write(epochData.buffer);
            }
            epochData.clear(flushpoint);
            int n = count == 0 ? 0 : 1;
            return n;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Prevent epoch change.", callerMustBe=true)
    private JfrMethodEpochData getEpochData(boolean previousEpoch) {
        boolean epoch = previousEpoch ? JfrTraceIdEpoch.getInstance().previousEpoch() : JfrTraceIdEpoch.getInstance().currentEpoch();
        return epoch ? this.epochData0 : this.epochData1;
    }

    private static class JfrMethodEpochData {
        private final JfrVisitedTable table = new JfrVisitedTable();
        private int unflushedEntries = 0;
        private JfrBuffer buffer;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrMethodEpochData() {
        }

        @Uninterruptible(reason="May write current epoch data.")
        void clear(boolean flushpoint) {
            if (!flushpoint) {
                this.table.clear();
            }
            this.unflushedEntries = 0;
            JfrBufferAccess.reinitialize(this.buffer);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        void teardown() {
            this.table.teardown();
            this.unflushedEntries = 0;
            JfrBufferAccess.free(this.buffer);
            this.buffer = (JfrBuffer)WordFactory.nullPointer();
        }
    }
}

