/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Sched;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.posix.linux.LinuxLibCHelper;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={VMThreads.class})
public final class PosixVMThreads
extends VMThreads {
    private static final CGlobalData<CCharPointer> FAIL_FATALLY_FDOPEN_MODE = CGlobalDataFactory.createCString("w");
    private static final CGlobalData<CCharPointer> FAIL_FATALLY_MESSAGE_FORMAT = CGlobalDataFactory.createCString("Fatal error: %s (code %d)\n");

    @Fold
    public static PosixVMThreads singleton() {
        return (PosixVMThreads)ImageSingletons.lookup(VMThreads.class);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMThreads.OSThreadHandle getCurrentOSThreadHandle() {
        return Pthread.pthread_self();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected VMThreads.OSThreadId getCurrentOSThreadId() {
        if (Platform.includedIn(Platform.DARWIN.class)) {
            Pthread.pthread_t pthread = Pthread.pthread_self();
            return (VMThreads.OSThreadId)WordFactory.unsigned((int)DarwinPthread.pthread_mach_thread_np(pthread));
        }
        if (Platform.includedIn(Platform.LINUX.class)) {
            int result = LinuxLibCHelper.getThreadId();
            VMError.guarantee(result != -1, "SYS_gettid failed");
            return (VMThreads.OSThreadId)WordFactory.signed((int)result);
        }
        throw VMError.unsupportedFeature("PosixVMThreads.getCurrentOSThreadId() on unknown OS");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void joinNoTransition(VMThreads.OSThreadHandle osThreadHandle) {
        Pthread.pthread_t pthread = (Pthread.pthread_t)osThreadHandle;
        PosixUtils.checkStatusIs0(Pthread.pthread_join_no_transition(pthread, (WordPointer)WordFactory.nullPointer()), "Pthread.joinNoTransition");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void nativeSleep(int milliseconds) {
        Time.timespec ts = (Time.timespec)StackValue.get(Time.timespec.class);
        ts.set_tv_sec((long)milliseconds / 1000L);
        ts.set_tv_nsec((long)milliseconds % 1000L * 1000000L);
        Time.NoTransitions.nanosleep(ts, (Time.timespec)WordFactory.nullPointer());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void yield() {
        Sched.NoTransitions.sched_yield();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean supportsNativeYieldAndSleep() {
        return true;
    }

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    protected boolean initializeOnce() {
        return PthreadVMLockSupport.initialize();
    }

    @CFunction(value="fdopen", transition=CFunction.Transition.NO_TRANSITION)
    private static native FILE fdopen(int var0, CCharPointer var1);

    @CFunction(value="fprintfSD", transition=CFunction.Transition.NO_TRANSITION)
    private static native int fprintfSD(FILE var0, CCharPointer var1, CCharPointer var2, int var3);

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    public void failFatally(int code, CCharPointer message) {
        FILE stderr = PosixVMThreads.fdopen(2, FAIL_FATALLY_FDOPEN_MODE.get());
        PosixVMThreads.fprintfSD(stderr, FAIL_FATALLY_MESSAGE_FORMAT.get(), message, code);
        LibC.exit(code);
    }

    static interface FILE
    extends PointerBase {
    }

    @AutomaticallyRegisteredImageSingleton(value={VMThreads.ThreadLookup.class})
    public static class PosixThreadLookup
    extends VMThreads.ThreadLookup {
        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public ComparableWord getThreadIdentifier() {
            return PosixVMThreads.singleton().getCurrentOSThreadHandle();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean matchesThread(IsolateThread thread, ComparableWord identifier) {
            return VMThreads.OSThreadHandleTL.get(thread).notEqual(identifier);
        }
    }
}

