/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class WindowsVMCondition
extends VMCondition {
    private final CIsolateData<Process.CONDITION_VARIABLE> structPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    WindowsVMCondition(WindowsVMMutex mutex) {
        super(mutex);
        this.structPointer = CIsolateDataFactory.createStruct("windowsCondition_" + mutex.getName(), Process.CONDITION_VARIABLE.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Process.PCONDITION_VARIABLE getStructPointer() {
        return (Process.PCONDITION_VARIABLE)((Object)this.structPointer.get());
    }

    @Override
    public void block() {
        this.mutex.clearCurrentThreadOwner();
        WindowsVMLockSupport.checkResult(Process.SleepConditionVariableCS(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), SynchAPI.INFINITE()), "SleepConditionVariableCS");
        this.mutex.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransition() {
        this.mutex.clearCurrentThreadOwner();
        WindowsVMLockSupport.checkResult(Process.NoTransitions.SleepConditionVariableCS(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), SynchAPI.INFINITE()), "SleepConditionVariableCS");
        this.mutex.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransitionUnspecifiedOwner() {
        this.mutex.clearUnspecifiedOwner();
        WindowsVMLockSupport.checkResult(Process.NoTransitions.SleepConditionVariableCS(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), SynchAPI.INFINITE()), "SleepConditionVariableCS");
        this.mutex.setOwnerToUnspecified();
    }

    @Override
    public long block(long waitNanos) {
        assert (waitNanos >= 0L);
        long startTimeInNanos = System.nanoTime();
        long endTimeInNanos = startTimeInNanos + waitNanos;
        int dwMilliseconds = (int)(waitNanos / 1000000L);
        this.mutex.clearCurrentThreadOwner();
        int timedwaitResult = Process.SleepConditionVariableCS(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), dwMilliseconds);
        this.mutex.setOwnerToCurrentThread();
        if (timedwaitResult == 0 && WinBase.GetLastError() == WinBase.ERROR_TIMEOUT()) {
            return 0L;
        }
        WindowsVMLockSupport.checkResult(timedwaitResult, "SleepConditionVariableCS");
        return endTimeInNanos - System.nanoTime();
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public long blockNoTransition(long waitNanos) {
        assert (waitNanos >= 0L);
        long startTimeInNanos = System.nanoTime();
        long endTimeInNanos = startTimeInNanos + waitNanos;
        int dwMilliseconds = (int)(waitNanos / 1000000L);
        this.mutex.clearCurrentThreadOwner();
        int timedwaitResult = Process.NoTransitions.SleepConditionVariableCS(this.getStructPointer(), ((WindowsVMMutex)this.getMutex()).getStructPointer(), dwMilliseconds);
        this.mutex.setOwnerToCurrentThread();
        if (timedwaitResult == 0 && WinBase.GetLastError() == WinBase.ERROR_TIMEOUT()) {
            return 0L;
        }
        WindowsVMLockSupport.checkResult(timedwaitResult, "SleepConditionVariableCSNoTrans");
        return endTimeInNanos - System.nanoTime();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        Process.NoTransitions.WakeConditionVariable(this.getStructPointer());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void broadcast() {
        Process.NoTransitions.WakeAllConditionVariable(this.getStructPointer());
    }
}

