/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.util.PointerUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class DynamicMethodAddressResolutionHeapSupport {
    @Fold
    public static boolean isEnabled() {
        return ImageSingletons.contains(DynamicMethodAddressResolutionHeapSupport.class);
    }

    @Fold
    public static DynamicMethodAddressResolutionHeapSupport get() {
        return (DynamicMethodAddressResolutionHeapSupport)ImageSingletons.lookup(DynamicMethodAddressResolutionHeapSupport.class);
    }

    public abstract int initialize();

    public abstract UnsignedWord getRequiredPreHeapMemoryInBytes();

    public abstract int install(Pointer var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getDynamicMethodAddressResolverPreHeapMemoryBytes() {
        UnsignedWord requiredPreHeapMemoryInBytes = this.getRequiredPreHeapMemoryInBytes();
        UnsignedWord heapAlignment = WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment());
        return PointerUtils.roundUp((PointerBase)requiredPreHeapMemoryInBytes, heapAlignment);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer getPreHeapMappingStartAddress() {
        UnsignedWord heapBase = (UnsignedWord)Isolates.getHeapBase(CurrentIsolate.getIsolate());
        return (Pointer)heapBase.subtract(this.getRequiredPreHeapMemoryInBytes());
    }
}

