/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;
import org.graalvm.util.json.JSONParserException;

final class LegacySerializationConfigurationParser
extends SerializationConfigurationParser {
    private static final String SERIALIZATION_TYPES_KEY = "types";
    private static final String LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY = "lambdaCapturingTypes";
    private static final String PROXY_SERIALIZATION_TYPES_KEY = "proxies";
    private final ProxyConfigurationParser proxyConfigurationParser;

    LegacySerializationConfigurationParser(ConfigurationConditionResolver conditionResolver, RuntimeSerializationSupport serializationSupport, boolean strictConfiguration) {
        super(conditionResolver, serializationSupport, strictConfiguration);
        this.proxyConfigurationParser = new ProxyConfigurationParser(strictConfiguration, (arg_0, arg_1) -> ((RuntimeSerializationSupport)serializationSupport).registerProxyClass(arg_0, arg_1));
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        if (json instanceof List) {
            this.parseOldConfiguration(LegacySerializationConfigurationParser.asList(json, "First-level of document must be an array of serialization lists"));
        } else if (json instanceof EconomicMap) {
            this.parseNewConfiguration(LegacySerializationConfigurationParser.asMap(json, "First-level of document must be a map of serialization types"));
        } else {
            throw new JSONParserException("First-level of document must either be an array of serialization lists or a map of serialization types");
        }
    }

    private void parseOldConfiguration(List<Object> listOfSerializationConfigurationObjects) {
        this.parseSerializationTypes(LegacySerializationConfigurationParser.asList(listOfSerializationConfigurationObjects, "Second-level of document must be serialization descriptor objects"), false);
    }

    private void parseNewConfiguration(EconomicMap<String, Object> listOfSerializationConfigurationObjects) {
        if (!listOfSerializationConfigurationObjects.containsKey((Object)SERIALIZATION_TYPES_KEY) || !listOfSerializationConfigurationObjects.containsKey((Object)LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY)) {
            throw new JSONParserException("Second-level of document must be arrays of serialization descriptor objects");
        }
        this.parseSerializationTypes(LegacySerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get((Object)SERIALIZATION_TYPES_KEY), "The types property must be an array of serialization descriptor objects"), false);
        this.parseSerializationTypes(LegacySerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get((Object)LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY), "The lambdaCapturingTypes property must be an array of serialization descriptor objects"), true);
        if (listOfSerializationConfigurationObjects.containsKey((Object)PROXY_SERIALIZATION_TYPES_KEY)) {
            this.proxyConfigurationParser.parseAndRegister(listOfSerializationConfigurationObjects.get((Object)PROXY_SERIALIZATION_TYPES_KEY), null);
        }
    }

    @Override
    protected void parseSerializationDescriptorObject(EconomicMap<String, Object> data, boolean lambdaCapturingType) {
        if (lambdaCapturingType) {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton("name"), Collections.singleton("condition"));
        } else {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton("name"), Arrays.asList("customTargetConstructorClass", "condition"));
        }
        NamedConfigurationTypeDescriptor targetSerializationClass = new NamedConfigurationTypeDescriptor(LegacySerializationConfigurationParser.asString(data.get((Object)"name")));
        ConfigurationCondition unresolvedCondition = this.parseCondition(data, false);
        TypeResult<ConfigurationCondition> condition = this.conditionResolver.resolveCondition(unresolvedCondition);
        if (!condition.isPresent()) {
            return;
        }
        if (lambdaCapturingType) {
            String className = targetSerializationClass.name();
            this.serializationSupport.registerLambdaCapturingClass(condition.get(), className);
        } else {
            Object optionalCustomCtorValue = data.get((Object)"customTargetConstructorClass");
            String customTargetConstructorClass = optionalCustomCtorValue != null ? LegacySerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
            this.serializationSupport.registerWithTargetConstructorClass(condition.get(), targetSerializationClass.name(), customTargetConstructorClass);
        }
    }
}

