/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.amd64.AMD64CPUFeatureAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.cpufeature.Stubs;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.amd64.AMD64CGlobalDataLoadAddressOp;
import com.oracle.svm.core.graal.amd64.AMD64CalleeSavedRegisters;
import com.oracle.svm.core.graal.amd64.AMD64FarReturnOp;
import com.oracle.svm.core.graal.amd64.AMD64LoadMethodPointerConstantOp;
import com.oracle.svm.core.graal.amd64.AMD64ReturnOp;
import com.oracle.svm.core.graal.amd64.AMD64SafepointCheckOp;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64AddressLowering;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.SubstrateDebugInfoBuilder;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.lir.VerificationMarkerOp;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.graal.nodes.ComputedIndirectCallTargetNode;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMapBuilder;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRKindTool;
import org.graalvm.compiler.core.amd64.AMD64MoveFactory;
import org.graalvm.compiler.core.amd64.AMD64MoveFactoryBase;
import org.graalvm.compiler.core.amd64.AMD64NodeLIRBuilder;
import org.graalvm.compiler.core.amd64.AMD64NodeMatchRules;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.memory.MemoryExtendKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.CompressibleConstant;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.core.gen.LIRGenerationProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64BreakpointOp;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.amd64.AMD64ControlFlow;
import org.graalvm.compiler.lir.amd64.AMD64FrameMap;
import org.graalvm.compiler.lir.amd64.AMD64FrameMapBuilder;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.AMD64PrefetchOp;
import org.graalvm.compiler.lir.amd64.AMD64ReadProcid;
import org.graalvm.compiler.lir.amd64.AMD64ReadTimestampCounterWithProcid;
import org.graalvm.compiler.lir.amd64.AMD64VZeroUpper;
import org.graalvm.compiler.lir.amd64.EndbranchOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.EntryPointDecorator;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.gen.MoveFactory;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.AddressLoweringByNodePhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.amd64.AMD64IntrinsicStubs;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateAMD64Backend
extends SubstrateBackend
implements LIRGenerationProvider {
    protected static CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }

    public SubstrateAMD64Backend(Providers providers) {
        super(providers);
    }

    public static boolean runtimeToAOTIsAvxSseTransition(TargetDescription target) {
        if (SubstrateUtil.HOSTED) {
            return false;
        }
        if (!AMD64CPUFeatureAccess.canUpdateCPUFeatures()) {
            return false;
        }
        AMD64 arch = (AMD64)target.arch;
        EnumSet<?> hostedCPUFeatures = ((CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeCPUFeatures();
        EnumSet runtimeCPUFeatures = arch.getFeatures();
        return !hostedCPUFeatures.contains(AMD64.CPUFeature.AVX) && runtimeCPUFeatures.contains(AMD64.CPUFeature.AVX);
    }

    public static Object addressDisplacementAnnotation(JavaConstant constant) {
        if (SubstrateUtil.HOSTED) {
            return constant;
        }
        return null;
    }

    public static int addressDisplacement(JavaConstant constant, SharedConstantReflectionProvider constantReflection) {
        if (SubstrateUtil.HOSTED) {
            return 0;
        }
        return constantReflection.getImageHeapOffset(constant);
    }

    static void maybeTransitionToNative(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value javaFrameAnchor, Value temp, LIRFrameState state, int newThreadStatus) {
        if (ValueUtil.isIllegal((Value)javaFrameAnchor)) {
            assert (newThreadStatus == -1);
            return;
        }
        assert (VMThreads.StatusSupport.isValidStatus(newThreadStatus));
        Register anchor = ValueUtil.asRegister((Value)javaFrameAnchor);
        Register lastJavaIP = ValueUtil.asRegister((Value)temp);
        int startPos = masm.position();
        masm.leaq(lastJavaIP, new AMD64Address(AMD64.rip));
        crb.recordIndirectCall(startPos, masm.position(), null, state);
        KnownOffsets knownOffsets = KnownOffsets.singleton();
        masm.movq(new AMD64Address(anchor, knownOffsets.getJavaFrameAnchorLastIPOffset()), lastJavaIP);
        masm.movq(new AMD64Address(anchor, knownOffsets.getJavaFrameAnchorLastSPOffset()), AMD64.rsp);
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            masm.movl(new AMD64Address(ReservedRegisters.singleton().getThreadRegister(), knownOffsets.getVMThreadStatusOffset()), newThreadStatus);
        }
    }

    private void vzeroupperBeforeCall(SubstrateAMD64LIRGenerator gen, Value[] arguments, LIRFrameState callState, SharedMethod targetMethod) {
        if (SubstrateAMD64Backend.runtimeToAOTIsAvxSseTransition(gen.target()) && gen.getDestroysCallerSavedRegisters(targetMethod) && !this.isRuntimeToRuntimeCall(callState)) {
            gen.append((LIRInstruction)new AMD64VZeroUpper(arguments, (RegisterConfig)gen.getRegisterConfig()));
        }
    }

    private static ForeignCallDescriptor chooseCPUFeatureVariant(ForeignCallDescriptor descriptor, TargetDescription target, EnumSet<?> runtimeCheckedCPUFeatures) {
        EnumSet<?> buildtimeCPUFeatures = ((CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeCPUFeatures();
        EnumSet amd64Features = ((AMD64)target.arch).getFeatures();
        if (buildtimeCPUFeatures.containsAll(runtimeCheckedCPUFeatures) || !amd64Features.containsAll(runtimeCheckedCPUFeatures)) {
            return descriptor;
        }
        GraalError.guarantee((boolean)RuntimeCompilation.isEnabled(), (String)"should be reached in JIT mode only");
        return new ForeignCallDescriptor(descriptor.getName() + "RTC", descriptor.getResultType(), descriptor.getArgumentTypes(), descriptor.isReexecutable(), descriptor.getKilledLocations(), descriptor.canDeoptimize(), descriptor.isGuaranteedSafepoint());
    }

    private FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        AMD64FrameMap frameMap = new AMD64FrameMap(this.getProviders().getCodeCache(), registerConfigNonNull, (FrameMap.ReferenceMapBuilderFactory)new SubstrateReferenceMapBuilderFactory(), ((SubstrateAMD64RegisterConfig)registerConfigNonNull).shouldUseBasePointer());
        return new AMD64FrameMapBuilder((FrameMap)frameMap, this.getCodeCache(), registerConfigNonNull);
    }

    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, RegisterAllocationConfig registerAllocationConfig, StructuredGraph graph, Object stub) {
        SharedMethod method = (SharedMethod)graph.method();
        SubstrateCallingConventionKind ccKind = method.getCallingConventionKind();
        SubstrateCallingConventionType ccType = ccKind.isCustom() ? method.getCustomCallingConventionType() : ccKind.toType(false);
        CallingConvention callingConvention = CodeUtil.getCallingConvention((CodeCacheProvider)this.getCodeCache(), (CallingConvention.Type)ccType, (ResolvedJavaMethod)method, (ValueKindFactory)this);
        return new SubstrateLIRGenerationResult(compilationId, lir, this.newFrameMapBuilder(registerAllocationConfig.getRegisterConfig()), callingConvention, registerAllocationConfig, method);
    }

    protected AMD64ArithmeticLIRGenerator createArithmeticLIRGen(RegisterValue nullRegisterValue) {
        return new AMD64ArithmeticLIRGenerator((AllocatableValue)nullRegisterValue);
    }

    protected AMD64MoveFactoryBase createMoveFactory(LIRGenerationResult lirGenRes, MoveFactory.BackupSlotProvider backupSlotProvider) {
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenRes).getMethod();
        return new SubstrateAMD64MoveFactory(backupSlotProvider, method, this.createLirKindTool());
    }

    protected LIRKindTool createLirKindTool() {
        return new SubstrateAMD64LIRKindTool();
    }

    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        RegisterValue nullRegisterValue = SubstrateAMD64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister().asValue() : null;
        AMD64ArithmeticLIRGenerator arithmeticLIRGen = this.createArithmeticLIRGen(nullRegisterValue);
        MoveFactory.BackupSlotProvider backupSlotProvider = new MoveFactory.BackupSlotProvider(lirGenRes.getFrameMapBuilder());
        AMD64MoveFactoryBase moveFactory = this.createMoveFactory(lirGenRes, backupSlotProvider);
        return new SubstrateAMD64LIRGenerator(this.createLirKindTool(), arithmeticLIRGen, (MoveFactory)moveFactory, this.getProviders(), lirGenRes);
    }

    protected AMD64NodeMatchRules createMatchRules(LIRGeneratorTool lirGen) {
        return new AMD64NodeMatchRules(lirGen);
    }

    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        AMD64NodeMatchRules nodeMatchRules = this.createMatchRules(lirGen);
        return new SubstrateAMD64NodeLIRBuilder(graph, lirGen, nodeMatchRules);
    }

    protected static boolean useLinearPointerCompression() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenResult, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        LIR lir = lirGenResult.getLIR();
        OptionValues options = lir.getOptions();
        AMD64MacroAssembler masm = new AMD64MacroAssembler(this.getTarget(), options, true);
        PatchConsumerFactory patchConsumerFactory = SubstrateUtil.HOSTED ? PatchConsumerFactory.HostedPatchConsumerFactory.factory() : PatchConsumerFactory.NativePatchConsumerFactory.factory();
        masm.setCodePatchingAnnotationConsumer(patchConsumerFactory.newConsumer(compilationResult));
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenResult).getMethod();
        Deoptimizer.StubType stubType = method.getDeoptStubType();
        SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
        CallingConvention callingConvention = lirGenResult.getCallingConvention();
        SubstrateAMD64FrameContext frameContext = stubType == Deoptimizer.StubType.EntryStub ? new DeoptEntryStubContext(method, callingConvention) : (stubType == Deoptimizer.StubType.ExitStub ? new DeoptExitStubContext(method, callingConvention) : this.createFrameContext(method, callingConvention));
        DebugContext debug = lir.getDebug();
        Register uncompressedNullRegister = SubstrateAMD64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister() : Register.None;
        CompilationResultBuilder tasm = factory.createBuilder((CodeGenProviders)this.getProviders(), lirGenResult.getFrameMap(), (Assembler)masm, (DataBuilder)dataBuilder, (FrameContext)frameContext, options, debug, compilationResult, uncompressedNullRegister, lir);
        tasm.setTotalFrameSize(lirGenResult.getFrameMap().totalFrameSize());
        return tasm;
    }

    protected FrameContext createFrameContext(SharedMethod method, CallingConvention callingConvention) {
        return new SubstrateAMD64FrameContext(method, callingConvention);
    }

    @Override
    public BasePhase<CoreProviders> newAddressLoweringPhase(CodeCacheProvider codeCache) {
        CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
        return new AddressLoweringByNodePhase((AddressLoweringByNodePhase.AddressLowering)new SubstrateAMD64AddressLowering(compressEncoding));
    }

    public CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, boolean isDefault, OptionValues options) {
        return new SubstrateCompiledCode(compilationResult);
    }

    public void emitCode(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, EntryPointDecorator entryPointDecorator) {
        crb.emitLIR();
    }

    @Override
    public CompilationResult createJNITrampolineMethod(ResolvedJavaMethod method, CompilationIdentifier identifier, RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        CompilationResult result = new CompilationResult(identifier);
        AMD64Assembler asm = new AMD64Assembler(this.getTarget());
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            asm.movq(AMD64.rax, new AMD64Address(threadArg.getRegister(), threadIsolateOffset));
            asm.addq(AMD64.rax, methodIdArg.getRegister());
            asm.jmp(new AMD64Address(AMD64.rax, methodObjEntryPointOffset));
        } else {
            asm.jmp(new AMD64Address(methodIdArg.getRegister(), methodObjEntryPointOffset));
        }
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        byte[] instructions = asm.close(true);
        result.setTargetCode(instructions, instructions.length);
        result.setTotalFrameSize(this.getTarget().wordSize);
        return result;
    }

    protected class SubstrateAMD64LIRGenerator
    extends AMD64LIRGenerator
    implements SubstrateLIRGenerator {
        public SubstrateAMD64LIRGenerator(LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
            super(lirKindTool, arithmeticLIRGen, null, moveFactory, providers, lirGenRes);
        }

        public void emitReturn(JavaKind kind, Value input) {
            AllocatableValue operand = Value.ILLEGAL;
            if (input != null) {
                operand = this.resultOperandFor(kind, input.getValueKind());
                this.emitMove(operand, input);
            }
            this.append((LIRInstruction)new AMD64ReturnOp((Value)operand));
        }

        public SubstrateLIRGenerationResult getResult() {
            return (SubstrateLIRGenerationResult)super.getResult();
        }

        public SubstrateRegisterConfig getRegisterConfig() {
            return (SubstrateRegisterConfig)super.getRegisterConfig();
        }

        protected boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            if (this.getResult().getMethod().isDeoptTarget()) {
                return true;
            }
            return targetMethod == null || !((SharedMethod)targetMethod).hasCalleeSavedRegisters();
        }

        protected Value emitIndirectForeignCallAddress(ForeignCallLinkage linkage) {
            if (!SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                return null;
            }
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            Value codeOffsetInImage = this.emitConstant(this.getLIRKindTool().getWordKind(), (Constant)JavaConstant.forLong((long)targetMethod.getCodeOffsetInImage()));
            Value codeInfo = this.emitJavaConstant(SubstrateObjectConstant.forObject(CodeInfoTable.getImageCodeCache()));
            AMD64AddressValue codeStartField = new AMD64AddressValue((ValueKind)this.getLIRKindTool().getWordKind(), this.asAllocatable(codeInfo), KnownOffsets.singleton().getImageCodeInfoCodeStartOffset());
            Variable codeStart = this.getArithmetic().emitLoad(this.getLIRKindTool().getWordKind(), (Value)codeStartField, null, MemoryOrderMode.PLAIN, MemoryExtendKind.DEFAULT);
            return this.getArithmetic().emitAdd((Value)codeStart, codeOffsetInImage, false);
        }

        protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            Value exceptionTemp = this.getExceptionTemp(info != null && info.exceptionEdge != null);
            SubstrateAMD64Backend.this.vzeroupperBeforeCall(this, arguments, info, targetMethod);
            if (SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                RegisterValue targetRegister = AMD64.rax.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRKindTool()));
                this.emitMove((AllocatableValue)targetRegister, targetAddress);
                this.append((LIRInstruction)new SubstrateAMD64IndirectCallOp(targetMethod, result, arguments, temps, (Value)targetRegister, info, (Value)Value.ILLEGAL, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), exceptionTemp, null));
            } else {
                assert (targetAddress == null);
                this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, arguments, temps, info, (Value)Value.ILLEGAL, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), exceptionTemp));
            }
        }

        private Value getExceptionTemp(boolean hasExceptionEdge) {
            if (hasExceptionEdge) {
                return this.getRegisterConfig().getReturnRegister(JavaKind.Object).asValue();
            }
            return Value.ILLEGAL;
        }

        public void emitUnwind(Value operand) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
            throw VMError.shouldNotReachHere("Substrate VM does not use deoptimization");
        }

        @Override
        public void emitVerificationMarker(Object marker) {
            this.append(new VerificationMarkerOp(marker));
        }

        @Override
        public void emitInstructionSynchronizationBarrier() {
            throw VMError.shouldNotReachHere("AMD64 does not need instruction synchronization");
        }

        @Override
        public void emitFarReturn(AllocatableValue result, Value sp, Value ip, boolean fromMethodWithCalleeSavedRegisters) {
            this.append((LIRInstruction)new AMD64FarReturnOp(result, this.asAllocatable(sp), this.asAllocatable(ip), fromMethodWithCalleeSavedRegisters));
        }

        @Override
        public void emitDeadEnd() {
            this.append(new DeadEndOp());
        }

        public void emitPrefetchAllocate(Value address) {
            this.append((LIRInstruction)new AMD64PrefetchOp(this.asAddressValue(address), SubstrateOptions.AllocatePrefetchInstr.getValue().intValue()));
        }

        public Value emitCompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getNarrowOopKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.CompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            assert (((LIRKind)pointer.getValueKind(LIRKind.class)).getPlatformKind() == this.getLIRKindTool().getNarrowOopKind().getPlatformKind());
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getObjectKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.UncompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public void emitConvertNullToZero(AllocatableValue result, AllocatableValue value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertNullToZeroOp(result, value));
            } else {
                this.emitMove(result, (Value)value);
            }
        }

        public void emitConvertZeroToNull(AllocatableValue result, Value value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertZeroToNullOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }

        public void emitProcid(AllocatableValue dst) {
            if (this.supportsCPUFeature("RDPID")) {
                this.append((LIRInstruction)new AMD64ReadProcid(dst));
            } else {
                AMD64ReadTimestampCounterWithProcid procid = new AMD64ReadTimestampCounterWithProcid();
                this.append((LIRInstruction)procid);
                this.emitMove(dst, (Value)procid.getProcidResult());
            }
            this.getArithmetic().emitAnd((Value)dst, this.emitConstant(LIRKind.value((PlatformKind)AMD64Kind.DWORD), (Constant)JavaConstant.forInt((int)4095)));
        }

        public int getArrayLengthOffset() {
            return ConfigurationValues.getObjectLayout().getArrayLengthOffset();
        }

        public Register getHeapBaseRegister() {
            return ReservedRegisters.singleton().getHeapBaseRegister();
        }

        protected void emitRangeTableSwitch(int lowKey, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue key) {
            super.emitRangeTableSwitch(lowKey, defaultTarget, targets, key);
            this.markIndirectBranchTargets(targets);
        }

        protected void emitHashTableSwitch(JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue value, Value hash) {
            super.emitHashTableSwitch(keys, defaultTarget, targets, value, hash);
            this.markIndirectBranchTargets(targets);
        }

        private void markIndirectBranchTargets(LabelRef[] labels) {
            for (LabelRef label : labels) {
                label.getTargetBlock().setIndirectBranchTarget();
            }
        }
    }

    static class SubstrateReferenceMapBuilderFactory
    implements FrameMap.ReferenceMapBuilderFactory {
        SubstrateReferenceMapBuilderFactory() {
        }

        public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
            return new SubstrateReferenceMapBuilder(totalFrameSize);
        }
    }

    protected static final class SubstrateLIRGenerationResult
    extends LIRGenerationResult {
        private final SharedMethod method;

        public SubstrateLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, CallingConvention callingConvention, RegisterAllocationConfig registerAllocationConfig, SharedMethod method) {
            super(compilationId, lir, frameMapBuilder, registerAllocationConfig, callingConvention);
            this.method = method;
            if (method.hasCalleeSavedRegisters()) {
                AMD64CalleeSavedRegisters calleeSavedRegisters = AMD64CalleeSavedRegisters.singleton();
                FrameMap frameMap = ((FrameMapBuilderTool)frameMapBuilder).getFrameMap();
                int registerSaveAreaSizeInBytes = calleeSavedRegisters.getSaveAreaSize();
                StackSlot calleeSaveArea = frameMap.allocateStackMemory(registerSaveAreaSizeInBytes, frameMap.getTarget().wordSize);
                calleeSavedRegisters.verifySaveAreaOffsetInFrame(calleeSaveArea.getRawOffset());
            }
            if (method.canDeoptimize() || method.isDeoptTarget()) {
                ((FrameMapBuilderTool)frameMapBuilder).getFrameMap().reserveOutgoing(16);
            }
        }

        public SharedMethod getMethod() {
            return this.method;
        }
    }

    protected static class SubstrateAMD64MoveFactory
    extends AMD64MoveFactory {
        private final SharedMethod method;
        protected final LIRKindTool lirKindTool;

        protected SubstrateAMD64MoveFactory(MoveFactory.BackupSlotProvider backupSlotProvider, SharedMethod method, LIRKindTool lirKindTool) {
            super(backupSlotProvider);
            this.method = method;
            this.lirKindTool = lirKindTool;
        }

        public boolean allowConstantToStackMove(Constant constant) {
            if (constant instanceof SubstrateObjectConstant && this.method.isDeoptTarget()) {
                return false;
            }
            return super.allowConstantToStackMove(constant);
        }

        private static JavaConstant getZeroConstant(AllocatableValue dst) {
            int size = dst.getPlatformKind().getSizeInBytes() * 8;
            switch (size) {
                case 32: {
                    return JavaConstant.INT_0;
                }
                case 64: {
                    return JavaConstant.LONG_0;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(size);
        }

        public AMD64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createLoad(dst, (Constant)SubstrateAMD64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof CompressibleConstant) {
                return this.loadObjectConstant(dst, (CompressibleConstant)src);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                return new AMD64LoadMethodPointerConstantOp(dst, (SubstrateMethodPointerConstant)src);
            }
            return super.createLoad(dst, src);
        }

        public LIRInstruction createStackLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createStackLoad(dst, (Constant)SubstrateAMD64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof CompressibleConstant) {
                return this.loadObjectConstant(dst, (SubstrateObjectConstant)src);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                return new AMD64LoadMethodPointerConstantOp(dst, (SubstrateMethodPointerConstant)src);
            }
            return super.createStackLoad(dst, src);
        }

        protected AMD64LIRInstruction loadObjectConstant(AllocatableValue dst, CompressibleConstant constant) {
            if (ReferenceAccess.singleton().haveCompressedReferences()) {
                RegisterValue heapBase = ReservedRegisters.singleton().getHeapBaseRegister().asValue();
                return new LoadCompressedObjectConstantOp(dst, constant, (AllocatableValue)heapBase, SubstrateAMD64Backend.getCompressEncoding(), this.lirKindTool);
            }
            return new AMD64Move.MoveFromConstOp(dst, (JavaConstant)constant);
        }

        public static final class LoadCompressedObjectConstantOp
        extends AMD64Move.PointerCompressionOp
        implements StandardOp.LoadConstantOp {
            public static final LIRInstructionClass<LoadCompressedObjectConstantOp> TYPE = LIRInstructionClass.create(LoadCompressedObjectConstantOp.class);
            private final CompressibleConstant constant;

            static Constant asCompressed(CompressibleConstant constant) {
                return constant.isCompressed() ? constant : constant.compress();
            }

            LoadCompressedObjectConstantOp(AllocatableValue result, CompressibleConstant constant, AllocatableValue baseRegister, CompressEncoding encoding, LIRKindTool lirKindTool) {
                super(TYPE, result, (Value)new ConstantValue((ValueKind)lirKindTool.getNarrowOopKind(), LoadCompressedObjectConstantOp.asCompressed(constant)), baseRegister, encoding, true, lirKindTool);
                this.constant = constant;
            }

            public Constant getConstant() {
                return this.constant;
            }

            public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
                Register resultReg = this.getResultRegister();
                int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
                Constant inputConstant = LIRValueUtil.asConstantValue((Value)this.getInput()).getConstant();
                if (masm.inlineObjects()) {
                    crb.recordInlineDataInCode(inputConstant);
                    if (referenceSize == 4) {
                        masm.movl(resultReg, -559030611, true);
                    } else {
                        masm.movq(resultReg, -2401018187971961171L, true);
                    }
                } else {
                    AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode(inputConstant, referenceSize);
                    if (referenceSize == 4) {
                        masm.movl(resultReg, address);
                    } else {
                        masm.movq(resultReg, address);
                    }
                }
                if (!this.constant.isCompressed()) {
                    Register baseReg = this.getBaseRegister();
                    boolean preserveFlagsRegister = true;
                    LoadCompressedObjectConstantOp.emitUncompressWithBaseRegister((AMD64MacroAssembler)masm, (Register)resultReg, (Register)baseReg, (int)this.getShift(), (boolean)preserveFlagsRegister);
                }
            }
        }
    }

    protected static class SubstrateAMD64LIRKindTool
    extends AMD64LIRKindTool {
        protected SubstrateAMD64LIRKindTool() {
        }

        public LIRKind getNarrowOopKind() {
            return LIRKind.compressedReference((PlatformKind)AMD64Kind.QWORD);
        }

        public LIRKind getNarrowPointerKind() {
            throw VMError.shouldNotReachHereAtRuntime();
        }
    }

    public class SubstrateAMD64NodeLIRBuilder
    extends AMD64NodeLIRBuilder
    implements SubstrateNodeLIRBuilder {
        public SubstrateAMD64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
            super(graph, gen, nodeMatchRules);
        }

        public void doBlockPrologue(HIRBlock block, OptionValues options) {
            if (SubstrateOptions.IndirectBranchTargetMarker.getValue().booleanValue() && block.isIndirectBranchTarget()) {
                ArrayList lir = this.gen.getResult().getLIR().getLIRforBlock((BasicBlock)block);
                GraalError.guarantee((lir.size() == 1 && lir.get(0) instanceof StandardOp.LabelOp ? 1 : 0) != 0, (String)"block may only contain an initial LabelOp before emitting endbranch");
                this.gen.append(EndbranchOp.create());
            }
            super.doBlockPrologue(block, options);
        }

        public void visitSafepointNode(SafepointNode node) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void visitBreakpointNode(BreakpointNode node) {
            JavaType[] sig = new JavaType[node.arguments().size()];
            for (int i = 0; i < sig.length; ++i) {
                sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
            }
            CallingConvention convention = this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), null, sig, (ValueKindFactory)this.gen);
            this.append((LIRInstruction)new AMD64BreakpointOp(this.visitInvokeArguments(convention, (Collection<ValueNode>)node.arguments())));
        }

        protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
            return new SubstrateDebugInfoBuilder(graph, this.gen.getProviders().getMetaAccessExtensionProvider(), nodeValueMap);
        }

        protected void prologSetParameterNodes(StructuredGraph graph, Value[] params) {
            SubstrateCallingConvention convention = (SubstrateCallingConvention)this.gen.getResult().getCallingConvention();
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                Value inputValue = params[param.index()];
                Variable paramValue = this.gen.emitMove(inputValue);
                if (inputValue.getPlatformKind().getSizeInBytes() < 4) {
                    SubstrateCallingConventionType type = (SubstrateCallingConventionType)convention.getType();
                    assert (!type.outgoing && type.nativeABI());
                    JavaKind kind = convention.getArgumentStorageKinds()[param.index()];
                    JavaKind stackKind = kind.getStackKind();
                    paramValue = kind.isUnsigned() ? this.gen.getArithmetic().emitZeroExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount()) : this.gen.getArithmetic().emitSignExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount());
                }
                assert (paramValue.getValueKind().equals(this.gen.getLIRKind(param.stamp(NodeView.DEFAULT))));
                this.setResult((ValueNode)param, (Value)paramValue);
            }
        }

        public Value[] visitInvokeArguments(CallingConvention invokeCc, Collection<ValueNode> arguments) {
            Value[] values = super.visitInvokeArguments(invokeCc, arguments);
            SubstrateCallingConventionType type = (SubstrateCallingConventionType)((SubstrateCallingConvention)invokeCc).getType();
            if (type.usesReturnBuffer()) {
                assert (values.length > 0);
                Value returnBuffer = values[0];
                Variable saved = this.gen.newVariable(returnBuffer.getValueKind());
                this.gen.append(this.gen.getSpillMoveFactory().createMove((AllocatableValue)saved, returnBuffer));
                values[0] = saved;
            }
            if (type.nativeABI()) {
                VMError.guarantee(values.length == invokeCc.getArgumentCount() - 1, "The last argument should be missing.");
                AllocatableValue raxValue = invokeCc.getArgument(values.length);
                VMError.guarantee(raxValue instanceof RegisterValue && ((RegisterValue)raxValue).getRegister().equals((Object)AMD64.rax));
                values = Arrays.copyOf(values, values.length + 1);
                int xmmCount = 0;
                for (int i = 0; i < values.length - 1; ++i) {
                    Value v = values[i];
                    if (!ValueUtil.isRegister((Value)v) || !ValueUtil.asRegister((Value)v).getRegisterCategory().equals((Object)AMD64.XMM)) continue;
                    ++xmmCount;
                }
                assert (xmmCount <= 8);
                this.gen.emitMoveConstant(raxValue, (Constant)JavaConstant.forInt((int)xmmCount));
                values[values.length - 1] = raxValue;
            }
            return values;
        }

        private boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            return ((SubstrateAMD64LIRGenerator)this.gen).getDestroysCallerSavedRegisters(targetMethod);
        }

        private Value getExceptionTemp(CallTargetNode callTarget) {
            return ((SubstrateAMD64LIRGenerator)this.gen).getExceptionTemp(callTarget.invoke() instanceof InvokeWithExceptionNode);
        }

        public BiConsumer<CompilationResultBuilder, Integer> getOffsetRecorder(IndirectCallTargetNode callTargetNode) {
            return null;
        }

        private static AllocatableValue asReturnedValue(AssignedLocation assignedLocation) {
            LIRKind kind;
            assert (assignedLocation.assignsToRegister());
            Register.RegisterCategory category = assignedLocation.register().getRegisterCategory();
            if (category.equals((Object)AMD64.CPU)) {
                kind = LIRKind.value((PlatformKind)AMD64Kind.QWORD);
            } else if (category.equals((Object)AMD64.XMM)) {
                kind = LIRKind.value((PlatformKind)AMD64Kind.V128_DOUBLE);
            } else {
                throw VMError.unsupportedFeature("Register category " + category + " should not be used for returns spanning multiple registers.");
            }
            return assignedLocation.register().asValue((ValueKind)kind);
        }

        protected void emitInvoke(LoweredCallTargetNode callTarget, Value[] parameters, LIRFrameState callState, Value result) {
            SubstrateCallingConventionType cc = (SubstrateCallingConventionType)callTarget.callType();
            SubstrateAMD64Backend.verifyCallTarget(callTarget);
            if (callTarget instanceof ComputedIndirectCallTargetNode) {
                assert (!cc.customABI());
                this.emitComputedIndirectCall((ComputedIndirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
            } else {
                super.emitInvoke(callTarget, parameters, callState, result);
            }
            if (cc.usesReturnBuffer()) {
                Value returnBuffer = parameters[0];
                long offset = 0L;
                for (AssignedLocation ret : cc.returnSaving) {
                    Value saveLocation = this.gen.getArithmetic().emitAdd(returnBuffer, this.gen.emitJavaConstant((JavaConstant)JavaConstant.forLong((long)offset)), false);
                    AllocatableValue returnedValue = SubstrateAMD64NodeLIRBuilder.asReturnedValue(ret);
                    this.gen.getArithmetic().emitStore(returnedValue.getValueKind(), saveLocation, (Value)returnedValue, callState, MemoryOrderMode.PLAIN);
                    offset += (long)returnedValue.getPlatformKind().getSizeInBytes();
                }
            }
        }

        protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, parameters, temps, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), (Value)this.setupJavaFrameAnchorTemp((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget)));
        }

        protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            Register targetRegister = AMD64.rax;
            if (((SubstrateCallingConventionType)callTarget.callType()).nativeABI()) {
                targetRegister = AMD64.r10;
            }
            RegisterValue targetAddress = targetRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)targetAddress, this.operand((Node)callTarget.computedAddress()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            Value[] multipleResults = new Value[]{};
            SubstrateCallingConventionType cc = (SubstrateCallingConventionType)callTarget.callType();
            if (cc.customABI() && cc.usesReturnBuffer()) {
                multipleResults = Arrays.stream(cc.returnSaving).map(SubstrateAMD64NodeLIRBuilder::asReturnedValue).toList().toArray(new Value[0]);
            }
            this.append((LIRInstruction)new SubstrateAMD64IndirectCallOp(targetMethod, result, parameters, temps, (Value)targetAddress, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), (Value)this.setupJavaFrameAnchorTemp((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget), this.getOffsetRecorder(callTarget), multipleResults));
        }

        protected void emitComputedIndirectCall(ComputedIndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            assert (!((SubstrateCallingConventionType)callTarget.callType()).nativeABI());
            RegisterValue addressBase = AMD64.rax.asValue((ValueKind)callTarget.getAddressBase().stamp(NodeView.DEFAULT).getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)addressBase, this.operand((Node)callTarget.getAddressBase()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            this.append((LIRInstruction)new SubstrateAMD64ComputedIndirectCallOp(targetMethod, result, parameters, temps, (Value)addressBase, callTarget.getAddressComputation(), callState, this.getExceptionTemp((CallTargetNode)callTarget), this.gen.getLIRKindTool(), (SharedConstantReflectionProvider)SubstrateAMD64Backend.this.getConstantReflection()));
        }

        private AllocatableValue setupJavaFrameAnchor(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            Register frameAnchorRegister = AMD64.r13;
            RegisterValue frameAnchor = frameAnchorRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)frameAnchor, this.operand((Node)SubstrateBackend.getJavaFrameAnchor(callTarget)));
            return frameAnchor;
        }

        private AllocatableValue setupJavaFrameAnchorTemp(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            return AMD64.r12.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
        }

        public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
            if (node instanceof SafepointCheckNode) {
                AMD64SafepointCheckOp op = new AMD64SafepointCheckOp();
                this.append((LIRInstruction)op);
                this.append((LIRInstruction)new AMD64ControlFlow.BranchOp(op.getConditionFlag(), trueSuccessor, falseSuccessor, trueSuccessorProbability));
            } else {
                super.emitBranch(node, trueSuccessor, falseSuccessor, trueSuccessorProbability);
            }
        }

        @Override
        public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
            Variable result = this.gen.newVariable((ValueKind)this.gen.getLIRKindTool().getWordKind());
            this.append((LIRInstruction)new AMD64CGlobalDataLoadAddressOp(node.getDataInfo(), (AllocatableValue)result));
            this.setResult((ValueNode)node, (Value)result);
        }

        @Override
        public Variable emitReadReturnAddress() {
            assert (FrameAccess.returnAddressSize() > 0);
            return this.getLIRGeneratorTool().emitMove((Value)StackSlot.get((ValueKind)this.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (int)(-FrameAccess.returnAddressSize()), (boolean)true));
        }

        public ForeignCallLinkage lookupGraalStub(ValueNode valueNode, ForeignCallDescriptor foreignCallDescriptor) {
            SharedMethod method = (SharedMethod)valueNode.graph().method();
            if (method != null && method.isForeignCallTarget()) {
                return null;
            }
            if (AMD64IntrinsicStubs.shouldInlineIntrinsic((ValueNode)valueNode, (LIRGenerator)this.gen)) {
                return null;
            }
            return this.gen.getForeignCalls().lookupForeignCall(SubstrateAMD64Backend.chooseCPUFeatureVariant(foreignCallDescriptor, this.gen.target(), Stubs.getRequiredCPUFeatures(valueNode.getClass())));
        }
    }

    protected static class DeoptEntryStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptEntryStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            RegisterConfig registerConfig = tasm.frameMap.getRegisterConfig();
            Register gpReturnReg = registerConfig.getReturnRegister(JavaKind.Long);
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            Register deoptimizedFrame = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            assert (!deoptimizedFrame.equals((Object)gpReturnReg)) : "overwriting return reg";
            asm.movq(deoptimizedFrame, registerConfig.getFrameRegister());
            asm.movq(ValueUtil.asRegister((Value)this.callingConvention.getArgument(1)), gpReturnReg);
            asm.movdq(ValueUtil.asRegister((Value)this.callingConvention.getArgument(2)), fpReturnReg);
            asm.subq(registerConfig.getFrameRegister(), FrameAccess.returnAddressSize());
            super.enter(tasm);
        }
    }

    protected static class DeoptExitStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptExitStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            Register firstParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            asm.movq(AMD64.rsp, firstParameter);
            asm.subq(AMD64.rsp, 2 * FrameAccess.returnAddressSize());
            asm.push(ValueUtil.asRegister((Value)this.callingConvention.getArgument(1)));
            asm.push(ValueUtil.asRegister((Value)this.callingConvention.getArgument(2)));
            super.enter(tasm);
        }

        @Override
        public void leave(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            RegisterConfig registerConfig = tasm.frameMap.getRegisterConfig();
            Register gpReturnReg = registerConfig.getReturnRegister(JavaKind.Long);
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            super.leave(tasm);
            asm.movq(fpReturnReg, new AMD64Address(AMD64.rsp, 0));
            asm.addq(AMD64.rsp, 8);
            asm.pop(gpReturnReg);
            if (((SubstrateAMD64RegisterConfig)tasm.frameMap.getRegisterConfig()).shouldUseBasePointer()) {
                asm.pop(AMD64.rbp);
            } else {
                asm.addq(AMD64.rsp, 8);
            }
        }
    }

    protected static class SubstrateAMD64FrameContext
    implements FrameContext {
        protected final SharedMethod method;
        protected final CallingConvention callingConvention;

        protected SubstrateAMD64FrameContext(SharedMethod method, CallingConvention callingConvention) {
            this.method = method;
            this.callingConvention = callingConvention;
        }

        public void enter(CompilationResultBuilder crb) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            this.makeFrame(crb, asm);
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
            if (this.method.hasCalleeSavedRegisters()) {
                VMError.guarantee(!this.method.isDeoptTarget(), "Deoptimization runtime cannot fill the callee saved registers");
                AMD64CalleeSavedRegisters.singleton().emitSave((AMD64MacroAssembler)crb.asm, crb.frameMap.totalFrameSize(), crb);
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        }

        protected void emitEndBranch(CompilationResultBuilder crb) {
            if (SubstrateOptions.IndirectBranchTargetMarker.getValue().booleanValue() && (ImageInfo.inImageRuntimeCode() || !this.method.canBeStaticallyBound())) {
                ((AMD64Assembler)crb.asm).endbranch();
            }
        }

        protected void makeFrame(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            this.emitEndBranch(crb);
            this.reserveStackFrame(crb, asm);
        }

        protected final void reserveStackFrame(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            this.maybePushBasePointer(crb, asm);
            asm.decrementq(AMD64.rsp, crb.frameMap.frameSize());
        }

        protected void maybePushBasePointer(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            if (((SubstrateAMD64RegisterConfig)crb.frameMap.getRegisterConfig()).shouldUseBasePointer()) {
                asm.push(AMD64.rbp);
                asm.movq(AMD64.rbp, AMD64.rsp);
            }
        }

        public void leave(CompilationResultBuilder crb) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_START);
            if (this.method.hasCalleeSavedRegisters()) {
                JavaKind returnKind = this.method.getSignature().getReturnKind();
                Register returnRegister = null;
                if (returnKind != JavaKind.Void) {
                    returnRegister = crb.frameMap.getRegisterConfig().getReturnRegister(returnKind);
                }
                AMD64CalleeSavedRegisters.singleton().emitRestore((AMD64MacroAssembler)crb.asm, crb.frameMap.totalFrameSize(), returnRegister, crb);
            }
            if (((SubstrateAMD64RegisterConfig)crb.frameMap.getRegisterConfig()).shouldUseBasePointer()) {
                asm.movq(AMD64.rsp, AMD64.rbp);
                asm.pop(AMD64.rbp);
            } else {
                asm.incrementq(AMD64.rsp, crb.frameMap.frameSize());
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_INCD_RSP);
        }

        public void returned(CompilationResultBuilder crb) {
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_END);
        }
    }

    @Opcode(value="DEAD_END")
    public static class DeadEndOp
    extends LIRInstruction
    implements StandardOp.BlockEndOp {
        public static final LIRInstructionClass<DeadEndOp> TYPE = LIRInstructionClass.create(DeadEndOp.class);

        public DeadEndOp() {
            super(TYPE);
        }

        public void emitCode(CompilationResultBuilder crb) {
            if (SubstrateUtil.assertionsEnabled()) {
                ((AMD64Assembler)crb.asm).int3();
            }
        }
    }

    @Opcode(value="CALL_COMPUTED_INDIRECT")
    public static class SubstrateAMD64ComputedIndirectCallOp
    extends AMD64Call.MethodCallOp {
        public static final LIRInstructionClass<SubstrateAMD64ComputedIndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64ComputedIndirectCallOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private Value addressBase;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        private Value addressBaseTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        private final ComputedIndirectCallTargetNode.Computation[] addressComputation;
        private final LIRKindTool lirKindTool;
        private final SharedConstantReflectionProvider constantReflection;

        public SubstrateAMD64ComputedIndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value addressBase, ComputedIndirectCallTargetNode.Computation[] addressComputation, LIRFrameState state, Value exceptionTemp, LIRKindTool lirKindTool, SharedConstantReflectionProvider constantReflection) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.addressBase = this.addressBaseTemp = addressBase;
            this.exceptionTemp = exceptionTemp;
            this.addressComputation = addressComputation;
            this.lirKindTool = lirKindTool;
            this.constantReflection = constantReflection;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, addressBase}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            VMError.guarantee(SubstrateOptions.SpawnIsolates.getValue(), "Memory access without isolates is not implemented");
            int compressionShift = ReferenceAccess.singleton().getCompressionShift();
            Register computeRegister = ValueUtil.asRegister((Value)this.addressBase);
            AMD64BaseAssembler.OperandSize lastOperandSize = AMD64BaseAssembler.OperandSize.get((PlatformKind)this.addressBase.getPlatformKind());
            boolean nextMemoryAccessNeedsDecompress = false;
            for (ComputedIndirectCallTargetNode.Computation computation : this.addressComputation) {
                AMD64Address memoryAddress;
                SharedField field;
                Label done = null;
                if (computation instanceof ComputedIndirectCallTargetNode.FieldLoad) {
                    field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoad)computation).getField();
                    memoryAddress = nextMemoryAccessNeedsDecompress ? new AMD64Address(ReservedRegisters.singleton().getHeapBaseRegister(), computeRegister, Stride.fromLog2((int)compressionShift), field.getOffset()) : new AMD64Address(computeRegister, field.getOffset());
                } else if (computation instanceof ComputedIndirectCallTargetNode.FieldLoadIfZero) {
                    done = new Label();
                    VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Comparison with compressed null value not implemented");
                    masm.cmpAndJcc(lastOperandSize, computeRegister, 0, AMD64Assembler.ConditionFlag.NotEqual, done, true);
                    SubstrateObjectConstant object = (SubstrateObjectConstant)((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getObject();
                    field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getField();
                    memoryAddress = new AMD64Address(ReservedRegisters.singleton().getHeapBaseRegister(), Register.None, Stride.S1, field.getOffset() + SubstrateAMD64Backend.addressDisplacement(object, this.constantReflection), SubstrateAMD64Backend.addressDisplacementAnnotation(object));
                } else {
                    throw VMError.shouldNotReachHere("Computation is not supported yet: " + computation.getClass().getTypeName());
                }
                switch (field.getStorageKind()) {
                    case Int: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.DWORD;
                        nextMemoryAccessNeedsDecompress = false;
                        break;
                    }
                    case Long: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.QWORD;
                        nextMemoryAccessNeedsDecompress = false;
                        break;
                    }
                    case Object: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.get((PlatformKind)this.lirKindTool.getNarrowOopKind().getPlatformKind());
                        nextMemoryAccessNeedsDecompress = true;
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Kind is not supported yet: " + field.getStorageKind());
                    }
                }
                AMD64Assembler.AMD64RMOp.MOV.emit((AMD64Assembler)masm, lastOperandSize, computeRegister, memoryAddress);
                if (done == null) continue;
                masm.bind(done);
            }
            VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Final computed call target address is not a primitive value");
            AMD64Call.indirectCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (Register)computeRegister, (InvokeTarget)this.callTarget, (LIRFrameState)this.state);
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class SubstrateAMD64IndirectCallOp
    extends AMD64Call.IndirectCallOp {
        public static final LIRInstructionClass<SubstrateAMD64IndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64IndirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchorTemp;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        private final BiConsumer<CompilationResultBuilder, Integer> offsetRecorder;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        private Value[] multipleResults;

        public SubstrateAMD64IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp, BiConsumer<CompilationResultBuilder, Integer> offsetRecorder) {
            this(callTarget, result, parameters, temps, targetAddress, state, javaFrameAnchor, javaFrameAnchorTemp, newThreadStatus, destroysCallerSavedRegisters, exceptionTemp, offsetRecorder, new Value[0]);
        }

        public SubstrateAMD64IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp, BiConsumer<CompilationResultBuilder, Integer> offsetRecorder, Value[] multipleResults) {
            super(TYPE, callTarget, result, parameters, temps, targetAddress, state);
            this.newThreadStatus = newThreadStatus;
            this.javaFrameAnchor = javaFrameAnchor;
            this.javaFrameAnchorTemp = javaFrameAnchorTemp;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            this.offsetRecorder = offsetRecorder;
            this.multipleResults = multipleResults;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, targetAddress, javaFrameAnchor, javaFrameAnchorTemp}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            SubstrateAMD64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.javaFrameAnchorTemp, this.state, this.newThreadStatus);
            int offset = AMD64Call.indirectCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (Register)ValueUtil.asRegister((Value)this.targetAddress), (InvokeTarget)this.callTarget, (LIRFrameState)this.state);
            if (this.offsetRecorder != null) {
                this.offsetRecorder.accept(crb, offset);
            }
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static class SubstrateAMD64DirectCallOp
    extends AMD64Call.DirectCallOp {
        public static final LIRInstructionClass<SubstrateAMD64DirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64DirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchorTemp;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;

        public SubstrateAMD64DirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.newThreadStatus = newThreadStatus;
            this.javaFrameAnchor = javaFrameAnchor;
            this.javaFrameAnchorTemp = javaFrameAnchorTemp;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, javaFrameAnchor, javaFrameAnchorTemp}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            SubstrateAMD64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.javaFrameAnchorTemp, this.state, this.newThreadStatus);
            AMD64Call.directCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (InvokeTarget)this.callTarget, null, (boolean)false, (LIRFrameState)this.state);
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }
}

