/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateMethodPointerStamp;
import com.oracle.svm.core.snippets.SubstrateIsArraySnippets;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeadEndNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.LoadMethodNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.DefaultJavaLoweringProvider;
import org.graalvm.compiler.replacements.IsArraySnippets;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class SubstrateBasicLoweringProvider
extends DefaultJavaLoweringProvider
implements SubstrateLoweringProvider {
    private final Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings = new HashMap();
    private RuntimeConfiguration runtimeConfig;
    private final KnownOffsets knownOffsets;
    private final AbstractObjectStamp hubStamp;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateBasicLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target, ReferenceAccess.singleton().haveCompressedReferences());
        ObjectStamp hubRefStamp = StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)metaAccess.lookupJavaType(DynamicHub.class)));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            hubRefStamp = SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)hubRefStamp, ReferenceAccess.singleton().getCompressEncoding());
        }
        this.hubStamp = hubRefStamp;
        this.knownOffsets = KnownOffsets.singleton();
    }

    @Override
    public void setConfiguration(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers) {
        this.runtimeConfig = runtimeConfig;
        this.identityHashCodeSnippets = IdentityHashCodeSupport.createSnippetTemplates(options, providers);
        this.isArraySnippets = new IsArraySnippets.Templates((IsArraySnippets)new SubstrateIsArraySnippets(), options, providers);
        this.initialize(options, SnippetCounter.Group.NullFactory, providers);
    }

    protected Providers getProviders() {
        return this.runtimeConfig.getProviders();
    }

    protected ObjectLayout getObjectLayout() {
        return ConfigurationValues.getObjectLayout();
    }

    @Override
    public Map<Class<? extends Node>, NodeLoweringProvider<?>> getLowerings() {
        return this.lowerings;
    }

    public void lower(Node n, LoweringTool tool) {
        if (n instanceof AssertionNode) {
            SubstrateBasicLoweringProvider.lowerAssertionNode((AssertionNode)n);
        } else if (n instanceof DeadEndNode) {
            this.lowerDeadEnd((DeadEndNode)n);
        } else if (n instanceof LoadMethodNode) {
            this.lowerLoadMethodNode((LoadMethodNode)n);
        } else {
            super.lower(n, tool);
        }
    }

    private void lowerLoadMethodNode(LoadMethodNode loadMethodNode) {
        StructuredGraph graph = loadMethodNode.graph();
        SharedMethod method = (SharedMethod)loadMethodNode.getMethod();
        ReadNode methodPointer = this.createReadVirtualMethod(graph, loadMethodNode.getHub(), method);
        graph.replaceFixed((FixedWithNextNode)loadMethodNode, (Node)methodPointer);
    }

    private ReadNode createReadVirtualMethod(StructuredGraph graph, ValueNode hub, SharedMethod method) {
        int vtableEntryOffset = this.knownOffsets.getVTableOffset(method.getVTableIndex());
        assert (vtableEntryOffset > 0);
        SubstrateMethodPointerStamp methodStamp = SubstrateMethodPointerStamp.methodNonNull();
        AddressNode address = this.createOffsetAddress(graph, hub, vtableEntryOffset);
        return (ReadNode)graph.add((Node)new ReadNode(address, SubstrateBackend.getVTableIdentity(), (Stamp)methodStamp, BarrierType.NONE, MemoryOrderMode.PLAIN));
    }

    public int arrayLengthOffset() {
        return this.getObjectLayout().getArrayLengthOffset();
    }

    public ValueNode staticFieldBase(StructuredGraph graph, ResolvedJavaField f) {
        SharedField field = (SharedField)f;
        assert (field.isStatic());
        return (ValueNode)graph.unique((Node)StaticFieldsSupport.createStaticFieldBaseNode(field.getStorageKind() != JavaKind.Object));
    }

    private static ValueNode maybeUncompress(ValueNode node) {
        Stamp stamp = node.stamp(NodeView.DEFAULT);
        if (stamp instanceof NarrowOopStamp) {
            return SubstrateCompressionNode.uncompress(node.graph(), node, ((NarrowOopStamp)stamp).getEncoding());
        }
        return node;
    }

    protected ValueNode createReadArrayComponentHub(StructuredGraph graph, ValueNode arrayHub, boolean isKnownObjectArray, FixedNode anchor) {
        ConstantNode componentHubOffset = ConstantNode.forIntegerKind((JavaKind)this.target.wordJavaKind, (long)this.knownOffsets.getComponentHubOffset(), (StructuredGraph)graph);
        AddressNode componentHubAddress = (AddressNode)graph.unique((Node)new OffsetAddressNode(arrayHub, (ValueNode)componentHubOffset));
        FloatingReadNode componentHubRef = (FloatingReadNode)graph.unique((Node)new FloatingReadNode(componentHubAddress, NamedLocationIdentity.FINAL_LOCATION, null, (Stamp)this.hubStamp, null, BarrierType.NONE));
        return SubstrateBasicLoweringProvider.maybeUncompress((ValueNode)componentHubRef);
    }

    protected ValueNode createReadHub(StructuredGraph graph, ValueNode object, LoweringTool tool) {
        ValueNode hubBits;
        AbstractPointerStamp loadHubStamp;
        ValueNode synonym;
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return (ValueNode)graph.unique((Node)new LoadHubNode(tool.getStampProvider(), object));
        }
        if (object.isConstant() && !object.asJavaConstant().isNull() && (synonym = LoadHubNode.findSynonym((ValueNode)object, (Stamp)(loadHubStamp = tool.getStampProvider().createHubStamp((ObjectStamp)object.stamp(NodeView.DEFAULT))), (MetaAccessProvider)tool.getMetaAccess(), (ConstantReflectionProvider)tool.getConstantReflection())) != null) {
            return synonym;
        }
        GraalError.guarantee((!object.isConstant() || object.asJavaConstant().isNull() ? 1 : 0) != 0, (String)"Object should either not be a constant or the null constant %s", (Object)object);
        ObjectLayout objectLayout = this.getObjectLayout();
        IntegerStamp headerBitsStamp = StampFactory.forUnsignedInteger((int)(8 * objectLayout.getReferenceSize()));
        ConstantNode headerOffset = ConstantNode.forIntegerKind((JavaKind)this.target.wordJavaKind, (long)objectLayout.getHubOffset(), (StructuredGraph)graph);
        AddressNode headerAddress = (AddressNode)graph.unique((Node)new OffsetAddressNode(object, (ValueNode)headerOffset));
        ValueNode headerBits = (ValueNode)graph.unique((Node)new FloatingReadNode(headerAddress, NamedLocationIdentity.FINAL_LOCATION, null, (Stamp)headerBitsStamp, null, BarrierType.NONE));
        int reservedBitsMask = Heap.getHeap().getObjectHeader().getReservedBitsMask();
        if (reservedBitsMask != 0) {
            assert (CodeUtil.isPowerOf2((int)(reservedBitsMask + 1))) : "only the lowest bits may be set";
            int numReservedBits = CodeUtil.log2((int)(reservedBitsMask + 1));
            int compressionShift = ReferenceAccess.singleton().getCompressionShift();
            int numAlignmentBits = CodeUtil.log2((int)objectLayout.getAlignment());
            assert (compressionShift <= numAlignmentBits) : "compression discards bits";
            if (numReservedBits == numAlignmentBits && compressionShift == 0) {
                hubBits = (ValueNode)graph.unique((Node)new AndNode(headerBits, (ValueNode)ConstantNode.forIntegerStamp((Stamp)headerBitsStamp, (long)(~reservedBitsMask), (StructuredGraph)graph)));
            } else {
                hubBits = (ValueNode)graph.unique((Node)new UnsignedRightShiftNode(headerBits, (ValueNode)ConstantNode.forInt((int)numReservedBits, (StructuredGraph)graph)));
                if (compressionShift != numAlignmentBits) {
                    int shift = numAlignmentBits - compressionShift;
                    hubBits = (ValueNode)graph.unique((Node)new LeftShiftNode(hubBits, (ValueNode)ConstantNode.forInt((int)shift, (StructuredGraph)graph)));
                }
            }
        } else {
            hubBits = headerBits;
        }
        FloatingWordCastNode hubRef = (FloatingWordCastNode)graph.unique((Node)new FloatingWordCastNode((Stamp)this.hubStamp, hubBits));
        return SubstrateBasicLoweringProvider.maybeUncompress((ValueNode)hubRef);
    }

    public FieldLocationIdentity overrideFieldLocationIdentity(FieldLocationIdentity field) {
        return new SubstrateFieldLocationIdentity(field);
    }

    public int fieldOffset(ResolvedJavaField f) {
        SharedField field = (SharedField)f;
        return field.isAccessed() ? field.getLocation() : -1;
    }

    private static void lowerAssertionNode(AssertionNode n) {
        n.graph().removeFixed((FixedWithNextNode)n);
    }

    protected void lowerDeadEnd(DeadEndNode deadEnd) {
        deadEnd.replaceAndDelete(deadEnd.graph().add((Node)new LoweredDeadEndNode()));
    }

    protected Stamp loadCompressedStamp(ObjectStamp stamp) {
        return SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)stamp, ReferenceAccess.singleton().getCompressEncoding());
    }

    protected ValueNode newCompressionNode(CompressionNode.CompressionOp op, ValueNode value) {
        return new SubstrateCompressionNode(op, value, ReferenceAccess.singleton().getCompressEncoding());
    }

    public boolean targetingLLVM() {
        return false;
    }
}

