/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.RuntimeSupportFeature;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import com.oracle.svm.core.jdk.management.SubstrateRuntimeMXBean;
import com.oracle.svm.core.jdk.management.SubstrateThreadMXBean;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.thread.ThreadListenerSupportFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerBuilder;
import javax.management.openmbean.OpenType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticallyRegisteredFeature
public final class ManagementFeature
extends JNIRegistrationUtil
implements InternalFeature {
    private Map<PlatformManagedObject, PlatformManagedObject> platformManagedObjectReplacements;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(RuntimeSupportFeature.class, ThreadListenerSupportFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        SubstrateRuntimeMXBean runtimeMXBean = new SubstrateRuntimeMXBean();
        ImageSingletons.add(SubstrateRuntimeMXBean.class, (Object)runtimeMXBean);
        SubstrateThreadMXBean threadMXBean = new SubstrateThreadMXBean();
        ImageSingletons.add(SubstrateThreadMXBean.class, (Object)threadMXBean);
        ManagementSupport managementSupport = new ManagementSupport(runtimeMXBean, threadMXBean);
        ImageSingletons.add(ManagementSupport.class, (Object)managementSupport);
        ThreadListenerSupport.get().register(managementSupport);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.platformManagedObjectReplacements = new IdentityHashMap<PlatformManagedObject, PlatformManagedObject>();
        for (Class clazz : Arrays.asList(ClassLoadingMXBean.class, CompilationMXBean.class, RuntimeMXBean.class, ThreadMXBean.class, OperatingSystemMXBean.class, MemoryMXBean.class)) {
            Object source = ManagementFactory.getPlatformMXBean(clazz);
            PlatformManagedObject target = (PlatformManagedObject)ManagementSupport.getSingleton().platformManagedObjectsMap.get(clazz);
            if (source == null || target == null) continue;
            this.platformManagedObjectReplacements.put((PlatformManagedObject)source, target);
        }
        access.registerObjectReplacer(this::replaceHostedPlatformManagedObject);
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.sun.jmx.mbeanserver.DefaultMXBeanMappingFactory"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.sun.jmx.mbeanserver.DefaultMXBeanMappingFactory$Mappings"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.sun.jmx.mbeanserver.DefaultMXBeanMappingFactory$IdentityMapping"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.sun.jmx.mbeanserver.DescriptorCache"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.sun.jmx.remote.util.ClassLogger"});
    }

    private Object replaceHostedPlatformManagedObject(Object source) {
        PlatformManagedObject replacement;
        if (source instanceof PlatformManagedObject && (replacement = this.platformManagedObjectReplacements.get(source)) != null) {
            return replacement;
        }
        return source;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(ManagementFeature::registerMBeanServerFactoryNewBuilder, new Object[]{ManagementFeature.method((Feature.FeatureAccess)access, "javax.management.MBeanServerFactory", "newBuilder", Class.class)});
        access.registerReachabilityHandler(ManagementFeature::registerMXBeanMappingMakeOpenClass, new Object[]{ManagementFeature.method((Feature.FeatureAccess)access, "com.sun.jmx.mbeanserver.MXBeanMapping", "makeOpenClass", Type.class, OpenType.class)});
        assert (ManagementFeature.verifyMemoryManagerBeans());
    }

    private static boolean verifyMemoryManagerBeans() {
        ManagementSupport managementSupport = ManagementSupport.getSingleton();
        List<MemoryPoolMXBean> memoryPools = managementSupport.getPlatformMXBeans(MemoryPoolMXBean.class);
        List<MemoryManagerMXBean> memoryManagers = managementSupport.getPlatformMXBeans(MemoryManagerMXBean.class);
        HashSet<String> memoryManagerNames = new HashSet<String>();
        HashSet<String> memoryPoolNames = new HashSet<String>();
        for (MemoryPoolMXBean memoryPool : memoryPools) {
            String memoryPoolName = memoryPool.getName();
            assert (ManagementFeature.verifyObjectName(memoryPoolName));
            memoryPoolNames.add(memoryPoolName);
        }
        for (MemoryManagerMXBean memoryManager : memoryManagers) {
            String memoryManagerName = memoryManager.getName();
            assert (ManagementFeature.verifyObjectName(memoryManagerName));
            memoryManagerNames.add(memoryManagerName);
            assert (memoryPoolNames.containsAll(List.of(memoryManager.getMemoryPoolNames()))) : memoryManagerName;
        }
        for (MemoryPoolMXBean memoryPool : memoryPools) {
            assert (memoryManagerNames.containsAll(List.of(memoryPool.getMemoryManagerNames()))) : memoryPool.getName();
        }
        return true;
    }

    private static boolean verifyObjectName(String name) {
        assert (!name.contains(":"));
        assert (!name.contains("="));
        assert (!name.contains("\""));
        assert (!name.contains("\n"));
        return true;
    }

    private static void registerMBeanServerFactoryNewBuilder(Feature.DuringAnalysisAccess a) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(MBeanServerBuilder.class, (Class[])new Class[0])});
    }

    private static void registerMXBeanMappingMakeOpenClass(Feature.DuringAnalysisAccess access) {
        for (String className : OpenType.ALLOWED_CLASSNAMES_LIST) {
            RuntimeReflection.register((Class[])new Class[]{ManagementFeature.clazz((Feature.FeatureAccess)access, className)});
            RuntimeReflection.register((Class[])new Class[]{ManagementFeature.clazz((Feature.FeatureAccess)access, "[L" + className + ";")});
        }
    }
}

