/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferList;
import com.oracle.svm.core.jfr.JfrBufferNode;
import com.oracle.svm.core.jfr.JfrBufferNodeAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrCheckpointType;
import com.oracle.svm.core.jfr.JfrGlobalMemory;
import com.oracle.svm.core.jfr.JfrMetadata;
import com.oracle.svm.core.jfr.JfrMethodRepository;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrRepository;
import com.oracle.svm.core.jfr.JfrReservedEvent;
import com.oracle.svm.core.jfr.JfrSerializer;
import com.oracle.svm.core.jfr.JfrSerializerSupport;
import com.oracle.svm.core.jfr.JfrStackTraceRepository;
import com.oracle.svm.core.jfr.JfrSymbolRepository;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrThreadRepository;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.JfrTypeRepository;
import com.oracle.svm.core.jfr.JfrUnlockedChunkWriter;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.sampler.SamplerBuffersAccess;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import java.nio.charset.StandardCharsets;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JfrChunkWriter
implements JfrUnlockedChunkWriter {
    public static final byte[] FILE_MAGIC = new byte[]{70, 76, 82, 0};
    public static final short JFR_VERSION_MAJOR = 2;
    public static final short JFR_VERSION_MINOR = 1;
    private static final int CHUNK_SIZE_OFFSET = 8;
    private static final int FILE_STATE_OFFSET = 64;
    private static final byte COMPLETE = 0;
    private static final short FLAG_COMPRESSED_INTS = 1;
    private static final short FLAG_CHUNK_FINAL = 2;
    private final VMMutex lock = new VMMutex("jfrChunkWriter");
    private final JfrGlobalMemory globalMemory;
    private final JfrMetadata metadata;
    private final JfrRepository[] flushCheckpointRepos;
    private final JfrRepository[] threadCheckpointRepos;
    private final boolean compressedInts;
    private long notificationThreshold;
    private String filename;
    private RawFileOperationSupport.RawFileDescriptor fd;
    private long chunkStartTicks;
    private long chunkStartNanos;
    private byte nextGeneration;
    private boolean newChunk;
    private boolean isFinal;
    private long lastMetadataId;
    private long metadataPosition;
    private long lastCheckpointOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrChunkWriter(JfrGlobalMemory globalMemory, JfrStackTraceRepository stackTraceRepo, JfrMethodRepository methodRepo, JfrTypeRepository typeRepo, JfrSymbolRepository symbolRepo, JfrThreadRepository threadRepo) {
        this.globalMemory = globalMemory;
        this.metadata = new JfrMetadata(null);
        this.compressedInts = true;
        this.flushCheckpointRepos = new JfrRepository[]{stackTraceRepo, methodRepo, typeRepo, symbolRepo};
        this.threadCheckpointRepos = new JfrRepository[]{threadRepo};
    }

    @Override
    public void initialize(long maxChunkSize) {
        this.notificationThreshold = maxChunkSize;
    }

    @Override
    public JfrChunkWriter lock() {
        assert (!VMOperation.isInProgressAtSafepoint()) : "could cause deadlocks";
        this.lock.lock();
        return this;
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOpenFile() {
        return JfrChunkWriter.getFileSupport().isValid(this.fd);
    }

    public long getChunkStartNanos() {
        return this.chunkStartNanos;
    }

    public void setFilename(String filename) {
        assert (this.lock.isOwner());
        this.filename = filename;
    }

    public void maybeOpenFile() {
        assert (this.lock.isOwner());
        if (this.filename != null) {
            this.openFile(this.filename);
        }
    }

    public void openFile(String outputFile) {
        assert (this.lock.isOwner());
        this.filename = outputFile;
        this.fd = JfrChunkWriter.getFileSupport().create(this.filename, RawFileOperationSupport.FileCreationMode.CREATE_OR_REPLACE, RawFileOperationSupport.FileAccessMode.READ_WRITE);
        this.chunkStartTicks = JfrTicks.elapsedTicks();
        this.chunkStartNanos = JfrTicks.currentTimeNanos();
        this.nextGeneration = 1;
        this.newChunk = true;
        this.isFinal = false;
        this.lastMetadataId = -1L;
        this.metadataPosition = -1L;
        this.lastCheckpointOffset = -1L;
        this.writeFileHeader();
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the flushed position.")
    public void write(JfrBuffer buffer) {
        assert (this.lock.isOwner());
        assert (buffer.isNonNull());
        assert (buffer.getBufferType() == JfrBufferType.C_HEAP || VMOperation.isInProgressAtSafepoint() || JfrBufferNodeAccess.isLockedByCurrentThread(buffer.getNode()));
        UnsignedWord unflushedSize = JfrBufferAccess.getUnflushedSize(buffer);
        if (unflushedSize.equal(0)) {
            return;
        }
        boolean success = JfrChunkWriter.getFileSupport().write(this.fd, JfrBufferAccess.getFlushedPos(buffer), unflushedSize);
        if (success) {
            JfrBufferAccess.increaseFlushedPos(buffer, unflushedSize);
        }
    }

    public void flush() {
        assert (this.lock.isOwner());
        this.flushStorage(true);
        this.writeThreadCheckpoint(true);
        this.writeFlushCheckpoint(true);
        this.writeMetadataEvent();
        this.patchFileHeader(true);
        this.newChunk = false;
    }

    public void markChunkFinal() {
        assert (this.lock.isOwner());
        this.isFinal = true;
    }

    public void closeFile() {
        assert (this.lock.isOwner());
        JfrChangeEpochOperation op = new JfrChangeEpochOperation();
        op.enqueue();
        this.writeThreadCheckpoint(false);
        this.writeFlushCheckpoint(false);
        this.writeMetadataEvent();
        this.patchFileHeader(false);
        JfrChunkWriter.getFileSupport().close(this.fd);
        this.filename = null;
        this.fd = (RawFileOperationSupport.RawFileDescriptor)WordFactory.nullPointer();
    }

    private void writeFileHeader() {
        JfrChunkWriter.getFileSupport().write(this.fd, FILE_MAGIC);
        JfrChunkWriter.getFileSupport().writeShort(this.fd, (short)2);
        JfrChunkWriter.getFileSupport().writeShort(this.fd, (short)1);
        assert (JfrChunkWriter.getFileSupport().position(this.fd) == 8L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, this.chunkStartNanos);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, this.chunkStartTicks);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, JfrTicks.getTicksFrequency());
        assert (JfrChunkWriter.getFileSupport().position(this.fd) == 64L);
        JfrChunkWriter.getFileSupport().writeByte(this.fd, this.getAndIncrementGeneration());
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)0);
        JfrChunkWriter.getFileSupport().writeShort(this.fd, this.computeHeaderFlags());
    }

    private void patchFileHeader(boolean flushpoint) {
        assert (this.lock.isOwner());
        assert (this.metadataPosition > 0L);
        assert (this.lastCheckpointOffset > 0L);
        byte generation = flushpoint ? this.getAndIncrementGeneration() : (byte)0;
        long currentPos = JfrChunkWriter.getFileSupport().position(this.fd);
        long durationNanos = JfrTicks.currentTimeNanos() - this.chunkStartNanos;
        JfrChunkWriter.getFileSupport().seek(this.fd, 8L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, currentPos);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, this.lastCheckpointOffset);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, this.metadataPosition);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, this.chunkStartNanos);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, durationNanos);
        JfrChunkWriter.getFileSupport().seek(this.fd, 64L);
        JfrChunkWriter.getFileSupport().writeByte(this.fd, generation);
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)0);
        JfrChunkWriter.getFileSupport().writeShort(this.fd, this.computeHeaderFlags());
        JfrChunkWriter.getFileSupport().seek(this.fd, currentPos);
    }

    private short computeHeaderFlags() {
        short flags = 0;
        if (this.compressedInts) {
            flags = (short)(flags | 1);
        }
        if (this.isFinal) {
            flags = (short)(flags | 2);
        }
        return flags;
    }

    private byte getAndIncrementGeneration() {
        if (this.nextGeneration == 127) {
            this.nextGeneration = 1;
            return 127;
        }
        byte by = this.nextGeneration;
        this.nextGeneration = (byte)(by + 1);
        return by;
    }

    private void writeFlushCheckpoint(boolean flushpoint) {
        this.writeCheckpointEvent(JfrCheckpointType.Flush, this.flushCheckpointRepos, this.newChunk, flushpoint);
    }

    private void writeThreadCheckpoint(boolean flushpoint) {
        assert (this.threadCheckpointRepos.length == 1 && this.threadCheckpointRepos[0] == SubstrateJVM.getThreadRepo());
        if (SubstrateJVM.getThreadRepo().hasUnflushedData()) {
            this.writeCheckpointEvent(JfrCheckpointType.Threads, this.threadCheckpointRepos, false, flushpoint);
        } else if (!flushpoint) {
            SubstrateJVM.getThreadRepo().clearPreviousEpoch();
        }
    }

    private void writeCheckpointEvent(JfrCheckpointType type, JfrRepository[] repositories, boolean writeSerializers, boolean flushpoint) {
        assert (this.lock.isOwner());
        long start = this.beginEvent();
        this.writeCompressedLong(JfrReservedEvent.CHECKPOINT.getId());
        this.writeCompressedLong(JfrTicks.elapsedTicks());
        this.writeCompressedLong(0L);
        this.writeCompressedLong(this.getDeltaToLastCheckpoint(start));
        this.writeByte(type.getId());
        long poolCountPos = JfrChunkWriter.getFileSupport().position(this.fd);
        JfrChunkWriter.getFileSupport().writeInt(this.fd, 0);
        int poolCount = writeSerializers ? this.writeSerializers() : 0;
        long currentPos = JfrChunkWriter.getFileSupport().position(this.fd);
        JfrChunkWriter.getFileSupport().seek(this.fd, poolCountPos);
        this.writePaddedInt(poolCount += this.writeConstantPools(repositories, flushpoint));
        JfrChunkWriter.getFileSupport().seek(this.fd, currentPos);
        this.endEvent(start);
        this.lastCheckpointOffset = start;
    }

    private long getDeltaToLastCheckpoint(long startOfNewCheckpoint) {
        if (this.lastCheckpointOffset < 0L) {
            return 0L;
        }
        return this.lastCheckpointOffset - startOfNewCheckpoint;
    }

    private int writeSerializers() {
        JfrSerializer[] serializers;
        for (JfrSerializer serializer : serializers = JfrSerializerSupport.get().getSerializers()) {
            serializer.write(this);
        }
        return serializers.length;
    }

    private int writeConstantPools(JfrRepository[] repositories, boolean flushpoint) {
        int poolCount = 0;
        for (JfrRepository repo : repositories) {
            poolCount += repo.write(this, flushpoint);
        }
        return poolCount;
    }

    public void setMetadata(byte[] bytes) {
        this.metadata.setDescriptor(bytes);
    }

    private void writeMetadataEvent() {
        assert (this.lock.isOwner());
        long currentMetadataId = this.metadata.getCurrentMetadataId();
        if (this.lastMetadataId == currentMetadataId) {
            return;
        }
        long start = this.beginEvent();
        this.writeCompressedLong(JfrReservedEvent.METADATA.getId());
        this.writeCompressedLong(JfrTicks.elapsedTicks());
        this.writeCompressedLong(0L);
        this.writeCompressedLong(currentMetadataId);
        this.writeBytes(this.metadata.getDescriptor());
        this.endEvent(start);
        this.metadataPosition = start;
        this.lastMetadataId = currentMetadataId;
    }

    public boolean shouldRotateDisk() {
        assert (this.lock.isOwner());
        return JfrChunkWriter.getFileSupport().isValid(this.fd) && JfrChunkWriter.getFileSupport().size(this.fd) > this.notificationThreshold;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long beginEvent() {
        long start = JfrChunkWriter.getFileSupport().position(this.fd);
        JfrChunkWriter.getFileSupport().writeInt(this.fd, 0);
        return start;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void endEvent(long start) {
        long end = JfrChunkWriter.getFileSupport().position(this.fd);
        long writtenBytes = end - start;
        assert ((long)((int)writtenBytes) == writtenBytes);
        JfrChunkWriter.getFileSupport().seek(this.fd, start);
        this.writePaddedInt(writtenBytes);
        JfrChunkWriter.getFileSupport().seek(this.fd, end);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeBoolean(boolean value) {
        assert (this.lock.isOwner() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.hasOwner());
        this.writeByte((byte)(value ? 1 : 0));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeByte(byte value) {
        assert (this.lock.isOwner() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.hasOwner());
        JfrChunkWriter.getFileSupport().writeByte(this.fd, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeBytes(byte[] values) {
        assert (this.lock.isOwner() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.hasOwner());
        JfrChunkWriter.getFileSupport().write(this.fd, values);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeCompressedInt(int value) {
        assert (this.lock.isOwner() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.hasOwner());
        this.writeCompressedLong((long)value & 0xFFFFFFFFL);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writePaddedInt(long value) {
        assert (this.lock.isOwner() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.hasOwner());
        assert ((long)((int)value) == value);
        JfrChunkWriter.getFileSupport().writeInt(this.fd, JfrNativeEventWriter.makePaddedInt((int)value));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeCompressedLong(long value) {
        assert (this.lock.isOwner() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.hasOwner());
        long v = value;
        if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v >>> 7));
    }

    @Fold
    static RawFileOperationSupport getFileSupport() {
        return RawFileOperationSupport.bigEndian();
    }

    public void writeString(String str) {
        if (str.isEmpty()) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, StringEncoding.EMPTY_STRING.getValue());
        } else {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            JfrChunkWriter.getFileSupport().writeByte(this.fd, StringEncoding.UTF8_BYTE_ARRAY.getValue());
            this.writeCompressedInt(bytes.length);
            JfrChunkWriter.getFileSupport().write(this.fd, bytes);
        }
    }

    @Uninterruptible(reason="Prevent pollution of the current thread's thread local JFR buffer.")
    private void flushStorage(boolean flushpoint) {
        this.traverseThreadLocalBuffers(JfrThreadLocal.getJavaBufferList(), flushpoint);
        this.traverseThreadLocalBuffers(JfrThreadLocal.getNativeBufferList(), flushpoint);
        this.flushGlobalMemory(flushpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private void traverseThreadLocalBuffers(JfrBufferList list, boolean flushpoint) {
        JfrBufferNode node = list.getHead();
        JfrBufferNode prev = (JfrBufferNode)WordFactory.nullPointer();
        while (node.isNonNull()) {
            JfrBufferNode next = node.getNext();
            boolean lockAcquired = JfrBufferNodeAccess.tryLock(node);
            if (lockAcquired) {
                JfrBuffer buffer = JfrBufferNodeAccess.getBuffer(node);
                if (buffer.isNull()) {
                    list.removeNode(node, prev);
                    JfrBufferNodeAccess.free(node);
                    node = next;
                    continue;
                }
                try {
                    if (flushpoint) {
                        SubstrateJVM.getGlobalMemory().write(buffer, true);
                    } else {
                        this.write(buffer);
                    }
                }
                finally {
                    JfrBufferNodeAccess.unlock(node);
                }
            }
            assert (lockAcquired || flushpoint);
            prev = node;
            node = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private void flushGlobalMemory(boolean flushpoint) {
        JfrBufferList buffers = this.globalMemory.getBuffers();
        JfrBufferNode node = buffers.getHead();
        while (node.isNonNull()) {
            boolean lockAcquired = JfrBufferNodeAccess.tryLock(node);
            if (lockAcquired) {
                try {
                    JfrBuffer buffer = JfrBufferNodeAccess.getBuffer(node);
                    this.write(buffer);
                    JfrBufferAccess.reinitialize(buffer);
                }
                finally {
                    JfrBufferNodeAccess.unlock(node);
                }
            }
            assert (lockAcquired || flushpoint);
            node = node.getNext();
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isLockedByCurrentThread() {
        return this.lock.isOwner();
    }

    private class JfrChangeEpochOperation
    extends JavaVMOperation {
        protected JfrChangeEpochOperation() {
            super(VMOperationInfos.get(JfrChangeEpochOperation.class, "JFR change epoch", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            this.changeEpoch();
        }

        @Uninterruptible(reason="Prevent pollution of the current thread's thread local JFR buffer.")
        private void changeEpoch() {
            JfrChangeEpochOperation.processSamplerBuffers();
            JfrChunkWriter.this.flushStorage(false);
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                JfrThreadLocal.notifyEventWriter(thread);
                thread = VMThreads.nextThread(thread);
            }
            JfrTraceIdEpoch.getInstance().changeEpoch();
            SubstrateJVM.getThreadRepo().registerRunningThreads();
        }

        @Uninterruptible(reason="Prevent JFR recording.")
        private static void processSamplerBuffers() {
            assert (VMOperation.isInProgressAtSafepoint());
            assert (ThreadingSupportImpl.isRecurringCallbackPaused());
            JfrExecutionSampler.singleton().disallowThreadsInSamplerCode();
            try {
                JfrChangeEpochOperation.processSamplerBuffers0();
            }
            finally {
                JfrExecutionSampler.singleton().allowThreadsInSamplerCode();
            }
        }

        @Uninterruptible(reason="Prevent JFR recording.")
        private static void processSamplerBuffers0() {
            SamplerBuffersAccess.processActiveBuffers();
            SamplerBuffersAccess.processFullBuffers(false);
        }
    }

    public static enum StringEncoding {
        NULL(0),
        EMPTY_STRING(1),
        CONSTANT_POOL(2),
        UTF8_BYTE_ARRAY(3),
        CHAR_ARRAY(4),
        LATIN1_BYTE_ARRAY(5);

        private final byte value;

        private StringEncoding(int value) {
            this.value = NumUtil.safeToByte((int)value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public byte getValue() {
            return this.value;
        }
    }
}

