/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jvmstat;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfMemoryProvider;
import com.oracle.svm.core.posix.jvmstat.PosixPerfMemoryProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
class PosixPerfMemoryFeature
implements InternalFeature {
    PosixPerfMemoryFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspectionOptions.hasJvmstatSupport() && PerfManager.Options.PerfDataMemoryMappedFile.getValue() != false;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(PerfMemoryProvider.class, (Object)new PosixPerfMemoryProvider());
    }
}

