/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import org.graalvm.nativeimage.c.type.CIntPointer;

public class NativeSpinLockUtils {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize(CIntPointer spinLock) {
        JavaSpinLockUtils.initialize(null, spinLock.rawValue());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isLocked(CIntPointer spinLock) {
        return JavaSpinLockUtils.isLocked(null, spinLock.rawValue());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean tryLock(CIntPointer spinLock) {
        return JavaSpinLockUtils.tryLock(null, spinLock.rawValue());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean tryLock(CIntPointer spinLock, int retries) {
        return JavaSpinLockUtils.tryLock(null, spinLock.rawValue(), retries);
    }

    @Uninterruptible(reason="This method does not do a transition, so the whole critical section must be uninterruptible.", callerMustBe=true)
    public static void lockNoTransition(CIntPointer spinLock) {
        JavaSpinLockUtils.lockNoTransition(null, spinLock.rawValue());
    }

    @Uninterruptible(reason="The whole critical section must be uninterruptible.", callerMustBe=true)
    public static void unlock(CIntPointer spinLock) {
        JavaSpinLockUtils.unlock(null, spinLock.rawValue());
    }
}

