/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

@AutomaticallyRegisteredFeature
public final class ResourcesFeature
implements InternalFeature {
    static final String MODULE_NAME_ALL_UNNAMED = "ALL-UNNAMED";
    private boolean sealed = false;
    private final Set<String> resourcePatternWorkSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> excludedResourcePatterns = Collections.newSetFromMap(new ConcurrentHashMap());
    private int loadedConfigurations;
    private ImageClassLoader imageClassLoader;

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)a;
        this.imageClassLoader = access.getImageClassLoader();
        ResourcesRegistryImpl resourcesRegistry = new ResourcesRegistryImpl(new ConfigurationTypeResolver("resource configuration", this.imageClassLoader));
        ImageSingletons.add(ResourcesRegistry.class, (Object)resourcesRegistry);
        ImageSingletons.add(RuntimeResourceSupport.class, (Object)resourcesRegistry);
    }

    private static ResourcesRegistryImpl resourceRegistryImpl() {
        return (ResourcesRegistryImpl)ImageSingletons.lookup(ResourcesRegistry.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ResourceConfigurationParser parser = ResourceConfigurationParser.create(true, ResourcesRegistry.singleton(), ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile(parser, this.imageClassLoader, "resource");
        ResourceConfigurationParser legacyParser = ResourceConfigurationParser.create(false, ResourcesRegistry.singleton(), ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations += ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)legacyParser, this.imageClassLoader, "resource", ConfigurationFiles.Options.ResourceConfigurationFiles, ConfigurationFiles.Options.ResourceConfigurationResources, ConfigurationFile.RESOURCES.getFileName());
        this.resourcePatternWorkSet.addAll(Options.IncludeResources.getValue().values());
        this.excludedResourcePatterns.addAll(Options.ExcludeResources.getValue().values());
        ResourcesFeature.resourceRegistryImpl().flushConditionalConfiguration(access);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        ResourcesFeature.resourceRegistryImpl().flushConditionalConfiguration(access);
        if (this.resourcePatternWorkSet.isEmpty()) {
            return;
        }
        access.requireAnalysisIteration();
        FeatureImpl.DuringAnalysisAccessImpl duringAnalysisAccess = (FeatureImpl.DuringAnalysisAccessImpl)access;
        ResourcePattern[] includePatterns = this.compilePatterns(this.resourcePatternWorkSet);
        if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            for (ResourcePattern resourcePattern : includePatterns) {
                Resources.singleton().registerIncludePattern(resourcePattern.moduleName, resourcePattern.pattern.pattern());
            }
        }
        ResourcePattern[] excludePatterns = this.compilePatterns(this.excludedResourcePatterns);
        DebugContext debugContext = duringAnalysisAccess.getDebugContext();
        ResourceCollectorImpl collector = new ResourceCollectorImpl(debugContext, includePatterns, excludePatterns, duringAnalysisAccess.bb.getHeartbeatCallback());
        try {
            collector.prepareProgressReporter();
            ((ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class)).collectResources(collector);
        }
        finally {
            collector.shutDownProgressReporter();
        }
        this.resourcePatternWorkSet.clear();
    }

    private ResourcePattern[] compilePatterns(Set<String> patterns) {
        return patterns.stream().filter(s -> s.length() > 0).map(this::makeResourcePattern).toList().toArray(new ResourcePattern[0]);
    }

    private ResourcePattern makeResourcePattern(String rawPattern) {
        String[] moduleNameWithPattern = SubstrateUtil.split(rawPattern, ":", 2);
        if (moduleNameWithPattern.length < 2) {
            return new ResourcePattern(null, Pattern.compile(moduleNameWithPattern[0]));
        }
        String moduleName = moduleNameWithPattern[0];
        return new ResourcePattern(moduleName, Pattern.compile(moduleNameWithPattern[1]));
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest resourceFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).resourceFallback;
        if (resourceFallback != null && Options.IncludeResources.getValue().values().isEmpty() && this.loadedConfigurations == 0) {
            throw resourceFallback;
        }
    }

    private static void registerResource(DebugContext debugContext, Module module, String resourceName, InputStream resourceStream, boolean fromJar) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            String moduleNamePrefix = module == null ? "" : module.getName() + ":";
            debugContext.log(3, "ResourcesFeature: registerResource: %s%s", (Object)moduleNamePrefix, (Object)resourceName);
            Resources.singleton().registerResource(module, resourceName, resourceStream, fromJar);
        }
    }

    private static void registerDirectoryResource(DebugContext debugContext, Module module, String dir, String content, boolean fromJar) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            String moduleNamePrefix = module == null ? "" : module.getName() + ":";
            debugContext.log(3, "ResourcesFeature: registerResource: %s%s", (Object)moduleNamePrefix, (Object)dir);
            Resources.singleton().registerDirectoryResource(module, dir, content, fromJar);
        }
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (!reason.duringAnalysis() || reason == ParsingReason.JITCompilation) {
            return;
        }
        Method[] resourceMethods = new Method[]{ReflectionUtil.lookupMethod(Class.class, (String)"getResource", (Class[])new Class[]{String.class}), ReflectionUtil.lookupMethod(Class.class, (String)"getResourceAsStream", (Class[])new Class[]{String.class})};
        Method resolveResourceName = ReflectionUtil.lookupMethod(Class.class, (String)"resolveName", (Class[])new Class[]{String.class});
        for (Method method : resourceMethods) {
            this.registerResourceRegistrationPlugin(plugins.getInvocationPlugins(), method, snippetReflection, resolveResourceName, reason);
        }
    }

    private void registerResourceRegistrationPlugin(InvocationPlugins plugins, Method method, final SnippetReflectionProvider snippetReflectionProvider, final Method resolveResourceName, final ParsingReason reason) {
        ArrayList parameterTypes = new ArrayList();
        assert (!Modifier.isStatic(method.getModifiers()));
        parameterTypes.add(InvocationPlugin.Receiver.class);
        parameterTypes.addAll(Arrays.asList(method.getParameterTypes()));
        plugins.register(method.getDeclaringClass(), (InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(method.getName(), parameterTypes.toArray(new Class[0])){

            public boolean isDecorator() {
                return true;
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                try {
                    if (!ResourcesFeature.this.sealed && receiver.isConstant() && arg.isJavaConstant() && !arg.isNullConstant()) {
                        Class clazz = (Class)snippetReflectionProvider.asObject(Class.class, receiver.get().asJavaConstant());
                        String resource = (String)snippetReflectionProvider.asObject(String.class, arg.asJavaConstant());
                        String resourceName = (String)resolveResourceName.invoke((Object)clazz, resource);
                        b.add((Node)ReachabilityRegistrationNode.create(() -> RuntimeResourceAccess.addResource((Module)clazz.getModule(), (String)resourceName), reason));
                        return true;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw VMError.shouldNotReachHere(e);
                }
                return false;
            }
        });
    }

    private class ResourcesRegistryImpl
    extends ConditionalConfigurationRegistry
    implements ResourcesRegistry {
        private final ConfigurationTypeResolver configurationTypeResolver;

        ResourcesRegistryImpl(ConfigurationTypeResolver configurationTypeResolver) {
            this.configurationTypeResolver = configurationTypeResolver;
        }

        @Override
        public void addResources(ConfigurationCondition condition, String pattern) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> {
                UserError.guarantee(!ResourcesFeature.this.sealed, "Resources added too late: %s", pattern);
                ResourcesFeature.this.resourcePatternWorkSet.add(pattern);
            });
        }

        public void injectResource(Module module, String resourcePath, byte[] resourceContent) {
            Resources.singleton().registerResource(module, resourcePath, resourceContent);
        }

        @Override
        public void ignoreResources(ConfigurationCondition condition, String pattern) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> {
                UserError.guarantee(!ResourcesFeature.this.sealed, "Resources ignored too late: %s", pattern);
                ResourcesFeature.this.excludedResourcePatterns.add(pattern);
            });
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String name) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(name));
        }

        @Override
        public void addClassBasedResourceBundle(ConfigurationCondition condition, String basename, String className) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareClassResourceBundle(basename, className));
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String basename, Collection<Locale> locales) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(basename, locales));
        }
    }

    public static class Options {
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ExcludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
    }

    private static final class ResourcePattern {
        final String moduleName;
        final Pattern pattern;

        private ResourcePattern(String moduleName, Pattern pattern) {
            this.moduleName = moduleName;
            this.pattern = pattern;
        }

        boolean moduleNameMatches(String resourceContainerModuleName) {
            if (this.moduleName == null) {
                return true;
            }
            if (this.moduleName.equals(ResourcesFeature.MODULE_NAME_ALL_UNNAMED)) {
                return resourceContainerModuleName == null;
            }
            return this.moduleName.equals(resourceContainerModuleName);
        }
    }

    private static final class ResourceCollectorImpl
    implements ClassLoaderSupport.ResourceCollector {
        private final DebugContext debugContext;
        private final ResourcePattern[] includePatterns;
        private final ResourcePattern[] excludePatterns;
        private static final int WATCHDOG_RESET_AFTER_EVERY_N_RESOURCES = 1000;
        private static final int WATCHDOG_INITIAL_WARNING_AFTER_N_SECONDS = 60;
        private static final int WATCHDOG_WARNING_AFTER_EVERY_N_SECONDS = 20;
        private final Runnable heartbeatCallback;
        private final LongAdder reachedResourceEntries;
        private boolean initialReport;
        private volatile String currentlyProcessedEntry;
        ScheduledExecutorService scheduledExecutor;

        private ResourceCollectorImpl(DebugContext debugContext, ResourcePattern[] includePatterns, ResourcePattern[] excludePatterns, Runnable heartbeatCallback) {
            this.debugContext = debugContext;
            this.includePatterns = includePatterns;
            this.excludePatterns = excludePatterns;
            this.heartbeatCallback = heartbeatCallback;
            this.reachedResourceEntries = new LongAdder();
            this.initialReport = true;
            this.currentlyProcessedEntry = null;
        }

        private void prepareProgressReporter() {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutor.scheduleAtFixedRate(() -> {
                if (this.initialReport) {
                    this.initialReport = false;
                    LogUtils.warning((String)"Resource scanning is taking a long time. This can be caused by class-path or module-path entries that point to large directory structures. Please make sure class-/module-path entries are easily accessible to native-image");
                }
                System.out.println("Total scanned entries: " + this.reachedResourceEntries + ", current entry: " + (this.currentlyProcessedEntry != null ? this.currentlyProcessedEntry : "Unknown resource"));
            }, 60L, 20L, TimeUnit.SECONDS);
        }

        private void shutDownProgressReporter() {
            if (!this.scheduledExecutor.isShutdown()) {
                this.scheduledExecutor.shutdown();
            }
        }

        @Override
        public boolean isIncluded(Module module, String resourceName, URI resource) {
            this.currentlyProcessedEntry = resource.getScheme().equals("jrt") ? resource + "/" + resourceName : resource.toString();
            this.reachedResourceEntries.increment();
            if (this.reachedResourceEntries.longValue() % 1000L == 0L) {
                this.heartbeatCallback.run();
            }
            String relativePathWithTrailingSlash = resourceName + "/";
            String moduleName = module == null ? null : module.getName();
            for (ResourcePattern rp : this.excludePatterns) {
                if (!rp.moduleNameMatches(moduleName) || !rp.pattern.matcher(resourceName).matches() && !rp.pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                return false;
            }
            for (ResourcePattern rp : this.includePatterns) {
                if (!rp.moduleNameMatches(moduleName) || !rp.pattern.matcher(resourceName).matches() && !rp.pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addResource(Module module, String resourceName, InputStream resourceStream, boolean fromJar) {
            ResourcesFeature.registerResource(this.debugContext, module, resourceName, resourceStream, fromJar);
        }

        @Override
        public void addDirectoryResource(Module module, String dir, String content, boolean fromJar) {
            ResourcesFeature.registerDirectoryResource(this.debugContext, module, dir, content, fromJar);
        }

        @Override
        public void registerIOException(Module module, String resourceName, IOException e, boolean linkAtBuildTime) {
            Resources.singleton().registerIOException(module, resourceName, e, linkAtBuildTime);
        }

        @Override
        public void registerNegativeQuery(Module module, String resourceName) {
            Resources.singleton().registerNegativeQuery(module, resourceName);
        }
    }
}

