/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.classinitialization.AllowAllHostedUsagesClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationConfiguration;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.ProvenSafeClassInitializationSupport;
import java.lang.reflect.Proxy;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking;

public abstract class ClassInitializationSupport
implements RuntimeClassInitializationSupport {
    final ClassInitializationConfiguration classInitializationConfiguration = new ClassInitializationConfiguration();
    final ConcurrentMap<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    boolean configurationSealed;
    final ImageClassLoader loader;
    final MetaAccessProvider metaAccess;

    public static ClassInitializationSupport create(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        if (!ClassInitializationOptions.StrictImageHeap.getValue().booleanValue()) {
            return new ProvenSafeClassInitializationSupport(metaAccess, loader);
        }
        return new AllowAllHostedUsagesClassInitializationSupport(metaAccess, loader);
    }

    public static ClassInitializationSupport singleton() {
        return (ClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
    }

    ClassInitializationSupport(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        this.metaAccess = metaAccess;
        this.loader = loader;
    }

    public void setConfigurationSealed(boolean sealed) {
        this.configurationSealed = sealed;
        if (this.configurationSealed && ClassInitializationOptions.PrintClassInitialization.getValue().booleanValue()) {
            List<ClassOrPackageConfig> allConfigs = this.classInitializationConfiguration.allConfigs();
            allConfigs.sort(Comparator.comparing(ClassOrPackageConfig::getName));
            ReportUtils.report((String)"class initialization configuration", (String)SubstrateOptions.reportsPath(), (String)"class_initialization_configuration", (String)"csv", writer -> {
                writer.println("Class or Package Name, Initialization Kind, Reasons");
                for (ClassOrPackageConfig config : allConfigs) {
                    writer.append(config.getName()).append(", ").append(config.getKind().toString()).append(", ").append(String.join((CharSequence)" and ", config.getReasons())).append(System.lineSeparator());
                }
            });
        }
    }

    InitKind specifiedInitKindFor(Class<?> clazz) {
        return (InitKind)((Object)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getLeft());
    }

    Boolean isStrictlyDefined(Class<?> clazz) {
        return (Boolean)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getRight();
    }

    Set<Class<?>> classesWithKind(InitKind kind) {
        return this.classInitKinds.entrySet().stream().filter(e -> e.getValue() == kind).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean maybeInitializeAtBuildTime(ResolvedJavaType type) {
        return this.maybeInitializeAtBuildTime(OriginalClassProvider.getJavaClass((ResolvedJavaType)type));
    }

    public boolean maybeInitializeAtBuildTime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) == InitKind.BUILD_TIME;
    }

    InitKind ensureClassInitialized(Class<?> clazz, boolean allowErrors) {
        try {
            this.loader.watchdog.recordActivity();
            Unsafe.getUnsafe().ensureClassInitialized(clazz);
            this.loader.watchdog.recordActivity();
            return InitKind.BUILD_TIME;
        }
        catch (NoClassDefFoundError ex) {
            if (allowErrors || !LinkAtBuildTimeSupport.singleton().linkAtBuildTime(clazz)) {
                return InitKind.RUN_TIME;
            }
            String msg = "Class initialization of " + clazz.getTypeName() + " failed. " + LinkAtBuildTimeSupport.singleton().errorMessageFor(clazz) + " " + ClassInitializationSupport.instructionsToInitializeAtRuntime(clazz);
            throw UserError.abort(ex, "%s", msg);
        }
        catch (Throwable t) {
            if (allowErrors) {
                return InitKind.RUN_TIME;
            }
            String msg = "Class initialization of " + clazz.getTypeName() + " failed. " + ClassInitializationSupport.instructionsToInitializeAtRuntime(clazz);
            if (t instanceof ExceptionInInitializerError) {
                Throwable cause = t;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                msg = msg + " Exception thrown by the class initializer:" + System.lineSeparator() + System.lineSeparator() + cause + System.lineSeparator();
                for (StackTraceElement element : cause.getStackTrace()) {
                    if (this.getClass().getName().equals(element.getClassName())) {
                        msg = msg + "\t(internal stack frames of the image generator are omitted)" + System.lineSeparator();
                        break;
                    }
                    msg = msg + "\tat " + element + System.lineSeparator();
                }
                msg = msg + System.lineSeparator();
            }
            throw UserError.abort(t, "%s", msg);
        }
    }

    private static String instructionsToInitializeAtRuntime(Class<?> clazz) {
        return "Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, clazz.getTypeName(), "initialize-at-run-time", true, true) + " to explicitly request initialization of this class at run time.";
    }

    public void initializeAtRunTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, true);
            this.initializeAtRunTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, false);
        }
    }

    public void initializeAtBuildTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, true);
            this.initializeAtBuildTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, false);
        }
    }

    public void rerunInitialization(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, true);
            this.rerunInitialization(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, false);
        }
    }

    static boolean isClassListedInStringOption(LocatableMultiOptionValue.Strings option, Class<?> clazz) {
        return option.values().contains(clazz.getName());
    }

    private static boolean isObjectInstantiationForClassTracked(Class<?> clazz) {
        return SubstrateOptions.TraceObjectInstantiation.hasBeenSet() && ClassInitializationSupport.isClassListedInStringOption(SubstrateOptions.TraceObjectInstantiation.getValue(), clazz);
    }

    public String objectInstantiationTraceMessage(Object obj, String prefix, Function<String, String> action) {
        Map instantiatedObjects = ClassInitializationTracking.instantiatedObjects;
        if (ClassInitializationSupport.isProxyOrLambda(obj)) {
            return prefix + "If these objects should not be stored in the image heap, please try to infer from the source code how the culprit object got instantiated." + System.lineSeparator();
        }
        if (!ClassInitializationSupport.isObjectInstantiationForClassTracked(obj.getClass())) {
            return prefix + "If these objects should not be stored in the image heap, you can use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceObjectInstantiation, obj.getClass().getName(), true, true) + "to find classes that instantiate these objects. Once you found such a class, you can mark it explicitly for run time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, "<culprit>", "initialize-at-run-time", true, true) + "to prevent the instantiation of the object." + System.lineSeparator();
        }
        if (instantiatedObjects.containsKey(obj)) {
            StackTraceElement[] trace;
            String culprit = null;
            for (StackTraceElement stackTraceElement : trace = (StackTraceElement[])instantiatedObjects.get(obj)) {
                if (!stackTraceElement.getMethodName().equals("<clinit>")) continue;
                culprit = stackTraceElement.getClassName();
            }
            if (culprit != null) {
                return prefix + action.apply(culprit) + System.lineSeparator() + "The culprit object has been instantiated by the '" + culprit + "' class initializer with the following trace:" + System.lineSeparator() + ClassInitializationSupport.getTraceString((StackTraceElement[])instantiatedObjects.get(obj));
            }
            return prefix + action.apply(culprit) + System.lineSeparator() + "The culprit object has been instantiated with the following trace:" + System.lineSeparator() + ClassInitializationSupport.getTraceString((StackTraceElement[])instantiatedObjects.get(obj)) + action;
        }
        return prefix + "Object has been initialized in a core JDK class that is not instrumented for class initialization tracking. Therefore, a stack trace cannot be provided." + System.lineSeparator() + "Please try to infer from the source code how the culprit object got instantiated." + System.lineSeparator();
    }

    static boolean isProxyOrLambda(Object obj) {
        return obj.getClass().getName().contains(LambdaUtils.LAMBDA_CLASS_NAME_SUBSTRING) || Proxy.isProxyClass(obj.getClass());
    }

    static String getTraceString(StackTraceElement[] trace) {
        StringBuilder b = new StringBuilder();
        for (StackTraceElement stackTraceElement : trace) {
            b.append("\tat ").append(stackTraceElement.toString()).append("\n");
        }
        return b.toString();
    }

    public abstract void forceInitializeHosted(Class<?> var1, String var2, boolean var3);

    abstract InitKind computeInitKindAndMaybeInitializeClass(Class<?> var1);

    abstract String reasonForClass(Class<?> var1);

    abstract boolean checkDelayedInitialization();

    abstract void doLateInitialization(AnalysisUniverse var1, AnalysisMetaAccess var2);

    public static EconomicSet<Class<?>> allInterfaces(Class<?> clazz) {
        EconomicSet result = EconomicSet.create();
        ClassInitializationSupport.addAllInterfaces(clazz, result);
        return result;
    }

    private static void addAllInterfaces(Class<?> clazz, EconomicSet<Class<?>> result) {
        for (Class<?> interf : clazz.getInterfaces()) {
            if (!result.add(interf)) continue;
            ClassInitializationSupport.addAllInterfaces(interf, result);
        }
    }
}

