/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class BuildPhaseProvider {
    private boolean analysisFinished;
    private boolean hostedUniverseBuilt;
    private boolean readyForCompilation;
    private boolean compilationFinished;
    private boolean heapLayoutFinished;

    public static void init() {
        ImageSingletons.add(BuildPhaseProvider.class, (Object)new BuildPhaseProvider());
    }

    static BuildPhaseProvider singleton() {
        return (BuildPhaseProvider)ImageSingletons.lookup(BuildPhaseProvider.class);
    }

    BuildPhaseProvider() {
    }

    public static void markAnalysisFinished() {
        BuildPhaseProvider.singleton().analysisFinished = true;
    }

    public static boolean isAnalysisFinished() {
        return BuildPhaseProvider.singleton().analysisFinished;
    }

    public static void markHostedUniverseBuilt() {
        BuildPhaseProvider.singleton().hostedUniverseBuilt = true;
    }

    public static boolean isHostedUniverseBuilt() {
        return BuildPhaseProvider.singleton().hostedUniverseBuilt;
    }

    public static void markReadyForCompilation() {
        BuildPhaseProvider.singleton().readyForCompilation = true;
    }

    public static boolean isReadyForCompilation() {
        return BuildPhaseProvider.singleton().readyForCompilation;
    }

    public static void markCompilationFinished() {
        BuildPhaseProvider.singleton().compilationFinished = true;
    }

    public static boolean isCompilationFinished() {
        return BuildPhaseProvider.singleton().compilationFinished;
    }

    public static void markHeapLayoutFinished() {
        BuildPhaseProvider.singleton().heapLayoutFinished = true;
    }

    public static boolean isHeapLayoutFinished() {
        return BuildPhaseProvider.singleton().heapLayoutFinished;
    }

    public static class AfterHeapLayout
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isHeapLayoutFinished();
        }
    }

    public static class AfterCompilation
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isCompilationFinished();
        }
    }

    public static class ReadyForCompilation
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isReadyForCompilation();
        }
    }

    public static class AfterHostedUniverse
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isHostedUniverseBuilt();
        }
    }

    public static class AfterAnalysis
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isAnalysisFinished();
        }
    }
}

