/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.c.libc.MuslLibC;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.APIOptionGroup;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import jdk.internal.misc.Unsafe;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateOptions {
    public static final HostedOptionKey<Boolean> ParseOnce = new HostedOptionKey<Boolean>(true);
    public static final HostedOptionKey<Boolean> ParseOnceJIT = new HostedOptionKey<Boolean>(true);
    public static final HostedOptionKey<Boolean> SourceLevelDebug = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> SourceLevelDebugFilter = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    public static final HostedOptionKey<String> ImageBuildID = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Module = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Class = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Method = new HostedOptionKey<String>("main");
    @APIOption(name={"-o"}, valueSeparator={32})
    public static final HostedOptionKey<String> Name = new HostedOptionKey<String>("");
    @APIOption(name={"shared"})
    public static final HostedOptionKey<Boolean> SharedLibrary = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"static"})
    public static final HostedOptionKey<Boolean> StaticExecutable = new HostedOptionKey<Boolean>(false, key -> {
        if (!LibCBase.targetLibCIs(MuslLibC.class)) {
            throw UserError.abort("Building static executable images is only supported with musl libc. Remove the '--static' option or add the '--libc=musl' option.", new Object[0]);
        }
    });
    @APIOption(name={"libc"})
    public static final HostedOptionKey<String> UseLibC = new HostedOptionKey<String>(null){

        public String getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
            if (!values.containsKey((Object)this)) {
                return Platform.includedIn(Platform.ANDROID.class) ? "bionic" : System.getProperty("substratevm.HostLibC", "glibc");
            }
            return (String)values.get((Object)this);
        }

        public String getValue(OptionValues values) {
            assert (this.checkDescriptorExists());
            return this.getValueOrDefault(values.getMap());
        }
    };
    @APIOption(name={"target"})
    public static final HostedOptionKey<String> TargetPlatform = new HostedOptionKey<String>(""){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
            String updatedNewValue = newValue.equals("macos") ? "darwin" : newValue;
            super.onValueUpdate(values, (Object)oldValue, (Object)updatedNewValue);
        }
    };
    public static final HostedOptionKey<Boolean> StaticExecutableWithDynamicLibC = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> StaticLibStdCpp = new HostedOptionKey<Boolean>(false);
    public static final int ForceFallback = 10;
    public static final int Automatic = 5;
    public static final int NoFallback = 0;
    public static final String OptionNameForceFallback = "force-fallback";
    public static final String OptionNameAutoFallback = "auto-fallback";
    public static final String OptionNameNoFallback = "no-fallback";
    @APIOption.List(value={@APIOption(name={"force-fallback"}, fixedValue={"10"}, customHelp="force building of fallback image"), @APIOption(name={"auto-fallback"}, fixedValue={"5"}, customHelp="build stand-alone image if possible"), @APIOption(name={"no-fallback"}, fixedValue={"0"}, customHelp="build stand-alone image or report failure")})
    public static final HostedOptionKey<Integer> FallbackThreshold = new HostedOptionKey<Integer>(5);
    public static final String IMAGE_CLASSPATH_PREFIX = "-imagecp";
    public static final String IMAGE_MODULEPATH_PREFIX = "-imagemp";
    public static final String KEEP_ALIVE_PREFIX = "-keepalive";
    private static ValueUpdateHandler<OptimizationLevel> optimizeValueUpdateHandler;
    @APIOption(name={"-O"}, valueSeparator={0})
    public static final HostedOptionKey<String> Optimize;
    public static final HostedOptionKey<Boolean> IncludeNodeSourcePositions;
    @BundleMember(role=BundleMember.Role.Input)
    public static final HostedOptionKey<LocatableMultiOptionValue.Paths> CLibraryPath;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LinkerRPath;
    public static final HostedOptionKey<String> Path;
    @APIOption(name={"serial"}, group=GCGroup.class, customHelp="Serial garbage collector")
    public static final HostedOptionKey<Boolean> UseSerialGC;
    @APIOption(name={"epsilon"}, group=GCGroup.class, customHelp="Epsilon garbage collector")
    public static final HostedOptionKey<Boolean> UseEpsilonGC;
    public static final RuntimeOptionKey<Long> MaxRAM;
    public static final RuntimeOptionKey<Long> StackSize;
    public static final HostedOptionKey<Long> InternalThreadStackSize;
    private static int maxJavaStackTraceDepth;
    public static final RuntimeOptionKey<Long> MaxDirectMemorySize;
    public static final HostedOptionKey<Boolean> VerifyNamingConventions;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DisableSubstitution;
    public static final HostedOptionKey<Boolean> MultiThreaded;
    public static final HostedOptionKey<Boolean> ForceNoROSectionRelocations;
    public static final HostedOptionKey<Boolean> NoDirectRelocationsInText;
    public static final HostedOptionKey<Boolean> SpawnIsolates;
    public static final HostedOptionKey<Boolean> CheckIsolateThreadAtEntry;
    public static final HostedOptionKey<Boolean> TraceVMOperations;
    @APIOption(name={"trace-class-initialization"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> TraceClassInitialization;
    @APIOption(name={"trace-object-instantiation"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> TraceObjectInstantiation;
    public static final HostedOptionKey<Boolean> TraceNativeToolUsage;
    public static final HostedOptionKey<String> EntryPointNamePrefix;
    public static final HostedOptionKey<String> APIFunctionPrefix;
    @APIOption.List(value={@APIOption(name={"enable-http"}, fixedValue={"http"}, customHelp="enable http support in the generated image"), @APIOption(name={"enable-https"}, fixedValue={"https"}, customHelp="enable https support in the generated image"), @APIOption(name={"enable-url-protocols"})})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> EnableURLProtocols;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DisableURLProtocols;
    @APIOption(name={"enable-all-security-services"})
    public static final HostedOptionKey<Boolean> EnableAllSecurityServices;
    public static final HostedOptionKey<Boolean> JNI;
    public static final HostedOptionKey<Boolean> JNIVerboseLookupErrors;
    public static final HostedOptionKey<Boolean> JNIExportSymbols;
    public static final HostedOptionKey<Boolean> JNIEnhancedErrorCodes;
    public static final HostedOptionKey<Integer> CodeAlignment;
    public static final String BUILD_ARTIFACTS_FILE_NAME = "build-artifacts.json";
    public static final HostedOptionKey<Boolean> GenerateBuildArtifactsFile;
    @APIOption(name={"color"})
    public static final HostedOptionKey<String> Color;
    @APIOption(name={"silent"})
    public static final HostedOptionKey<Boolean> BuildOutputSilent;
    public static final HostedOptionKey<Boolean> BuildOutputPrefix;
    public static final HostedOptionKey<Boolean> BuildOutputColorful;
    public static final HostedOptionKey<Boolean> BuildOutputLinks;
    public static final HostedOptionKey<Boolean> BuildOutputProgress;
    public static final HostedOptionKey<Boolean> BuildOutputBreakdowns;
    public static final HostedOptionKey<Boolean> BuildOutputRecommendations;
    public static final HostedOptionKey<Boolean> BuildOutputGCWarnings;
    @BundleMember(role=BundleMember.Role.Output)
    public static final HostedOptionKey<LocatableMultiOptionValue.Paths> BuildOutputJSONFile;
    public static final HostedOptionKey<Integer> AllocatePrefetchLines;
    public static final HostedOptionKey<Integer> AllocateInstancePrefetchLines;
    public static final HostedOptionKey<Integer> AllocatePrefetchStyle;
    public static final HostedOptionKey<Integer> AllocatePrefetchInstr;
    public static final HostedOptionKey<Integer> AllocatePrefetchDistance;
    public static final HostedOptionKey<Integer> AllocatePrefetchStepSize;
    public static final HostedOptionKey<Integer> ContendedPaddingWidth;
    public static final HostedOptionKey<Integer> AdditionalHeaderBytes;
    public static final RuntimeOptionKey<Long> TearDownWarningNanos;
    public static final RuntimeOptionKey<Long> TearDownFailureNanos;
    public static final HostedOptionKey<Integer> MaxUnrolledObjectZeroingStores;
    static final HostedOptionKey<Boolean> StackTrace;
    public static final HostedOptionKey<Boolean> ParseRuntimeOptions;
    public static final HostedOptionKey<Boolean> EnableWildcardExpansion;
    static final HostedOptionKey<Boolean> AOTInline;
    public static final HostedOptionKey<Boolean> AOTTrivialInline;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> NeverInline;
    public static final HostedOptionKey<Integer> MaxNodesInTrivialMethod;
    public static final HostedOptionKey<Integer> MaxInvokesInTrivialMethod;
    public static final HostedOptionKey<Integer> MaxNodesInTrivialLeafMethod;
    public static final HostedOptionKey<Integer> MaxNodesAfterTrivialInlining;
    public static final HostedOptionKey<Boolean> PreserveFramePointer;
    public static final HostedOptionKey<Boolean> UseCalleeSavedRegisters;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ReportAnalysisForbiddenType;
    public static final HostedOptionKey<String> CompilerBackend;
    public static final HostedOptionKey<Boolean> RemoveUnusedSymbols;
    public static final HostedOptionKey<Boolean> DeleteLocalSymbols;
    public static final HostedOptionKey<Boolean> InternalSymbolsAreGlobal;
    public static final HostedOptionKey<String> ImageSymbolsPrefix;
    public static final HostedOptionKey<Boolean> FoldSecurityManagerGetter;
    @APIOption(name={"native-compiler-path"})
    public static final HostedOptionKey<String> CCompilerPath;
    @APIOption(name={"native-compiler-options"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> CCompilerOption;
    public static final HostedOptionKey<Boolean> StrictQueryCodeCompilation;
    @APIOption(name={"native-image-info"})
    public static final HostedOptionKey<Boolean> DumpTargetInfo;
    public static final HostedOptionKey<Boolean> CheckToolchain;
    @APIOption(name={"install-exit-handlers"})
    public static final HostedOptionKey<Boolean> InstallExitHandlers;
    public static final HostedOptionKey<Boolean> DetectUserDirectoriesInImageHeap;
    public static final HostedOptionKey<Boolean> UseNullRegion;
    public static final HostedOptionKey<Integer> DeadlockWatchdogInterval;
    public static final HostedOptionKey<Boolean> DeadlockWatchdogExitOnTimeout;
    public static final HostedOptionKey<Boolean> AllowVMInternalThreads;
    public static final HostedOptionKey<Boolean> IncludeDebugHelperMethods;
    @APIOption(name={"-g"}, fixedValue={"2"}, customHelp="generate debugging information")
    public static final HostedOptionKey<Integer> GenerateDebugInfo;
    static final HostedOptionKey<String> DebugInfoSourceCacheRoot;
    public static final HostedOptionKey<Integer> CheckBootModuleDependencies;
    public static final HostedOptionKey<Boolean> StripDebugInfo;
    public static final HostedOptionKey<Boolean> OmitInlinedMethodDebugLineInfo;
    public static final HostedOptionKey<Integer> DebugCodeInfoMaxDepth;
    public static final HostedOptionKey<Boolean> DebugCodeInfoUseSourceMappings;
    public static final HostedOptionKey<Boolean> UseImagebuildDebugSections;
    public static final RuntimeOptionKey<String> CompilationIsolateOptions;
    public static final RuntimeOptionKey<Long> CompilationIsolateAddressSpaceSize;
    public static final RuntimeOptionKey<Integer> ActiveProcessorCount;
    public static final HostedOptionKey<Boolean> DisableTypeIdResultVerification;
    public static final RuntimeOptionKey<Boolean> EnableSignalHandling;
    public static final RuntimeOptionKey<Boolean> HeapDumpOnOutOfMemoryError;
    public static final RuntimeOptionKey<String> HeapDumpPath;
    public static final HostedOptionKey<String> HeapDumpDefaultFilenamePrefix;
    public static final RuntimeOptionKey<Boolean> DumpHeapAndExit;
    public static final RuntimeOptionKey<Boolean> FlightRecorder;
    public static final RuntimeOptionKey<String> StartFlightRecording;
    public static final RuntimeOptionKey<String> FlightRecorderLogging;
    protected static final HostedOptionKey<Integer> PageSize;
    public static final RuntimeOptionKey<String> DiagnosticDetails;
    public static final HostedOptionKey<Boolean> AsyncSignalSafeDiagnostics;
    public static final HostedOptionKey<Integer> DiagnosticBufferSize;
    @APIOption(name={"configure-reflection-metadata"})
    public static final HostedOptionKey<Boolean> ConfigureReflectionMetadata;
    public static final HostedOptionKey<Boolean> IncludeMethodData;
    public static final HostedOptionKey<Boolean> VerifyTypes;
    public static final HostedOptionKey<Boolean> RunReachabilityHandlersConcurrently;
    public static final HostedOptionKey<Boolean> UseDirectCallTrampolinesALot;
    public static final HostedOptionKey<Boolean> RunMainInNewThread;
    public static final HostedOptionKey<Boolean> AllowDeprecatedBuilderClassesOnImageClasspath;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ThrowMissingRegistrationErrors;
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ThrowMissingRegistrationErrorsPaths;
    public static final HostedOptionKey<ReportingMode> MissingRegistrationReportingMode;
    public static final HostedOptionKey<Boolean> ThrowLinkAtBuildTimeIOExceptions;
    public static final HostedOptionKey<Boolean> PinnedObjectAddressing;
    public static final HostedOptionKey<Boolean> UnlockExperimentalVMOptions;
    public static final HostedOptionKey<Boolean> UseOldMethodHandleIntrinsics;
    public static final HostedOptionKey<Boolean> MremapImageHeap;

    public static boolean parseOnce() {
        return ParseOnce.getValue() != false && (ParseOnceJIT.getValue() != false || !DeoptimizationSupport.enabled());
    }

    @Fold
    public static boolean getSourceLevelDebug() {
        return SourceLevelDebug.getValue();
    }

    @Fold
    public static Predicate<String> getSourceLevelDebugFilter() {
        return SubstrateOptions.makeFilter(SourceLevelDebugFilter.getValue().values());
    }

    @Fold
    public static UUID getImageBuildID() {
        return UUID.fromString(ImageBuildID.getValue());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Predicate<String> makeFilter(List<String> definedFilters) {
        if (definedFilters.isEmpty()) {
            return javaName -> true;
        }
        return javaName -> {
            for (String wildCard : definedFilters) {
                if (!javaName.startsWith(wildCard)) continue;
                return true;
            }
            return false;
        };
    }

    private static OptimizationLevel parseOptimizationLevel(String value) {
        int intLevel;
        if (value.equals("b")) {
            return OptimizationLevel.BUILD_TIME;
        }
        try {
            intLevel = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            intLevel = -1;
        }
        if (intLevel == 0) {
            return OptimizationLevel.O0;
        }
        if (intLevel == 1) {
            return OptimizationLevel.O1;
        }
        if (intLevel == 2) {
            return OptimizationLevel.O2;
        }
        if (intLevel > 2) {
            return OptimizationLevel.O3;
        }
        throw UserError.abort("Invalid value '%s' provided for option Optimize (expected 'b' or numeric value >= 0)", value);
    }

    @Fold
    public static OptimizationLevel optimizationLevel() {
        return SubstrateOptions.parseOptimizationLevel(Optimize.getValue());
    }

    public static boolean useEconomyCompilerConfig(OptionValues options) {
        return "b".equals(Optimize.getValue(options));
    }

    @Fold
    public static boolean useEconomyCompilerConfig() {
        return SubstrateOptions.useEconomyCompilerConfig(HostedOptionValues.singleton());
    }

    @Fold
    public static boolean isMaximumOptimizationLevel() {
        return SubstrateOptions.optimizationLevel() == OptimizationLevel.O3;
    }

    public static void setOptimizeValueUpdateHandler(ValueUpdateHandler<OptimizationLevel> updateHandler) {
        optimizeValueUpdateHandler = updateHandler;
    }

    public static int maxJavaStackTraceDepth() {
        return maxJavaStackTraceDepth;
    }

    public static void updateMaxJavaStackTraceDepth(EconomicMap<OptionKey<?>, Object> runtimeValues, int newValue) {
        ConcealedOptions.MaxJavaStackTraceDepth.update(runtimeValues, newValue);
    }

    public static final boolean hasColorsEnabled(OptionValues values) {
        if (Color.hasBeenSet(values)) {
            String value;
            return switch (value = (String)Color.getValue(values)) {
                case "always" -> true;
                case "auto" -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"'auto' value should have been resolved in the driver");
                    }
                    yield false;
                }
                case "never" -> false;
                default -> throw UserError.abort("Unsupported value '%s' for '--color' option. Only 'always', 'never', and 'auto' are accepted.", value);
            };
        }
        return false;
    }

    private static void validateAdditionalHeaderBytes(HostedOptionKey<Integer> optionKey) {
        int value = optionKey.getValue();
        if (value < 0 || value % 4 != 0) {
            throw UserError.abort("The option '%s' must be 0 or a multiple of 4.", optionKey.getName());
        }
    }

    public static long getTearDownWarningNanos() {
        return TearDownWarningNanos.getValue();
    }

    public static long getTearDownFailureNanos() {
        return TearDownFailureNanos.getValue();
    }

    @Fold
    public static boolean useLLVMBackend() {
        return "llvm".equals(CompilerBackend.getValue());
    }

    @Fold
    public static boolean useLIRBackend() {
        return "lir".equals(CompilerBackend.getValue());
    }

    @Fold
    public static int codeAlignment() {
        return CodeAlignment.getValue();
    }

    private static void validateGenerateDebugInfo(HostedOptionKey<Integer> optionKey) {
        if (OS.getCurrent() == OS.DARWIN && optionKey.hasBeenSet() && optionKey.getValue() > 0) {
            LogUtils.warning((String)"Using %s is not supported on macOS", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(optionKey, optionKey.getValue().toString())});
        }
    }

    public static boolean useDebugInfoGeneration() {
        return SubstrateOptions.useLIRBackend() && GenerateDebugInfo.getValue() > 0;
    }

    public static Path getDebugInfoSourceCacheRoot() {
        try {
            return Paths.get(Path.getValue(), new String[0]).resolve(DebugInfoSourceCacheRoot.getValue());
        }
        catch (InvalidPathException ipe) {
            throw UserError.abort("Invalid path provided for option DebugInfoSourceCacheRoot %s", DebugInfoSourceCacheRoot.getValue());
        }
    }

    private static void validateStripDebugInfo(HostedOptionKey<Boolean> optionKey) {
        if (OS.getCurrent() == OS.DARWIN && optionKey.hasBeenSet() && optionKey.getValue().booleanValue()) {
            throw UserError.abort("Using %s is not supported on macOS", SubstrateOptionsParser.commandArgument(StripDebugInfo, "+"));
        }
        if (OS.getCurrent() == OS.WINDOWS && optionKey.hasBeenSet() && !optionKey.getValue().booleanValue()) {
            throw UserError.abort("Using %s is not supported on Windows: debug info is always generated in a separate file", SubstrateOptionsParser.commandArgument(optionKey, "-"));
        }
    }

    @Fold
    public static boolean supportCompileInIsolates() {
        UserError.guarantee(ConcealedOptions.SupportCompileInIsolates.getValue() == false || SpawnIsolates.getValue() != false, "Option %s must be enabled to support isolated compilations through option %s", SpawnIsolates.getName(), ConcealedOptions.SupportCompileInIsolates.getName());
        return ConcealedOptions.SupportCompileInIsolates.getValue();
    }

    public static boolean shouldCompileInIsolates() {
        return SubstrateOptions.supportCompileInIsolates() && ConcealedOptions.CompileInIsolates.getValue() != false;
    }

    @Fold
    public static boolean useRememberedSet() {
        return UseEpsilonGC.getValue() == false && ConcealedOptions.UseRememberedSet.getValue() != false;
    }

    public static String reportsPath() {
        Path reportsPath = ((ReportingSupport)ImageSingletons.lookup(ReportingSupport.class)).reportsPath;
        if (reportsPath.isAbsolute()) {
            return reportsPath.toString();
        }
        return Paths.get(Path.getValue(), new String[0]).resolve(reportsPath).toString();
    }

    @Fold
    public static int getPageSize() {
        int value = PageSize.getValue();
        if (value == 0) {
            return Unsafe.getUnsafe().pageSize();
        }
        assert (value > 0);
        return value;
    }

    static {
        Optimize = new HostedOptionKey<String>("2"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                OptimizationLevel newLevel = SubstrateOptions.parseOptimizationLevel(newValue);
                GraalOptions.TrackNodeSourcePosition.update(values, (Object)(newLevel == OptimizationLevel.O0 ? 1 : 0));
                IncludeNodeSourcePositions.update(values, newLevel == OptimizationLevel.O0);
                SourceLevelDebug.update(values, newLevel == OptimizationLevel.O0);
                AOTTrivialInline.update(values, newLevel != OptimizationLevel.O0);
                if (optimizeValueUpdateHandler != null) {
                    optimizeValueUpdateHandler.onValueUpdate(values, newLevel);
                }
            }
        };
        IncludeNodeSourcePositions = new HostedOptionKey<Boolean>(false);
        CLibraryPath = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        LinkerRPath = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        Path = new HostedOptionKey<Object>(null);
        UseSerialGC = new HostedOptionKey<Boolean>(Boolean.valueOf(true)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    UseEpsilonGC.update(values, false);
                }
            }
        };
        UseEpsilonGC = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    UseSerialGC.update(values, false);
                }
            }
        };
        MaxRAM = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        StackSize = new RuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        InternalThreadStackSize = new HostedOptionKey<Long>(0x200000L);
        maxJavaStackTraceDepth = 1024;
        MaxDirectMemorySize = new RuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        VerifyNamingConventions = new HostedOptionKey<Boolean>(false);
        DisableSubstitution = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        MultiThreaded = new HostedOptionKey<Boolean>(true);
        ForceNoROSectionRelocations = new HostedOptionKey<Boolean>(false);
        NoDirectRelocationsInText = new HostedOptionKey<Boolean>(true);
        SpawnIsolates = new HostedOptionKey<Boolean>(true);
        CheckIsolateThreadAtEntry = new HostedOptionKey<Boolean>(false);
        TraceVMOperations = new HostedOptionKey<Boolean>(false);
        TraceClassInitialization = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        TraceObjectInstantiation = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        TraceNativeToolUsage = new HostedOptionKey<Boolean>(false);
        EntryPointNamePrefix = new HostedOptionKey<String>("");
        APIFunctionPrefix = new HostedOptionKey<String>("graal_");
        EnableURLProtocols = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        DisableURLProtocols = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        EnableAllSecurityServices = new HostedOptionKey<Boolean>(false);
        JNI = new HostedOptionKey<Boolean>(true);
        JNIVerboseLookupErrors = new HostedOptionKey<Boolean>(false);
        JNIExportSymbols = new HostedOptionKey<Boolean>(true);
        JNIEnhancedErrorCodes = new HostedOptionKey<Boolean>(false);
        CodeAlignment = new HostedOptionKey<Integer>(16);
        GenerateBuildArtifactsFile = new HostedOptionKey<Boolean>(false);
        Color = new HostedOptionKey<String>("auto");
        BuildOutputSilent = new HostedOptionKey<Boolean>(false);
        BuildOutputPrefix = new HostedOptionKey<Boolean>(false);
        BuildOutputColorful = new HostedOptionKey<Boolean>(false);
        BuildOutputLinks = new HostedOptionKey<Boolean>(false);
        BuildOutputProgress = new HostedOptionKey<Boolean>(false);
        BuildOutputBreakdowns = new HostedOptionKey<Boolean>(true);
        BuildOutputRecommendations = new HostedOptionKey<Boolean>(true);
        BuildOutputGCWarnings = new HostedOptionKey<Boolean>(true);
        BuildOutputJSONFile = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.build());
        AllocatePrefetchLines = new HostedOptionKey<Integer>(4);
        AllocateInstancePrefetchLines = new HostedOptionKey<Integer>(1);
        AllocatePrefetchStyle = new HostedOptionKey<Integer>(1);
        AllocatePrefetchInstr = new HostedOptionKey<Integer>(0);
        AllocatePrefetchDistance = new HostedOptionKey<Integer>(192);
        AllocatePrefetchStepSize = new HostedOptionKey<Integer>(64);
        ContendedPaddingWidth = new HostedOptionKey<Integer>(128);
        AdditionalHeaderBytes = new HostedOptionKey<Integer>(0, SubstrateOptions::validateAdditionalHeaderBytes);
        TearDownWarningNanos = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        TearDownFailureNanos = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        MaxUnrolledObjectZeroingStores = new HostedOptionKey<Integer>(8);
        StackTrace = new HostedOptionKey<Boolean>(true);
        ParseRuntimeOptions = new HostedOptionKey<Boolean>(true);
        EnableWildcardExpansion = new HostedOptionKey<Boolean>(true);
        AOTInline = new HostedOptionKey<Boolean>(true);
        AOTTrivialInline = new HostedOptionKey<Boolean>(true);
        NeverInline = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        MaxNodesInTrivialMethod = new HostedOptionKey<Integer>(20);
        MaxInvokesInTrivialMethod = new HostedOptionKey<Integer>(1);
        MaxNodesInTrivialLeafMethod = new HostedOptionKey<Integer>(40);
        MaxNodesAfterTrivialInlining = new HostedOptionKey<Integer>(Integer.MAX_VALUE);
        PreserveFramePointer = new HostedOptionKey<Boolean>(false);
        UseCalleeSavedRegisters = new HostedOptionKey<Boolean>(true);
        ReportAnalysisForbiddenType = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        CompilerBackend = new HostedOptionKey<String>("lir"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                if ("llvm".equals(newValue)) {
                    boolean isLLVMBackendMissing;
                    if (ModuleSupport.modulePathBuild) {
                        isLLVMBackendMissing = ModuleLayer.boot().findModule("org.graalvm.nativeimage.llvm").isEmpty();
                    } else {
                        boolean bl = isLLVMBackendMissing = ReflectionUtil.lookupClass((boolean)true, (String)"com.oracle.svm.core.graal.llvm.LLVMFeature") == null;
                    }
                    if (isLLVMBackendMissing) {
                        throw UserError.abort("The LLVM backend for GraalVM Native Image is missing and needs to be build from source. For instructions, please see https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/LLVMBackend.md.", new Object[0]);
                    }
                    GraalOptions.EmitStringSubstitutions.update(values, (Object)false);
                    RemoveUnusedSymbols.update(values, false);
                    InternalSymbolsAreGlobal.update(values, true);
                    SpectrePHTMitigations.Options.SpectrePHTBarriers.update(values, (Object)SpectrePHTMitigations.None);
                }
            }
        };
        RemoveUnusedSymbols = new HostedOptionKey<Boolean>(OS.getCurrent() != OS.DARWIN);
        DeleteLocalSymbols = new HostedOptionKey<Boolean>(true);
        InternalSymbolsAreGlobal = new HostedOptionKey<Boolean>(false);
        ImageSymbolsPrefix = new HostedOptionKey<String>("");
        FoldSecurityManagerGetter = new HostedOptionKey<Boolean>(true);
        CCompilerPath = new HostedOptionKey<Object>(null);
        CCompilerOption = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        StrictQueryCodeCompilation = new HostedOptionKey<Boolean>(true);
        DumpTargetInfo = new HostedOptionKey<Boolean>(false);
        CheckToolchain = new HostedOptionKey<Boolean>(true);
        InstallExitHandlers = new HostedOptionKey<Boolean>(false);
        DetectUserDirectoriesInImageHeap = new HostedOptionKey<Boolean>(false);
        UseNullRegion = new HostedOptionKey<Boolean>(true);
        DeadlockWatchdogInterval = new HostedOptionKey<Integer>(10);
        DeadlockWatchdogExitOnTimeout = new HostedOptionKey<Boolean>(true);
        AllowVMInternalThreads = new HostedOptionKey<Boolean>(true);
        IncludeDebugHelperMethods = new HostedOptionKey<Boolean>(false);
        GenerateDebugInfo = new HostedOptionKey<Integer>(Integer.valueOf(0), SubstrateOptions::validateGenerateDebugInfo){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                if (OS.WINDOWS.isCurrent()) {
                    DeleteLocalSymbols.update(values, newValue == 0);
                }
            }
        };
        DebugInfoSourceCacheRoot = new HostedOptionKey<String>("sources");
        CheckBootModuleDependencies = new HostedOptionKey<Integer>(ModuleSupport.modulePathBuild ? 1 : 0);
        StripDebugInfo = new HostedOptionKey<Boolean>(OS.getCurrent() != OS.DARWIN, SubstrateOptions::validateStripDebugInfo);
        OmitInlinedMethodDebugLineInfo = new HostedOptionKey<Boolean>(false);
        DebugCodeInfoMaxDepth = new HostedOptionKey<Integer>(Integer.MAX_VALUE);
        DebugCodeInfoUseSourceMappings = new HostedOptionKey<Boolean>(false);
        UseImagebuildDebugSections = new HostedOptionKey<Boolean>(true);
        CompilationIsolateOptions = new RuntimeOptionKey<Object>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        CompilationIsolateAddressSpaceSize = new RuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        ActiveProcessorCount = new RuntimeOptionKey<Integer>(Integer.valueOf(-1), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable, RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        DisableTypeIdResultVerification = new HostedOptionKey<Boolean>(true);
        EnableSignalHandling = new RuntimeOptionKey<Boolean>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable}){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (values.containsKey((Object)this)) {
                    return (Boolean)values.get((Object)this);
                }
                return ImageInfo.isExecutable();
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        HeapDumpOnOutOfMemoryError = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        HeapDumpPath = new RuntimeOptionKey<String>("", RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        HeapDumpDefaultFilenamePrefix = new HostedOptionKey<String>("svm-heapdump-");
        DumpHeapAndExit = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        FlightRecorder = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        StartFlightRecording = new RuntimeOptionKey<String>("", RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        FlightRecorderLogging = new RuntimeOptionKey<String>("all=warning", RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        PageSize = new HostedOptionKey<Integer>(0);
        DiagnosticDetails = new RuntimeOptionKey<String>("", new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates}){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                SubstrateDiagnostics.updateInitialInvocationCounts(newValue);
            }
        };
        AsyncSignalSafeDiagnostics = new HostedOptionKey<Boolean>(false);
        DiagnosticBufferSize = new HostedOptionKey<Integer>(30);
        ConfigureReflectionMetadata = new HostedOptionKey<Boolean>(true);
        IncludeMethodData = new HostedOptionKey<Boolean>(true);
        VerifyTypes = new HostedOptionKey<Boolean>(false);
        RunReachabilityHandlersConcurrently = new HostedOptionKey<Boolean>(true);
        UseDirectCallTrampolinesALot = new HostedOptionKey<Boolean>(false);
        RunMainInNewThread = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this) && Platform.includedIn(Platform.LINUX.class) && LibCBase.targetLibCIs(MuslLibC.class)) {
                    return true;
                }
                return (Boolean)values.get((Object)this, this.getDefaultValue());
            }
        };
        AllowDeprecatedBuilderClassesOnImageClasspath = new HostedOptionKey<Boolean>(false);
        ThrowMissingRegistrationErrors = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        ThrowMissingRegistrationErrorsPaths = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        MissingRegistrationReportingMode = new HostedOptionKey<ReportingMode>(ReportingMode.Throw);
        ThrowLinkAtBuildTimeIOExceptions = new HostedOptionKey<Boolean>(false);
        PinnedObjectAddressing = new HostedOptionKey<Boolean>(true);
        UnlockExperimentalVMOptions = new HostedOptionKey<Boolean>(false);
        UseOldMethodHandleIntrinsics = new HostedOptionKey<Boolean>(false);
        MremapImageHeap = new HostedOptionKey<Boolean>(true, key -> {
            if (!Platform.includedIn(Platform.LINUX.class)) {
                throw UserError.invalidOptionValue(key, (Boolean)key.getValue(), "Mapping the image heap with mremap() is only supported on Linux.");
            }
        });
    }

    public static enum OptimizationLevel {
        O0("No optimizations", "0"),
        O1("Basic optimizations", "1"),
        O2("Advanced optimizations", "2"),
        O3("All optimizations for best performance", "3"),
        BUILD_TIME("Optimize for fastest build time", "b");

        private final String description;
        private final String optionSwitch;

        private OptimizationLevel(String description, String optionSwitch) {
            this.description = description;
            this.optionSwitch = optionSwitch;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOptionSwitch() {
            return this.optionSwitch;
        }

        public boolean isOneOf(OptimizationLevel ... levels) {
            if (levels != null) {
                for (OptimizationLevel level : levels) {
                    if (!level.equals((Object)this)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static interface ValueUpdateHandler<T> {
        public void onValueUpdate(EconomicMap<OptionKey<?>, Object> var1, T var2);
    }

    public static class ConcealedOptions {
        public static final HostedOptionKey<Boolean> SupportCompileInIsolates = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return (Boolean)SpawnIsolates.getValueOrDefault(values);
                }
                return (Boolean)super.getValueOrDefault(values);
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        public static final RuntimeOptionKey<Boolean> CompileInIsolates = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        public static final HostedOptionKey<Boolean> UseRememberedSet = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> UseDedicatedVMOperationThread = new HostedOptionKey<Boolean>(false);
        public static final RuntimeOptionKey<Boolean> AutomaticReferenceHandling = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        public static final RuntimeOptionKey<Boolean> UsePerfData = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        public static final RuntimeOptionKey<Integer> MaxJavaStackTraceDepth = new RuntimeOptionKey<Integer>(Integer.valueOf(maxJavaStackTraceDepth), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                maxJavaStackTraceDepth = newValue;
            }
        };
    }

    public static class ReportingSupport {
        Path reportsPath;

        public ReportingSupport(Path reportingPath) {
            this.reportsPath = reportingPath;
        }
    }

    public static enum ReportingMode {
        Warn,
        Throw,
        ExitTest,
        Exit;

    }

    public static final class GCGroup
    implements APIOptionGroup {
        @Override
        public String name() {
            return "gc";
        }

        @Override
        public String helpText() {
            return "Select native-image garbage collector implementation.";
        }
    }
}

