/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.Target_java_lang_NamedPackage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;

public final class ModuleUtil {
    private static final Object moduleLock = new Object();
    private static final Map<ClassLoader, Set<Module>> definedModules = new HashMap<ClassLoader, Set<Module>>();

    private ModuleUtil() {
    }

    public static Map<ClassLoader, Set<Module>> getDefinedModules() {
        if (definedModules.size() == 0) {
            for (Module module : ModuleLayer.boot().modules()) {
                Set<Module> modules = definedModules.get(module.getClassLoader());
                if (Objects.isNull(modules)) {
                    modules = new HashSet<Module>();
                    modules.add(module);
                    definedModules.put(module.getClassLoader(), modules);
                    continue;
                }
                modules.add(module);
            }
        }
        return definedModules;
    }

    public static void checkFromModuleAndPackageNullability(Module from, String pn) {
        if (Objects.isNull(from)) {
            throw new NullPointerException("The from_module is null");
        }
        if (Objects.isNull(pn)) {
            throw new NullPointerException("The package is null");
        }
    }

    public static boolean isPackageNameForbidden(String pn) {
        if (!pn.startsWith("java")) {
            return false;
        }
        int trailingChar = pn.length() < 5 ? 46 : (int)pn.charAt("java".length());
        return trailingChar == 46;
    }

    public static boolean isValidPackageName(String pn) {
        return Objects.nonNull(pn) && SourceVersion.isName(pn);
    }

    public static boolean isModuleDefinedToLoader(ClassLoader loader, String moduleName) {
        return ModuleUtil.getDefinedModules().getOrDefault(loader, Set.of()).stream().anyMatch(m -> m.getName().equals(moduleName));
    }

    public static void addDefinedModule(ClassLoader loader, Module module) {
        Set<Module> modules = ModuleUtil.getDefinedModules().get(loader);
        if (Objects.isNull(modules)) {
            modules = new HashSet<Module>();
            modules.add(module);
            ModuleUtil.getDefinedModules().put(loader, modules);
        } else {
            modules.add(module);
        }
    }

    public static void checkIsPackageContainedInModule(String pn, Module module) {
        ClassLoader loader = module.getClassLoader() == null ? ClassLoader.getPlatformClassLoader() : module.getClassLoader();
        Package definedPackage = loader.getDefinedPackage(pn);
        if (definedPackage != null) {
            Target_java_lang_NamedPackage namedPackage = SubstrateUtil.cast(definedPackage, Target_java_lang_NamedPackage.class);
            Module actualModule = namedPackage.module;
            if (!actualModule.equals(module)) {
                throw new IllegalArgumentException("Package " + pn + " found in module " + actualModule.getName() + ", not in module: " + module.getName());
            }
        }
        if (!module.getPackages().contains(pn)) {
            throw new IllegalArgumentException("Package " + pn + " not found in from_module " + module.getName());
        }
    }

    public static List<String> getPackagesDefinedToLoader(ClassLoader loader) {
        return ModuleUtil.getDefinedModules().getOrDefault(loader, Set.of()).stream().flatMap(m -> m.getPackages().stream()).collect(Collectors.toUnmodifiableList());
    }

    public static Object getModuleContainingPackage(ClassLoader loader, String pn) {
        return ModuleUtil.getDefinedModules().getOrDefault(loader, Set.of()).stream().filter(m -> m.getPackages().contains(pn)).findFirst().orElse(null);
    }

    public static boolean bootLayerContainsModule(String name) {
        return ModuleLayer.boot().modules().stream().anyMatch(m -> m.getName().equals(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defineModule(Module module, boolean isOpen, List<String> pns) {
        boolean moduleAlreadyDefined;
        if (Objects.isNull(module)) {
            throw new NullPointerException("Null module object");
        }
        if (Objects.isNull(module.getName())) {
            throw new IllegalArgumentException("Module name cannot be null");
        }
        if (module.getName().equals("java.base")) {
            if (isOpen) {
                throw new AssertionError((Object)"The java.base module cannot be open");
            }
            for (String pn : pns) {
                if (ModuleUtil.isValidPackageName(pn)) continue;
                throw new IllegalArgumentException("Invalid package name: " + pn + " for module: java.base");
            }
            if (module.getClassLoader() != null) {
                throw new IllegalArgumentException("Class loader must be the boot class loader");
            }
            Object object = moduleLock;
            synchronized (object) {
                boolean duplicateJavaBase = ModuleUtil.bootLayerContainsModule("java.base");
                if (duplicateJavaBase) {
                    throw new InternalError("Module java.base is already defined");
                }
            }
            return;
        }
        ClassLoader loader = module.getClassLoader();
        if (Objects.isNull(loader) || loader.getClass().getName().equals("jdk.internal.reflect.DelegatingClassLoader")) {
            throw new IllegalArgumentException("Class loader is an invalid delegating class loader");
        }
        for (String pn : pns) {
            if (!ModuleUtil.isValidPackageName(pn)) {
                throw new IllegalArgumentException("Invalid package name: " + pn + " for module: " + module.getName());
            }
            if (loader == ClassLoader.getPlatformClassLoader() || !ModuleUtil.isPackageNameForbidden(pn)) continue;
            throw new IllegalArgumentException("Class loader (instance of): " + loader.getClass().getName() + " tried to define prohibited package name: " + pn);
        }
        String definedPackage = null;
        Object object = moduleLock;
        synchronized (object) {
            moduleAlreadyDefined = ModuleUtil.isModuleDefinedToLoader(loader, module.getName());
            if (!moduleAlreadyDefined) {
                List<String> definedPackages = ModuleUtil.getPackagesDefinedToLoader(loader);
                for (String pn : pns) {
                    if (!definedPackages.contains(pn)) continue;
                    definedPackage = pn;
                    break;
                }
            }
        }
        if (moduleAlreadyDefined) {
            throw new IllegalStateException("Module " + module.getName() + " is already defined");
        }
        if (Objects.nonNull(definedPackage)) {
            Module moduleContainingDefinedPackage = SubstrateUtil.cast(ModuleUtil.getModuleContainingPackage(loader, definedPackage), Module.class);
            if (moduleContainingDefinedPackage.isNamed()) {
                throw new IllegalStateException("Package " + definedPackage + " is already in another module, " + moduleContainingDefinedPackage.getName() + ", defined to the class loader");
            }
            throw new IllegalStateException("Package " + definedPackage + " is already in the unnamed module defined to the class loader");
        }
        object = moduleLock;
        synchronized (object) {
            ModuleUtil.addDefinedModule(loader, module);
        }
    }
}

