/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class SamplerSampleWriterDataAccess {
    private SamplerSampleWriterDataAccess() {
    }

    @Uninterruptible(reason="Accesses a sampler buffer", callerMustBe=true)
    public static boolean initialize(SamplerSampleWriterData data, int skipCount, boolean allowBufferAllocation) {
        SamplerBuffer buffer = JfrThreadLocal.getSamplerBuffer();
        if (buffer.isNull()) {
            buffer = SubstrateJVM.getSamplerBufferPool().acquireBuffer(allowBufferAllocation);
            if (buffer.isNull()) {
                JfrThreadLocal.increaseMissedSamples();
                return false;
            }
            JfrThreadLocal.setSamplerBuffer(buffer);
        }
        SamplerSampleWriterDataAccess.initialize0(data, buffer, skipCount, SubstrateJVM.getStackTraceRepo().getStackTraceDepth(), allowBufferAllocation);
        return true;
    }

    @Uninterruptible(reason="Accesses a sampler buffer", callerMustBe=true)
    private static void initialize0(SamplerSampleWriterData data, SamplerBuffer buffer, int skipCount, int maxDepth, boolean allowBufferAllocation) {
        assert (SamplerBufferAccess.verify(buffer));
        data.setSamplerBuffer(buffer);
        data.setStartPos(buffer.getPos());
        data.setCurrentPos(buffer.getPos());
        data.setEndPos(SamplerBufferAccess.getDataEnd(buffer));
        data.setHashCode(1);
        data.setMaxDepth(maxDepth);
        data.setTruncated(false);
        data.setSkipCount(skipCount);
        data.setNumFrames(0);
        data.setAllowBufferAllocation(allowBufferAllocation);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static boolean verify(SamplerSampleWriterData data) {
        if (data.isNull() || !SamplerBufferAccess.verify(data.getSamplerBuffer())) {
            return false;
        }
        SamplerBuffer buffer = data.getSamplerBuffer();
        Pointer dataStart = SamplerBufferAccess.getDataStart(buffer);
        Pointer dataEnd = SamplerBufferAccess.getDataEnd(buffer);
        return data.getStartPos() == buffer.getPos() && (data.getEndPos() == dataEnd || data.getEndPos().isNull()) && data.getCurrentPos().aboveOrEqual((UnsignedWord)dataStart) && data.getCurrentPos().belowOrEqual((UnsignedWord)dataEnd) && data.getCurrentPos().aboveOrEqual((UnsignedWord)data.getStartPos());
    }
}

