/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.TimeUnit;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Threading;
import org.graalvm.nativeimage.impl.ThreadingSupport;

@AutomaticallyRegisteredImageSingleton(value={ThreadingSupport.class})
public class ThreadingSupportImpl
implements ThreadingSupport {
    private static final FastThreadLocalObject<RecurringCallbackTimer> activeTimer = FastThreadLocalFactory.createObject(RecurringCallbackTimer.class, "ThreadingSupportImpl.activeTimer");
    private static final FastThreadLocalInt currentPauseDepth = FastThreadLocalFactory.createInt("ThreadingSupportImpl.currentPauseDepth");
    private static final String enableSupportOption = SubstrateOptionsParser.commandArgument(Options.SupportRecurringCallback, "+");

    public void registerRecurringCallback(long interval, TimeUnit unit, Threading.RecurringCallback callback) {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        if (callback != null) {
            if (!Options.SupportRecurringCallback.getValue().booleanValue()) {
                VMError.shouldNotReachHere("Recurring callbacks must be enabled during image build with option " + enableSupportOption);
            }
            VMError.guarantee(SubstrateOptions.MultiThreaded.getValue(), "Recurring callbacks are only supported in multi-threaded mode.");
            long intervalNanos = unit.toNanos(interval);
            if (intervalNanos < 1L) {
                throw new IllegalArgumentException("The intervalNanos field is less than one.");
            }
            RecurringCallbackTimer timer = ThreadingSupportImpl.createRecurringCallbackTimer(intervalNanos, callback);
            ThreadingSupportImpl.registerRecurringCallback0(thread, timer);
        } else {
            ThreadingSupportImpl.removeRecurringCallback(thread);
        }
    }

    public static RecurringCallbackTimer createRecurringCallbackTimer(long intervalNanos, Threading.RecurringCallback callback) {
        assert (callback != null);
        return new RecurringCallbackTimer(intervalNanos, callback);
    }

    @Uninterruptible(reason="Prevent VM operations that modify the recurring callbacks.")
    private static void registerRecurringCallback0(IsolateThread thread, RecurringCallbackTimer timer) {
        ThreadingSupportImpl.removeRecurringCallback(thread);
        ThreadingSupportImpl.setRecurringCallback(thread, timer);
    }

    @Uninterruptible(reason="Prevent VM operations that modify the recurring callbacks.")
    public static void setRecurringCallback(IsolateThread thread, RecurringCallbackTimer timer) {
        assert (Options.SupportRecurringCallback.getValue().booleanValue() && SubstrateOptions.MultiThreaded.getValue().booleanValue());
        assert (timer.targetIntervalNanos > 0L);
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        activeTimer.set(thread, timer);
        Safepoint.setSafepointRequested(thread, timer.requestedChecks);
    }

    @Uninterruptible(reason="Prevent VM operations that modify the recurring callbacks.", callerMustBe=true)
    public static Threading.RecurringCallback getRecurringCallback(IsolateThread thread) {
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        RecurringCallbackTimer value = activeTimer.get(thread);
        if (value != null) {
            return value.callback;
        }
        return null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void removeRecurringCallback(IsolateThread thread) {
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        activeTimer.set(thread, null);
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    static void onSafepointCheckSlowpath() {
        RecurringCallbackTimer timer;
        assert (VMThreads.StatusSupport.isStatusJava()) : "must only be executed when the thread is in Java state";
        RecurringCallbackTimer recurringCallbackTimer = timer = ThreadingSupportImpl.isRecurringCallbackSupported() ? activeTimer.get() : null;
        if (timer != null) {
            timer.evaluate();
        } else {
            Safepoint.setSafepointRequested(Integer.MAX_VALUE);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean isRecurringCallbackRegistered(IsolateThread thread) {
        return ThreadingSupportImpl.isRecurringCallbackSupported() && activeTimer.get(thread) != null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean needsNativeToJavaSlowpath() {
        return VMThreads.ActionOnTransitionToJavaSupport.isActionPending() || ThreadingSupportImpl.isRecurringCallbackSupported() && Options.CheckRecurringCallbackOnNativeToJavaTransition.getValue() != false && activeTimer.get() != null && !ThreadingSupportImpl.isRecurringCallbackPaused();
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    public static void pauseRecurringCallback(String reason) {
        if (!ThreadingSupportImpl.isRecurringCallbackSupported()) {
            return;
        }
        assert (currentPauseDepth.get() >= 0);
        currentPauseDepth.set(currentPauseDepth.get() + 1);
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    public static void resumeRecurringCallbackAtNextSafepoint() {
        if (ThreadingSupportImpl.resumeCallbackExecution()) {
            RecurringCallbackTimer timer = activeTimer.get();
            assert (timer != null);
            timer.updateStatistics();
            timer.setSafepointRequested(1);
        }
    }

    public static void resumeRecurringCallback() {
        if (ThreadingSupportImpl.resumeCallbackExecution()) {
            try {
                ThreadingSupportImpl.onSafepointCheckSlowpath();
            }
            catch (Safepoint.SafepointException e) {
                ThreadingSupportImpl.throwUnchecked(e.inner);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean resumeCallbackExecution() {
        if (!ThreadingSupportImpl.isRecurringCallbackSupported()) {
            return false;
        }
        assert (currentPauseDepth.get() > 0);
        currentPauseDepth.set(currentPauseDepth.get() - 1);
        return !ThreadingSupportImpl.isRecurringCallbackPaused() && ThreadingSupportImpl.isRecurringCallbackRegistered(CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isRecurringCallbackPaused() {
        if (!ThreadingSupportImpl.isRecurringCallbackSupported()) {
            return false;
        }
        return currentPauseDepth.get() != 0;
    }

    @Fold
    public static boolean isRecurringCallbackSupported() {
        return Options.SupportRecurringCallback.getValue() != false && SubstrateOptions.MultiThreaded.getValue() != false;
    }

    private static <T extends Throwable> void throwUnchecked(Throwable exception) throws T {
        throw exception;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> SupportRecurringCallback = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> CheckRecurringCallbackOnNativeToJavaTransition = new HostedOptionKey<Boolean>(false);
    }

    public static class RecurringCallbackTimer {
        private static final Threading.RecurringCallbackAccess CALLBACK_ACCESS = new Threading.RecurringCallbackAccess(){

            public void throwException(Throwable t) {
                throw new Safepoint.SafepointException(t);
            }
        };
        private static final double EWMA_LAMBDA = 0.3;
        private static final double TARGET_INTERVAL_FLEXIBILITY = 0.95;
        private static final int INITIAL_CHECKS = 100;
        private static final long MINIMUM_INTERVAL_NANOS = 1000L;
        private final long targetIntervalNanos;
        private final long flexibleTargetIntervalNanos;
        private final Threading.RecurringCallback callback;
        private int requestedChecks;
        private double ewmaChecksPerNano;
        private long lastCapture;
        private long lastCallbackExecution;
        private volatile boolean isExecuting = false;

        RecurringCallbackTimer(long targetIntervalNanos, Threading.RecurringCallback callback) {
            long now;
            this.targetIntervalNanos = Math.max(1000L, targetIntervalNanos);
            this.flexibleTargetIntervalNanos = (long)((double)targetIntervalNanos * 0.95);
            this.callback = callback;
            this.lastCapture = now = System.nanoTime();
            this.lastCallbackExecution = now;
            this.requestedChecks = 100;
        }

        @Uninterruptible(reason="Must not contain safepoint checks.")
        void evaluate() {
            this.updateStatistics();
            try {
                this.executeCallback();
            }
            finally {
                this.updateSafepointRequested();
            }
        }

        @Uninterruptible(reason="Must be uninterruptible to avoid races with the safepoint code.")
        void updateStatistics() {
            long now = System.nanoTime();
            long elapsedNanos = now - this.lastCapture;
            int skippedChecks = RecurringCallbackTimer.getSkippedChecks(CurrentIsolate.getCurrentThread());
            int executedChecks = this.requestedChecks - skippedChecks;
            assert (executedChecks >= 0);
            if (elapsedNanos > 0L && executedChecks > 0) {
                double checksPerNano = (double)executedChecks / (double)elapsedNanos;
                this.ewmaChecksPerNano = this.ewmaChecksPerNano == 0.0 ? checksPerNano : 0.3 * checksPerNano + 0.7 * this.ewmaChecksPerNano;
                this.lastCapture = now;
            }
        }

        @Uninterruptible(reason="Must be uninterruptible to avoid races with the safepoint code.")
        private static int getSkippedChecks(IsolateThread thread) {
            int rawValue = Safepoint.getSafepointRequested(thread);
            return rawValue >= 0 ? rawValue : -rawValue;
        }

        @Uninterruptible(reason="Must not contain safepoint checks.")
        private void executeCallback() {
            block7: {
                if (this.isCallbackDisabled()) {
                    return;
                }
                this.isExecuting = true;
                try {
                    if (System.nanoTime() < this.lastCallbackExecution + this.flexibleTargetIntervalNanos) break block7;
                    this.setSafepointRequested(Integer.MAX_VALUE);
                    try {
                        this.invokeCallback();
                    }
                    finally {
                        this.lastCallbackExecution = System.nanoTime();
                        this.updateStatistics();
                    }
                }
                finally {
                    this.isExecuting = false;
                }
            }
        }

        @Uninterruptible(reason="Must not contain safepoint checks.")
        private void updateSafepointRequested() {
            long nextDeadline = this.lastCallbackExecution + this.targetIntervalNanos;
            long remainingNanos = nextDeadline - System.nanoTime();
            if (remainingNanos < 0L && this.isCallbackDisabled()) {
                this.setSafepointRequested(Integer.MAX_VALUE);
            } else {
                double checks = this.ewmaChecksPerNano * (double)(remainingNanos = remainingNanos < 1000L ? 1000L : remainingNanos);
                this.setSafepointRequested(checks > 2.147483647E9 ? Integer.MAX_VALUE : (checks < 1.0 ? 1 : (int)checks));
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        void setSafepointRequested(int value) {
            this.requestedChecks = value;
            Safepoint.setSafepointRequested(value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private boolean isCallbackDisabled() {
            return this.isExecuting || ThreadingSupportImpl.isRecurringCallbackPaused();
        }

        @Uninterruptible(reason="Required by caller, but does not apply to callee.", calleeMustBe=false)
        @RestrictHeapAccess(reason="Callee may allocate", access=RestrictHeapAccess.Access.UNRESTRICTED)
        private void invokeCallback() {
            try {
                this.callback.run(CALLBACK_ACCESS);
            }
            catch (Safepoint.SafepointException se) {
                throw se;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

