/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public abstract class ConditionalConfigurationRegistry {
    private final Map<String, Collection<Runnable>> pendingReachabilityHandlers = new ConcurrentHashMap<String, Collection<Runnable>>();

    protected void registerConditionalConfiguration(ConfigurationCondition condition, Runnable runnable) {
        if (ConfigurationCondition.alwaysTrue().equals((Object)condition)) {
            runnable.run();
        } else {
            Collection handlers = this.pendingReachabilityHandlers.computeIfAbsent(condition.getTypeName(), key -> new ConcurrentLinkedQueue());
            handlers.add(runnable);
        }
    }

    public void flushConditionalConfiguration(Feature.BeforeAnalysisAccess b) {
        for (Map.Entry<String, Collection<Runnable>> reachabilityEntry : this.pendingReachabilityHandlers.entrySet()) {
            TypeResult<Class<?>> typeResult = ((FeatureImpl.BeforeAnalysisAccessImpl)b).getImageClassLoader().findClass(reachabilityEntry.getKey());
            if (!typeResult.isPresent()) continue;
            b.registerReachabilityHandler(access -> ((Collection)reachabilityEntry.getValue()).forEach(Runnable::run), new Object[]{typeResult.get()});
        }
        this.pendingReachabilityHandlers.clear();
    }

    public void flushConditionalConfiguration(Feature.DuringAnalysisAccess b) {
        if (!this.pendingReachabilityHandlers.isEmpty()) {
            b.requireAnalysisIteration();
        }
        this.flushConditionalConfiguration((Feature.BeforeAnalysisAccess)b);
    }
}

