/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.AnalysisMethodCalleeWalker;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class RestrictHeapAccessCalleesImpl
implements RestrictHeapAccessCallees {
    private Map<AnalysisMethod, RestrictionInfo> calleeToCallerMap = Collections.emptyMap();
    private List<ResolvedJavaMethod> assertionErrorConstructorList = Collections.emptyList();
    private boolean initialized = false;

    public void setAssertionErrorConstructors(List<ResolvedJavaMethod> resolvedConstructorList) {
        if (this.assertionErrorConstructorList.isEmpty()) {
            this.assertionErrorConstructorList = resolvedConstructorList;
        }
    }

    public RestrictionInfo getRestrictionInfo(ResolvedJavaMethod method) {
        return this.calleeToCallerMap.get(RestrictHeapAccessCalleesImpl.methodToKey(method));
    }

    @Override
    public boolean mustNotAllocate(ResolvedJavaMethod method) {
        return this.isRestricted(method) || Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method);
    }

    private boolean isRestricted(ResolvedJavaMethod method) {
        RestrictionInfo info = this.getRestrictionInfo(method);
        return info != null && info.getAccess() != RestrictHeapAccess.Access.UNRESTRICTED;
    }

    public Map<AnalysisMethod, RestrictionInfo> getCallerMap() {
        return this.calleeToCallerMap;
    }

    public void aggregateMethods(Collection<AnalysisMethod> methods) {
        assert (!this.initialized) : "RestrictHeapAccessCallees.aggregateMethods: Should only initialize once.";
        HashMap<AnalysisMethod, RestrictionInfo> aggregation = new HashMap<AnalysisMethod, RestrictionInfo>();
        for (AnalysisMethod method : methods) {
            if (!method.isAnnotationPresent(RestrictHeapAccess.class)) continue;
            RestrictHeapAccessCalleesImpl.setMethodRestrictionInfo(method, aggregation);
        }
        MethodAggregator visitor = new MethodAggregator(aggregation, this.assertionErrorConstructorList);
        AnalysisMethodCalleeWalker walker = new AnalysisMethodCalleeWalker();
        for (AnalysisMethod method : aggregation.keySet().toArray(new AnalysisMethod[0])) {
            walker.walkMethod(method, visitor);
        }
        this.calleeToCallerMap = Collections.unmodifiableMap(aggregation);
        this.initialized = true;
    }

    private static void setMethodRestrictionInfo(AnalysisMethod method, Map<AnalysisMethod, RestrictionInfo> aggregation) {
        assert (method.isAnnotationPresent(RestrictHeapAccess.class));
        if (aggregation.get(method) != null) {
            return;
        }
        for (AnalysisMethod impl : method.getImplementations()) {
            if (!impl.isAnnotationPresent(RestrictHeapAccess.class) || impl.equals((Object)method)) continue;
            RestrictHeapAccessCalleesImpl.setMethodRestrictionInfo(impl, aggregation);
        }
        assert (aggregation.get(method) == null);
        RestrictHeapAccess.Access access = ((RestrictHeapAccess)method.getAnnotation(RestrictHeapAccess.class)).access();
        aggregation.put(method, new RestrictionInfo(access, null, null, method));
        for (AnalysisMethod impl : method.getImplementations()) {
            aggregation.putIfAbsent(impl, new RestrictionInfo(access, null, null, impl));
        }
    }

    private static AnalysisMethod methodToKey(ResolvedJavaMethod method) {
        AnalysisMethod result;
        if (method instanceof AnalysisMethod) {
            result = (AnalysisMethod)method;
        } else if (method instanceof HostedMethod) {
            result = ((HostedMethod)method).getWrapped();
        } else {
            throw VMError.shouldNotReachHere("RestrictHeapAccessCallees.methodToKey: ResolvedJavaMethod is neither an AnalysisMethod nor a HostedMethod: " + method);
        }
        return result;
    }

    public static class RestrictionInfo {
        private final RestrictHeapAccess.Access access;
        private final AnalysisMethod caller;
        private final StackTraceElement invocationStackTraceElement;
        private final AnalysisMethod method;

        RestrictionInfo(RestrictHeapAccess.Access access, AnalysisMethod caller, StackTraceElement stackTraceElement, AnalysisMethod method) {
            this.access = access;
            this.caller = caller;
            this.invocationStackTraceElement = stackTraceElement;
            this.method = method;
        }

        boolean isExplicit() {
            return this.caller == null;
        }

        public RestrictHeapAccess.Access getAccess() {
            return this.access;
        }

        public AnalysisMethod getCaller() {
            return this.caller;
        }

        public StackTraceElement getInvocationStackTraceElement() {
            return this.invocationStackTraceElement;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }
    }

    static class MethodAggregator
    extends AnalysisMethodCalleeWalker.CallPathVisitor {
        private final Map<AnalysisMethod, RestrictionInfo> calleeToCallerMap;
        private final List<ResolvedJavaMethod> assertionErrorConstructorList;

        MethodAggregator(Map<AnalysisMethod, RestrictionInfo> calleeToCallerMap, List<ResolvedJavaMethod> assertionErrorConstructorList) {
            this.calleeToCallerMap = calleeToCallerMap;
            this.assertionErrorConstructorList = assertionErrorConstructorList;
        }

        @Override
        public AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult visitMethod(AnalysisMethod callee, AnalysisMethod caller, BytecodePosition invokePosition, int depth) {
            RestrictionInfo existingRestrictionInfo = this.calleeToCallerMap.get(callee);
            if (caller == null) {
                assert (existingRestrictionInfo != null && existingRestrictionInfo.isExplicit());
                return existingRestrictionInfo.getAccess() == RestrictHeapAccess.Access.UNRESTRICTED ? AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CUT : AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CONTINUE;
            }
            RestrictHeapAccess.Access access = this.calleeToCallerMap.get(caller).getAccess();
            assert (access != RestrictHeapAccess.Access.UNRESTRICTED);
            if (existingRestrictionInfo != null && existingRestrictionInfo.isExplicit()) {
                return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CUT;
            }
            if (existingRestrictionInfo != null && !access.isMoreRestrictiveThan(existingRestrictionInfo.getAccess())) {
                return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CUT;
            }
            if (this.assertionErrorConstructorList != null && this.assertionErrorConstructorList.contains(callee)) {
                return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CUT;
            }
            assert (invokePosition != null);
            StackTraceElement callerStackTraceElement = invokePosition.getMethod().asStackTraceElement(invokePosition.getBCI());
            this.calleeToCallerMap.put(callee, new RestrictionInfo(access, caller, callerStackTraceElement, callee));
            return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CONTINUE;
        }
    }
}

