/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.code.CompilationResultFrameTree;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageDebugInfoProviderBase;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.sources.SourceManager;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedPrimitiveType;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.SubstitutionField;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.RawPointerTo;

class NativeImageDebugInfoProvider
extends NativeImageDebugInfoProviderBase
implements DebugInfoProvider {
    private final DebugContext debugContext;
    private final Set<HostedMethod> allOverrides;
    private final Runnable heartbeatCallback;
    private static final DebugInfoProvider.DebugLocalValueInfo[] EMPTY_LOCAL_VALUE_INFOS = new DebugInfoProvider.DebugLocalValueInfo[0];
    static final Register[] AARCH64_GPREG = new Register[]{AArch64.r0, AArch64.r1, AArch64.r2, AArch64.r3, AArch64.r4, AArch64.r5, AArch64.r6, AArch64.r7};
    static final Register[] AARCH64_FREG = new Register[]{AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7};
    static final Register[] AMD64_GPREG_LINUX = new Register[]{AMD64.rdi, AMD64.rsi, AMD64.rdx, AMD64.rcx, AMD64.r8, AMD64.r9};
    static final Register[] AMD64_FREG_LINUX = new Register[]{AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7};
    static final Register[] AMD64_GPREG_WINDOWS = new Register[]{AMD64.rdx, AMD64.r8, AMD64.r9, AMD64.rdi, AMD64.rsi, AMD64.rcx};
    static final Register[] AMD64_FREG_WINDOWS = new Register[]{AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3};
    static final int AMD64_STACK_OFFSET = 16;
    static final int AARCH64_STACK_OFFSET = 8;
    static final int AMD64_FRAMESIZE_ADJUSTMENT = -8;
    static final int AARCH64_FRAMESIZE_ADJUSTMENT = 0;

    NativeImageDebugInfoProvider(DebugContext debugContext, NativeImageCodeCache codeCache, NativeImageHeap heap, NativeLibraries nativeLibs, HostedMetaAccess metaAccess, Runnable heartbeatCallback) {
        super(codeCache, heap, nativeLibs, metaAccess);
        this.debugContext = debugContext;
        this.allOverrides = heap.hUniverse.getMethods().stream().filter(HostedMethod::hasVTableIndex).flatMap(m -> Arrays.stream(m.getImplementations()).filter(Predicate.not(m::equals))).collect(Collectors.toSet());
        this.heartbeatCallback = heartbeatCallback;
    }

    public Stream<DebugInfoProvider.DebugTypeInfo> typeInfoProvider() {
        Stream<DebugInfoProvider.DebugTypeInfo> headerTypeInfo = this.computeHeaderTypeInfo();
        Stream<DebugInfoProvider.DebugTypeInfo> heapTypeInfo = this.heap.hUniverse.getTypes().stream().map(this::createDebugTypeInfo);
        return Stream.concat(headerTypeInfo, heapTypeInfo);
    }

    public Stream<DebugInfoProvider.DebugCodeInfo> codeInfoProvider() {
        return this.codeCache.getOrderedCompilations().stream().map(pair -> new NativeImageDebugCodeInfo((HostedMethod)pair.getLeft(), (CompilationResult)pair.getRight()));
    }

    public Stream<DebugInfoProvider.DebugDataInfo> dataInfoProvider() {
        return this.heap.getObjects().stream().filter(this::acceptObjectInfo).map(this::createDebugDataInfo);
    }

    private Stream<DebugInfoProvider.DebugTypeInfo> computeHeaderTypeInfo() {
        LinkedList<NativeImageHeaderTypeInfo> infos = new LinkedList<NativeImageHeaderTypeInfo>();
        int hubOffset = NativeImageDebugInfoProvider.getObjectLayout().getHubOffset();
        int hubFieldSize = this.referenceSize;
        int objHeaderSize = hubOffset + hubFieldSize;
        int idHashSize = NativeImageDebugInfoProvider.getObjectLayout().sizeInBytes(JavaKind.Int);
        int fixedIdHashOffset = -1;
        if (NativeImageDebugInfoProvider.getObjectLayout().hasFixedIdentityHashField()) {
            fixedIdHashOffset = NativeImageDebugInfoProvider.getObjectLayout().getFixedIdentityHashOffset();
            objHeaderSize = Math.max(objHeaderSize, fixedIdHashOffset + idHashSize);
        }
        NativeImageHeaderTypeInfo objHeader = new NativeImageHeaderTypeInfo("_objhdr", objHeaderSize);
        objHeader.addField("hub", this.hubType, hubOffset, hubFieldSize);
        if (fixedIdHashOffset >= 0) {
            objHeader.addField("idHash", (ResolvedJavaType)this.javaKindToHostedType.get(JavaKind.Int), fixedIdHashOffset, idHashSize);
        }
        infos.add(objHeader);
        return infos.stream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NativeImageDebugTypeInfo createDebugTypeInfo(HostedType hostedType) {
        try (DebugContext.Scope s = this.debugContext.scope((Object)"DebugTypeInfo", (Object)hostedType.toJavaName());){
            if (this.isForeignWordType(hostedType)) {
                assert (hostedType.isInterface() || hostedType.isInstanceClass()) : "foreign type must be instance class or interface!";
                this.logForeignTypeInfo(hostedType);
                NativeImageDebugForeignTypeInfo nativeImageDebugForeignTypeInfo = new NativeImageDebugForeignTypeInfo(hostedType);
                return nativeImageDebugForeignTypeInfo;
            }
            if (hostedType.isEnum()) {
                NativeImageDebugEnumTypeInfo nativeImageDebugEnumTypeInfo = new NativeImageDebugEnumTypeInfo((HostedInstanceClass)hostedType);
                return nativeImageDebugEnumTypeInfo;
            }
            if (hostedType.isInstanceClass()) {
                NativeImageDebugInstanceTypeInfo nativeImageDebugInstanceTypeInfo = new NativeImageDebugInstanceTypeInfo(hostedType);
                return nativeImageDebugInstanceTypeInfo;
            }
            if (hostedType.isInterface()) {
                NativeImageDebugInterfaceTypeInfo nativeImageDebugInterfaceTypeInfo = new NativeImageDebugInterfaceTypeInfo((HostedInterface)hostedType);
                return nativeImageDebugInterfaceTypeInfo;
            }
            if (hostedType.isArray()) {
                NativeImageDebugArrayTypeInfo nativeImageDebugArrayTypeInfo = new NativeImageDebugArrayTypeInfo((HostedArrayClass)hostedType);
                return nativeImageDebugArrayTypeInfo;
            }
            if (!hostedType.isPrimitive()) throw new RuntimeException("Unknown type kind " + hostedType.getName());
            NativeImageDebugPrimitiveTypeInfo nativeImageDebugPrimitiveTypeInfo = new NativeImageDebugPrimitiveTypeInfo((HostedPrimitiveType)hostedType);
            return nativeImageDebugPrimitiveTypeInfo;
        }
        catch (Throwable e) {
            throw this.debugContext.handle(e);
        }
    }

    private void logForeignTypeInfo(HostedType hostedType) {
        if (!this.isForeignPointerType(hostedType)) {
            assert (hostedType.isInterface());
            this.debugContext.log(3, "Foreign word type %s", (Object)hostedType.toJavaName());
        } else {
            ElementInfo elementInfo = this.nativeLibs.findElementInfo(hostedType);
            this.logForeignPointerType(hostedType, elementInfo);
        }
    }

    private void logForeignPointerType(HostedType hostedType, ElementInfo elementInfo) {
        if (elementInfo == null) {
            if (hostedType.isInterface()) {
                this.debugContext.log(3, "Foreign pointer type %s", (Object)hostedType.toJavaName());
            } else {
                this.debugContext.log(3, "Foreign pointer type %s (class)", (Object)hostedType.toJavaName());
            }
        } else if (elementInfo instanceof PointerToInfo) {
            this.logPointerToInfo(hostedType, (PointerToInfo)elementInfo);
        } else if (elementInfo instanceof StructInfo) {
            if (elementInfo instanceof RawStructureInfo) {
                this.logRawStructureInfo(hostedType, (RawStructureInfo)elementInfo);
            } else {
                this.logStructInfo(hostedType, (StructInfo)elementInfo);
            }
        }
    }

    private void logPointerToInfo(HostedType hostedType, PointerToInfo pointerToInfo) {
        this.debugContext.log(3, "Foreign pointer type %s %s", (Object)hostedType.toJavaName(), (Object)NativeImageDebugInfoProvider.elementKind(pointerToInfo));
        assert (hostedType.isInterface());
        int size = NativeImageDebugInfoProvider.elementSize(pointerToInfo);
        boolean isUnsigned = pointerToInfo.isUnsigned();
        String typedefName = pointerToInfo.getTypedefName();
        this.debugContext.log("element size = %d", size);
        this.debugContext.log("%s", (Object)(isUnsigned ? "<unsigned>" : "<signed>"));
        if (typedefName != null) {
            this.debugContext.log("typedefname = %s", (Object)typedefName);
        }
        this.dumpElementInfo(pointerToInfo);
    }

    private void logStructInfo(HostedType hostedType, StructInfo structInfo) {
        this.debugContext.log(3, "Foreign struct type %s %s", (Object)hostedType.toJavaName(), (Object)NativeImageDebugInfoProvider.elementKind(structInfo));
        assert (hostedType.isInterface());
        boolean isIncomplete = structInfo.isIncomplete();
        if (isIncomplete) {
            this.debugContext.log("<incomplete>");
        } else {
            this.debugContext.log("complete : element size = %d", NativeImageDebugInfoProvider.elementSize(structInfo));
        }
        String typedefName = structInfo.getTypedefName();
        if (typedefName != null) {
            this.debugContext.log("    typedefName = %s", (Object)typedefName);
        }
        this.dumpElementInfo(structInfo);
    }

    private void logRawStructureInfo(HostedType hostedType, RawStructureInfo rawStructureInfo) {
        this.debugContext.log(3, "Foreign raw struct type %s %s", (Object)hostedType.toJavaName(), (Object)NativeImageDebugInfoProvider.elementKind(rawStructureInfo));
        assert (hostedType.isInterface());
        this.debugContext.log("element size = %d", NativeImageDebugInfoProvider.elementSize(rawStructureInfo));
        String typedefName = rawStructureInfo.getTypedefName();
        if (typedefName != null) {
            this.debugContext.log("    typedefName = %s", (Object)typedefName);
        }
        this.dumpElementInfo(rawStructureInfo);
    }

    private int structFieldComparator(StructFieldInfo f1, StructFieldInfo f2) {
        int offset1 = f1.getOffsetInfo().getProperty();
        int offset2 = f2.getOffsetInfo().getProperty();
        return offset1 - offset2;
    }

    private Stream<StructFieldInfo> orderedFieldsStream(ElementInfo elementInfo) {
        if (elementInfo instanceof RawStructureInfo || elementInfo instanceof StructInfo) {
            return elementInfo.getChildren().stream().filter(elt -> NativeImageDebugInfoProvider.isTypedField(elt)).map(elt -> (StructFieldInfo)elt).sorted(this::structFieldComparator);
        }
        return Stream.empty();
    }

    private void dumpElementInfo(ElementInfo elementInfo) {
        if (elementInfo != null) {
            this.debugContext.log("Element Info {%n%s}", (Object)NativeImageDebugInfoProvider.formatElementInfo(elementInfo));
        } else {
            this.debugContext.log("Element Info {}");
        }
    }

    private static String formatElementInfo(ElementInfo elementInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        NativeImageDebugInfoProvider.formatElementInfo(elementInfo, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void formatElementInfo(ElementInfo elementInfo, StringBuilder stringBuilder, int indent) {
        NativeImageDebugInfoProvider.indentElementInfo(stringBuilder, indent);
        NativeImageDebugInfoProvider.formatSingleElement(elementInfo, stringBuilder);
        List<ElementInfo> children = elementInfo.getChildren();
        if (children == null || children.isEmpty()) {
            stringBuilder.append("\n");
        } else {
            stringBuilder.append(" {\n");
            for (ElementInfo child : children) {
                NativeImageDebugInfoProvider.formatElementInfo(child, stringBuilder, indent + 1);
            }
            NativeImageDebugInfoProvider.indentElementInfo(stringBuilder, indent);
            stringBuilder.append("}\n");
        }
    }

    private static void formatSingleElement(ElementInfo elementInfo, StringBuilder stringBuilder) {
        stringBuilder.append(ClassUtil.getUnqualifiedName(elementInfo.getClass()));
        stringBuilder.append(" : ");
        stringBuilder.append(NativeImageDebugInfoProvider.elementName(elementInfo));
        if (elementInfo instanceof PropertyInfo) {
            stringBuilder.append(" = ");
            NativeImageDebugInfoProvider.formatPropertyInfo((PropertyInfo)elementInfo, stringBuilder);
        }
        if (elementInfo instanceof AccessorInfo) {
            stringBuilder.append(" ");
            stringBuilder.append((Object)((AccessorInfo)elementInfo).getAccessorKind());
        }
    }

    private static <T> void formatPropertyInfo(PropertyInfo<T> propertyInfo, StringBuilder stringBuilder) {
        stringBuilder.append(propertyInfo.getProperty());
    }

    private static void indentElementInfo(StringBuilder stringBuilder, int indent) {
        for (int i = 0; i <= indent; ++i) {
            stringBuilder.append("  ");
        }
    }

    private List<DebugInfoProvider.DebugLocalInfo> createParamInfo(ResolvedJavaMethod method, int line) {
        Signature signature = method.getSignature();
        int parameterCount = signature.getParameterCount(false);
        ArrayList<DebugInfoProvider.DebugLocalInfo> paramInfos = new ArrayList<DebugInfoProvider.DebugLocalInfo>(parameterCount);
        LocalVariableTable table = method.getLocalVariableTable();
        int slot = 0;
        ResolvedJavaType ownerType = method.getDeclaringClass();
        if (!method.isStatic()) {
            JavaKind storageKind;
            JavaKind kind = ownerType.getJavaKind();
            JavaKind javaKind = storageKind = this.isForeignWordType((JavaType)ownerType, ownerType) ? JavaKind.Long : kind;
            assert (kind == JavaKind.Object) : "must be an object";
            paramInfos.add(new NativeImageDebugLocalInfo("this", storageKind, ownerType, slot, line));
            slot += kind.getSlotCount();
        }
        for (int i = 0; i < parameterCount; ++i) {
            Local local = table == null ? null : table.getLocal(slot, 0);
            Object name = local != null ? local.getName() : "__" + i;
            ResolvedJavaType paramType = (ResolvedJavaType)signature.getParameterType(i, null);
            JavaKind kind = paramType.getJavaKind();
            JavaKind storageKind = this.isForeignWordType((JavaType)paramType, ownerType) ? JavaKind.Long : kind;
            paramInfos.add(new NativeImageDebugLocalInfo((String)name, storageKind, paramType, slot, line));
            slot += kind.getSlotCount();
        }
        return paramInfos;
    }

    private static boolean isIntegralKindPromotion(JavaKind promoted, JavaKind original) {
        return promoted == JavaKind.Int && (original == JavaKind.Boolean || original == JavaKind.Byte || original == JavaKind.Short || original == JavaKind.Char);
    }

    static int adjustFrameSize(int frameSize) {
        Architecture arch = ConfigurationValues.getTarget().arch;
        assert (arch instanceof AMD64 || arch instanceof AArch64) : "unexpected architecture";
        OS os = OS.getCurrent();
        assert (os == OS.LINUX || os == OS.WINDOWS) : "unexpected os";
        int adjustment = frameSize;
        adjustment = arch instanceof AMD64 ? (adjustment -= 8) : (adjustment += 0);
        return adjustment;
    }

    private boolean acceptObjectInfo(NativeImageHeap.ObjectInfo objectInfo) {
        return objectInfo.getPartition().getStartOffset() > 0L;
    }

    private DebugInfoProvider.DebugDataInfo createDebugDataInfo(NativeImageHeap.ObjectInfo objectInfo) {
        return new NativeImageDebugDataInfo(objectInfo);
    }

    public void recordActivity() {
        this.heartbeatCallback.run();
    }

    private class NativeImageHeaderTypeInfo
    implements DebugInfoProvider.DebugHeaderTypeInfo {
        String typeName;
        int size;
        List<DebugInfoProvider.DebugFieldInfo> fieldInfos;

        NativeImageHeaderTypeInfo(String typeName, int size) {
            this.typeName = typeName;
            this.size = size;
            this.fieldInfos = new LinkedList<DebugInfoProvider.DebugFieldInfo>();
        }

        void addField(String name, ResolvedJavaType valueType, int offset, int size) {
            NativeImageDebugHeaderFieldInfo fieldinfo = new NativeImageDebugHeaderFieldInfo(name, valueType, offset, size);
            this.fieldInfos.add(fieldinfo);
        }

        public ResolvedJavaType idType() {
            return null;
        }

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugTypeInfo", (Object)this.typeName());){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public String typeName() {
            return this.typeName;
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.HEADER;
        }

        public String fileName() {
            return "";
        }

        public Path filePath() {
            return null;
        }

        public long classOffset() {
            return -1L;
        }

        public int size() {
            return this.size;
        }

        public Stream<DebugInfoProvider.DebugFieldInfo> fieldInfoProvider() {
            return this.fieldInfos.stream();
        }
    }

    private class NativeImageDebugForeignTypeInfo
    extends NativeImageDebugInstanceTypeInfo
    implements DebugInfoProvider.DebugForeignTypeInfo {
        ElementInfo elementInfo;

        NativeImageDebugForeignTypeInfo(HostedType hostedType) {
            this(hostedType, nativeImageDebugInfoProvider.nativeLibs.findElementInfo(hostedType));
        }

        NativeImageDebugForeignTypeInfo(HostedType hostedType, ElementInfo elementInfo) {
            super(hostedType);
            assert (NativeImageDebugInfoProvider.this.isForeignWordType(hostedType));
            this.elementInfo = elementInfo;
            assert (this.verifyElementInfo()) : "unexpected element info kind";
        }

        private boolean verifyElementInfo() {
            if (this.elementInfo == null || !(this.elementInfo instanceof SizableInfo)) {
                return true;
            }
            switch (NativeImageDebugInfoProviderBase.elementKind((SizableInfo)this.elementInfo)) {
                case INTEGER: 
                case POINTER: 
                case FLOAT: 
                case UNKNOWN: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.FOREIGN;
        }

        @Override
        public Stream<DebugInfoProvider.DebugFieldInfo> fieldInfoProvider() {
            return NativeImageDebugInfoProvider.this.orderedFieldsStream(this.elementInfo).map(this::createDebugForeignFieldInfo);
        }

        @Override
        public int size() {
            return NativeImageDebugInfoProviderBase.elementSize(this.elementInfo);
        }

        DebugInfoProvider.DebugFieldInfo createDebugForeignFieldInfo(StructFieldInfo structFieldInfo) {
            return new NativeImageDebugForeignFieldInfo(this.hostedType, structFieldInfo);
        }

        public String typedefName() {
            String name = null;
            if (this.elementInfo != null) {
                if (this.elementInfo instanceof PointerToInfo) {
                    name = ((PointerToInfo)this.elementInfo).getTypedefName();
                } else if (this.elementInfo instanceof StructInfo) {
                    name = ((StructInfo)this.elementInfo).getTypedefName();
                }
                if (name == null) {
                    name = NativeImageDebugInfoProviderBase.elementName(this.elementInfo);
                }
            }
            return name;
        }

        public boolean isWord() {
            return !NativeImageDebugInfoProvider.this.isForeignPointerType(this.hostedType);
        }

        public boolean isStruct() {
            return this.elementInfo instanceof StructInfo;
        }

        public boolean isPointer() {
            if (this.elementInfo != null && this.elementInfo instanceof SizableInfo) {
                return NativeImageDebugInfoProviderBase.elementKind((SizableInfo)this.elementInfo) == SizableInfo.ElementKind.POINTER;
            }
            return false;
        }

        public boolean isIntegral() {
            if (this.elementInfo != null && this.elementInfo instanceof SizableInfo) {
                return NativeImageDebugInfoProviderBase.elementKind((SizableInfo)this.elementInfo) == SizableInfo.ElementKind.INTEGER;
            }
            return false;
        }

        public boolean isFloat() {
            if (this.elementInfo != null) {
                return NativeImageDebugInfoProviderBase.elementKind((SizableInfo)this.elementInfo) == SizableInfo.ElementKind.FLOAT;
            }
            return false;
        }

        public boolean isSigned() {
            return NativeImageDebugInfoProvider.this.nativeLibs.isSigned((ResolvedJavaType)this.hostedType.getWrapped()) || this.isIntegral() && !((SizableInfo)this.elementInfo).isUnsigned();
        }

        public ResolvedJavaType parent() {
            if (this.isStruct()) {
                for (HostedInterface hostedInterface : this.hostedType.getInterfaces()) {
                    ElementInfo otherInfo = NativeImageDebugInfoProvider.this.nativeLibs.findElementInfo(hostedInterface);
                    if (!(otherInfo instanceof StructInfo)) continue;
                    return NativeImageDebugInfoProviderBase.getOriginal(hostedInterface);
                }
            }
            return null;
        }

        public ResolvedJavaType pointerTo() {
            if (this.isPointer()) {
                CPointerTo cPointerTo = this.hostedType.getAnnotation(CPointerTo.class);
                if (cPointerTo != null) {
                    ResolvedJavaType pointerTo = NativeImageDebugInfoProvider.this.heap.hMetaAccess.lookupJavaType(cPointerTo.value());
                    return NativeImageDebugInfoProviderBase.getOriginal((HostedType)pointerTo);
                }
                RawPointerTo rawPointerTo = this.hostedType.getAnnotation(RawPointerTo.class);
                if (rawPointerTo != null) {
                    ResolvedJavaType pointerTo = NativeImageDebugInfoProvider.this.heap.hMetaAccess.lookupJavaType(rawPointerTo.value());
                    return NativeImageDebugInfoProviderBase.getOriginal((HostedType)pointerTo);
                }
            }
            return null;
        }
    }

    private class NativeImageDebugEnumTypeInfo
    extends NativeImageDebugInstanceTypeInfo
    implements DebugInfoProvider.DebugEnumTypeInfo {
        NativeImageDebugEnumTypeInfo(HostedInstanceClass enumClass) {
            super(enumClass);
        }

        @Override
        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ENUM;
        }
    }

    private class NativeImageDebugInstanceTypeInfo
    extends NativeImageDebugTypeInfo
    implements DebugInfoProvider.DebugInstanceTypeInfo {
        NativeImageDebugInstanceTypeInfo(HostedType hostedType) {
            super(hostedType);
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INSTANCE;
        }

        public String loaderName() {
            return UniqueShortNameProvider.singleton().uniqueShortLoaderName(this.hostedType.getJavaClass().getClassLoader());
        }

        public Stream<DebugInfoProvider.DebugFieldInfo> fieldInfoProvider() {
            Stream<DebugInfoProvider.DebugFieldInfo> instanceFieldsStream = Arrays.stream(this.hostedType.getInstanceFields(false)).map(this::createDebugFieldInfo);
            if (this.hostedType instanceof HostedInstanceClass && this.hostedType.getStaticFields().length > 0) {
                Stream<DebugInfoProvider.DebugFieldInfo> staticFieldsStream = Arrays.stream(this.hostedType.getStaticFields()).map(this::createDebugStaticFieldInfo);
                return Stream.concat(instanceFieldsStream, staticFieldsStream);
            }
            return instanceFieldsStream;
        }

        public Stream<DebugInfoProvider.DebugMethodInfo> methodInfoProvider() {
            return Arrays.stream(this.hostedType.getAllDeclaredMethods()).map(this::createDebugMethodInfo);
        }

        public ResolvedJavaType superClass() {
            HostedClass superClass = this.hostedType.getSuperclass();
            if (superClass != null) {
                return NativeImageDebugInfoProviderBase.getOriginal(superClass);
            }
            return null;
        }

        public Stream<ResolvedJavaType> interfaces() {
            return Arrays.stream(this.hostedType.getInterfaces()).map(interfaceType -> NativeImageDebugInfoProviderBase.getOriginal(interfaceType));
        }

        private NativeImageDebugFieldInfo createDebugFieldInfo(HostedField field) {
            return new NativeImageDebugFieldInfo(field);
        }

        private NativeImageDebugFieldInfo createDebugStaticFieldInfo(ResolvedJavaField field) {
            return new NativeImageDebugFieldInfo((HostedField)field);
        }

        private NativeImageDebugMethodInfo createDebugMethodInfo(HostedMethod method) {
            return new NativeImageDebugMethodInfo(method);
        }

        private class NativeImageDebugFieldInfo
        extends NativeImageDebugFileInfo
        implements DebugInfoProvider.DebugFieldInfo {
            private final HostedField field;

            NativeImageDebugFieldInfo(HostedField field) {
                super(field);
                this.field = field;
            }

            public String name() {
                return this.field.getName();
            }

            public ResolvedJavaType valueType() {
                return NativeImageDebugInfoProviderBase.getOriginal(this.field.getType());
            }

            public int offset() {
                int offset = this.field.getLocation();
                if (this.isStatic() && offset >= 0) {
                    offset = this.isPrimitive() ? (offset += NativeImageDebugInfoProvider.this.primitiveStartOffset) : (offset += NativeImageDebugInfoProvider.this.referenceStartOffset);
                }
                return offset;
            }

            public int size() {
                return NativeImageDebugInfoProviderBase.getObjectLayout().sizeInBytes(this.field.getType().getStorageKind());
            }

            public boolean isEmbedded() {
                return false;
            }

            public int modifiers() {
                ResolvedJavaField targetField = this.field.wrapped.wrapped;
                if (targetField instanceof SubstitutionField) {
                    targetField = ((SubstitutionField)targetField).getOriginal();
                }
                return targetField.getModifiers();
            }

            private boolean isStatic() {
                return Modifier.isStatic(this.modifiers());
            }

            private boolean isPrimitive() {
                return this.field.getType().getStorageKind().isPrimitive();
            }
        }

        private class NativeImageDebugMethodInfo
        extends NativeImageDebugHostedMethodInfo
        implements DebugInfoProvider.DebugMethodInfo {
            NativeImageDebugMethodInfo(HostedMethod hostedMethod) {
                super(hostedMethod);
            }
        }
    }

    private class NativeImageDebugInterfaceTypeInfo
    extends NativeImageDebugInstanceTypeInfo
    implements DebugInfoProvider.DebugInterfaceTypeInfo {
        NativeImageDebugInterfaceTypeInfo(HostedInterface interfaceClass) {
            super(interfaceClass);
        }

        @Override
        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INTERFACE;
        }
    }

    private class NativeImageDebugArrayTypeInfo
    extends NativeImageDebugTypeInfo
    implements DebugInfoProvider.DebugArrayTypeInfo {
        HostedArrayClass arrayClass;
        List<DebugInfoProvider.DebugFieldInfo> fieldInfos;

        NativeImageDebugArrayTypeInfo(HostedArrayClass arrayClass) {
            super(arrayClass);
            this.arrayClass = arrayClass;
            this.fieldInfos = new LinkedList<DebugInfoProvider.DebugFieldInfo>();
            JavaKind arrayKind = arrayClass.getBaseType().getJavaKind();
            int headerSize = NativeImageDebugInfoProviderBase.getObjectLayout().getArrayBaseOffset(arrayKind);
            int arrayLengthOffset = NativeImageDebugInfoProviderBase.getObjectLayout().getArrayLengthOffset();
            int arrayLengthSize = NativeImageDebugInfoProviderBase.getObjectLayout().sizeInBytes(JavaKind.Int);
            assert (arrayLengthOffset + arrayLengthSize <= headerSize);
            this.addField("len", (ResolvedJavaType)NativeImageDebugInfoProvider.this.javaKindToHostedType.get(JavaKind.Int), arrayLengthOffset, arrayLengthSize);
        }

        void addField(String name, ResolvedJavaType valueType, int offset, int size) {
            NativeImageDebugHeaderFieldInfo fieldinfo = new NativeImageDebugHeaderFieldInfo(name, valueType, offset, size);
            this.fieldInfos.add(fieldinfo);
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ARRAY;
        }

        public int baseSize() {
            return NativeImageDebugInfoProviderBase.getObjectLayout().getArrayBaseOffset(this.arrayClass.getComponentType().getStorageKind());
        }

        public int lengthOffset() {
            return NativeImageDebugInfoProviderBase.getObjectLayout().getArrayLengthOffset();
        }

        public ResolvedJavaType elementType() {
            HostedType elementType = this.arrayClass.getComponentType();
            return NativeImageDebugInfoProviderBase.getOriginal(elementType);
        }

        public Stream<DebugInfoProvider.DebugFieldInfo> fieldInfoProvider() {
            return this.fieldInfos.stream();
        }
    }

    private class NativeImageDebugPrimitiveTypeInfo
    extends NativeImageDebugTypeInfo
    implements DebugInfoProvider.DebugPrimitiveTypeInfo {
        private final HostedPrimitiveType primitiveType;

        NativeImageDebugPrimitiveTypeInfo(HostedPrimitiveType primitiveType) {
            super(primitiveType);
            this.primitiveType = primitiveType;
        }

        public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
            return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.PRIMITIVE;
        }

        public int bitCount() {
            JavaKind javaKind = this.primitiveType.getStorageKind();
            return javaKind == JavaKind.Void ? 0 : javaKind.getBitCount();
        }

        public char typeChar() {
            return this.primitiveType.getStorageKind().getTypeChar();
        }

        public int flags() {
            char typeChar = this.primitiveType.getStorageKind().getTypeChar();
            switch (typeChar) {
                case 'B': 
                case 'I': 
                case 'J': 
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 3;
                }
                case 'D': 
                case 'F': {
                    return 1;
                }
            }
            assert (typeChar == 'V' || typeChar == 'Z');
            return 0;
        }
    }

    public class NativeImageDebugLocalInfo
    implements DebugInfoProvider.DebugLocalInfo {
        protected final String name;
        protected ResolvedJavaType type;
        protected final JavaKind kind;
        protected int slot;
        protected int line;

        NativeImageDebugLocalInfo(String name, JavaKind kind, ResolvedJavaType resolvedType, int slot, int line) {
            this.name = name;
            this.kind = kind;
            this.slot = slot;
            this.line = line;
            this.type = resolvedType != null ? resolvedType : NativeImageDebugInfoProvider.this.hostedTypeForKind(kind);
        }

        public ResolvedJavaType valueType() {
            if (this.type != null && this.type instanceof HostedType) {
                return NativeImageDebugInfoProviderBase.getOriginal((HostedType)this.type);
            }
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public String typeName() {
            ResolvedJavaType valueType = this.valueType();
            return valueType == null ? "" : this.valueType().toJavaName();
        }

        public int slot() {
            return this.slot;
        }

        public int slotCount() {
            return this.kind.getSlotCount();
        }

        public JavaKind javaKind() {
            return this.kind;
        }

        public int line() {
            return this.line;
        }
    }

    private class NativeImageDebugDataInfo
    implements DebugInfoProvider.DebugDataInfo {
        private final NativeImageHeap.ObjectInfo objectInfo;

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugDataInfo");){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        NativeImageDebugDataInfo(NativeImageHeap.ObjectInfo objectInfo) {
            this.objectInfo = objectInfo;
        }

        public String getProvenance() {
            return this.objectInfo.toString();
        }

        public String getTypeName() {
            return this.objectInfo.getClazz().toJavaName();
        }

        public String getPartition() {
            ImageHeapPartition partition = this.objectInfo.getPartition();
            return partition.getName() + "{" + partition.getSize() + "}@" + partition.getStartOffset();
        }

        public long getOffset() {
            return this.objectInfo.getOffset();
        }

        public long getAddress() {
            return this.objectInfo.getAddress();
        }

        public long getSize() {
            return this.objectInfo.getSize();
        }
    }

    private class NativeImageDebugCodeInfo
    extends NativeImageDebugHostedMethodInfo
    implements DebugInfoProvider.DebugCodeInfo {
        private final CompilationResult compilation;
        protected static final int CALLER_INFO = 0;
        protected static final int PARENT_NODE_TO_EMBED = 1;
        protected static final int LAST_LEAF_INFO = 2;

        NativeImageDebugCodeInfo(HostedMethod method, CompilationResult compilation) {
            super(method);
            this.compilation = compilation;
        }

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugCodeInfo", (Object)this.hostedMethod);){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public int addressLo() {
            return this.hostedMethod.getCodeAddressOffset();
        }

        public int addressHi() {
            return this.hostedMethod.getCodeAddressOffset() + this.compilation.getTargetCodeSize();
        }

        public Stream<DebugInfoProvider.DebugLocationInfo> locationInfoProvider() {
            CompilationResultFrameTree.CallNode root;
            if (this.fileName().length() == 0) {
                return Stream.empty();
            }
            boolean omitInline = SubstrateOptions.OmitInlinedMethodDebugLineInfo.getValue();
            int maxDepth = SubstrateOptions.DebugCodeInfoMaxDepth.getValue();
            boolean useSourceMappings = SubstrateOptions.DebugCodeInfoUseSourceMappings.getValue();
            if (omitInline) {
                if (!SubstrateOptions.DebugCodeInfoMaxDepth.hasBeenSet()) {
                    maxDepth = 2;
                }
                if (!SubstrateOptions.DebugCodeInfoUseSourceMappings.hasBeenSet()) {
                    useSourceMappings = false;
                }
            }
            if ((root = new CompilationResultFrameTree.Builder(NativeImageDebugInfoProvider.this.debugContext, this.compilation.getTargetCodeSize(), maxDepth, useSourceMappings, true).build(this.compilation)) == null) {
                return Stream.empty();
            }
            ArrayList<DebugInfoProvider.DebugLocationInfo> locationInfos = new ArrayList<DebugInfoProvider.DebugLocationInfo>();
            int frameSize = this.getFrameSize();
            SingleLevelVisitor visitor = omitInline ? new TopLevelVisitor(locationInfos, frameSize) : new MultiLevelVisitor(locationInfos, frameSize);
            root.visitChildren(visitor, null, null, null);
            this.updateInitialLocation(locationInfos);
            return locationInfos.stream();
        }

        private int findMarkOffset(SubstrateBackend.SubstrateMarkId markId) {
            for (CompilationResult.CodeMark mark : this.compilation.getMarks()) {
                if (!mark.id.equals((Object)markId)) continue;
                return mark.pcOffset;
            }
            return -1;
        }

        private void updateInitialLocation(List<DebugInfoProvider.DebugLocationInfo> locationInfos) {
            int prologueEnd = this.findMarkOffset(SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
            if (prologueEnd < 0) {
                return;
            }
            int stackDecrement = this.findMarkOffset(SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
            if (stackDecrement < 0) {
                return;
            }
            if (locationInfos.isEmpty()) {
                return;
            }
            NativeImageDebugLocationInfo firstLocation = (NativeImageDebugLocationInfo)locationInfos.get(0);
            int firstLocationOffset = firstLocation.addressLo();
            if (firstLocationOffset == 0) {
                return;
            }
            if (firstLocationOffset < prologueEnd) {
                return;
            }
            ParamLocationProducer locProducer = new ParamLocationProducer(this.method);
            NativeImageDebugInfoProvider.this.debugContext.log(4, "Add synthetic Location Info : %s (0, %d)", (Object)this.method.getName(), firstLocationOffset - 1);
            NativeImageDebugLocationInfo locationInfo = new NativeImageDebugLocationInfo(this.method, firstLocationOffset, locProducer);
            if (locProducer.usesStack() && firstLocationOffset > stackDecrement) {
                int adjustment = NativeImageDebugInfoProvider.adjustFrameSize(this.getFrameSize());
                NativeImageDebugLocationInfo splitLocationInfo = locationInfo.split(stackDecrement, adjustment);
                NativeImageDebugInfoProvider.this.debugContext.log(4, "Split synthetic Location Info : %s (%d, %d) (%d, %d)", (Object)locationInfo.name(), (Object)0, (Object)(locationInfo.addressLo() - 1), (Object)locationInfo.addressLo(), (Object)(locationInfo.addressHi() - 1));
                locationInfos.add(0, splitLocationInfo);
            }
            locationInfos.add(0, locationInfo);
        }

        private boolean hasChildren(CompilationResultFrameTree.CallNode callNode) {
            Object[] result = new Object[]{false};
            callNode.visitChildren(new CompilationResultFrameTree.Visitor(){

                @Override
                public void apply(CompilationResultFrameTree.FrameNode node, Object ... args) {
                    args[0] = true;
                }
            }, result);
            return (Boolean)result[0];
        }

        private NativeImageDebugLocationInfo createLeafLocationInfo(CompilationResultFrameTree.FrameNode node, NativeImageDebugLocationInfo callerInfo, int framesize) {
            assert (!(node instanceof CompilationResultFrameTree.CallNode));
            NativeImageDebugLocationInfo locationInfo = new NativeImageDebugLocationInfo(node, callerInfo, framesize);
            NativeImageDebugInfoProvider.this.debugContext.log(4, "Create leaf Location Info : %s depth %d (%d, %d)", (Object)locationInfo.name(), (Object)locationInfo.depth(), (Object)locationInfo.addressLo(), (Object)(locationInfo.addressHi() - 1));
            return locationInfo;
        }

        private NativeImageDebugLocationInfo createCallLocationInfo(CompilationResultFrameTree.CallNode callNode, NativeImageDebugLocationInfo callerInfo, int framesize) {
            BytecodePosition callerPos = this.realCaller(callNode);
            NativeImageDebugLocationInfo locationInfo = new NativeImageDebugLocationInfo(callerPos, callNode.getStartPos(), callNode.getEndPos() + 1, callerInfo, framesize);
            NativeImageDebugInfoProvider.this.debugContext.log(4, "Create call Location Info : %s depth %d (%d, %d)", (Object)locationInfo.name(), (Object)locationInfo.depth(), (Object)locationInfo.addressLo(), (Object)(locationInfo.addressHi() - 1));
            return locationInfo;
        }

        private NativeImageDebugLocationInfo createEmbeddedParentLocationInfo(CompilationResultFrameTree.CallNode parentToEmbed, CompilationResultFrameTree.FrameNode firstChild, NativeImageDebugLocationInfo callerLocation, int framesize) {
            BytecodePosition pos = parentToEmbed.frame;
            int startPos = parentToEmbed.getStartPos();
            int endPos = firstChild != null ? firstChild.getStartPos() : parentToEmbed.getEndPos() + 1;
            NativeImageDebugLocationInfo locationInfo = new NativeImageDebugLocationInfo(pos, startPos, endPos, callerLocation, framesize);
            NativeImageDebugInfoProvider.this.debugContext.log(4, "Embed leaf Location Info : %s depth %d (%d, %d)", (Object)locationInfo.name(), (Object)locationInfo.depth(), (Object)locationInfo.addressLo(), (Object)(locationInfo.addressHi() - 1));
            return locationInfo;
        }

        private NativeImageDebugLocationInfo createBadLeafLocationInfo(CompilationResultFrameTree.FrameNode node, NativeImageDebugLocationInfo callerLocation, int framesize) {
            assert (!(node instanceof CompilationResultFrameTree.CallNode)) : "bad leaf location cannot be a call node!";
            assert (callerLocation == null) : "should only see bad leaf at top level!";
            BytecodePosition pos = node.frame;
            BytecodePosition callerPos = pos.getCaller();
            assert (callerPos != null) : "bad leaf must have a caller";
            assert (callerPos.getCaller() == null) : "bad leaf caller must be root method";
            int startPos = node.getStartPos();
            int endPos = node.getEndPos() + 1;
            NativeImageDebugLocationInfo locationInfo = new NativeImageDebugLocationInfo(callerPos, startPos, endPos, null, framesize);
            NativeImageDebugInfoProvider.this.debugContext.log(4, "Embed leaf Location Info : %s depth %d (%d, %d)", (Object)locationInfo.name(), (Object)locationInfo.depth(), (Object)locationInfo.addressLo(), (Object)(locationInfo.addressHi() - 1));
            return locationInfo;
        }

        private boolean isBadLeaf(CompilationResultFrameTree.FrameNode node, NativeImageDebugLocationInfo callerLocation) {
            BytecodePosition pos;
            BytecodePosition callerPos;
            return callerLocation == null && (callerPos = (pos = node.frame).getCaller()) != null && !callerPos.getMethod().equals(pos.getMethod()) && callerPos.getCaller() == null;
        }

        private boolean skipPos(BytecodePosition pos) {
            return pos.getBCI() == -1 && pos instanceof NodeSourcePosition && ((NodeSourcePosition)pos).isSubstitution();
        }

        private BytecodePosition realCaller(CompilationResultFrameTree.CallNode node) {
            BytecodePosition pos = node.frame.getCaller();
            while (this.skipPos(pos)) {
                pos = pos.getCaller();
            }
            return pos;
        }

        private boolean skipNode(CompilationResultFrameTree.FrameNode node) {
            return node instanceof CompilationResultFrameTree.CallNode && this.skipPos(node.frame);
        }

        private boolean embedWithChildren(CompilationResultFrameTree.CallNode parent, CompilationResultFrameTree.FrameNode firstChild) {
            return parent.getStartPos() < firstChild.getStartPos();
        }

        private NativeImageDebugLocationInfo tryMerge(NativeImageDebugLocationInfo newLeaf, Object[] args) {
            NativeImageDebugLocationInfo lastLeaf = (NativeImageDebugLocationInfo)args[2];
            if (lastLeaf != null && (lastLeaf = lastLeaf.merge(newLeaf)) != null) {
                return null;
            }
            args[2] = newLeaf;
            return newLeaf;
        }

        private void initMerge(NativeImageDebugLocationInfo lastLeaf, Object[] args) {
            args[2] = lastLeaf;
        }

        private void invalidateMerge(Object[] args) {
            args[2] = null;
        }

        public int getFrameSize() {
            return this.compilation.getTotalFrameSize();
        }

        public List<DebugInfoProvider.DebugFrameSizeChange> getFrameSizeChanges() {
            LinkedList<DebugInfoProvider.DebugFrameSizeChange> frameSizeChanges = new LinkedList<DebugInfoProvider.DebugFrameSizeChange>();
            for (CompilationResult.CodeMark mark : this.compilation.getMarks()) {
                NativeImageDebugFrameSizeChange sizeChange;
                if (mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP)) {
                    sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND);
                    frameSizeChanges.add(sizeChange);
                    continue;
                }
                if (mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.EPILOGUE_INCD_RSP)) {
                    sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.CONTRACT);
                    frameSizeChanges.add(sizeChange);
                    continue;
                }
                if (!mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.EPILOGUE_END) || mark.pcOffset >= this.compilation.getTargetCodeSize()) continue;
                sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND);
                frameSizeChanges.add(sizeChange);
            }
            return frameSizeChanges;
        }

        private class TopLevelVisitor
        extends SingleLevelVisitor {
            TopLevelVisitor(List<DebugInfoProvider.DebugLocationInfo> locationInfos, int frameSize) {
                super(locationInfos, frameSize);
            }

            @Override
            public void apply(CompilationResultFrameTree.FrameNode node, Object ... args) {
                if (NativeImageDebugCodeInfo.this.skipNode(node)) {
                    node.visitChildren(this, args);
                } else {
                    NativeImageDebugLocationInfo locationInfo = this.process(node, null);
                    if (node instanceof CompilationResultFrameTree.CallNode) {
                        this.locationInfos.add(locationInfo);
                        NativeImageDebugCodeInfo.this.invalidateMerge(args);
                    } else if ((locationInfo = NativeImageDebugCodeInfo.this.tryMerge(locationInfo, args)) != null) {
                        this.locationInfos.add(locationInfo);
                    }
                }
            }
        }

        public class MultiLevelVisitor
        extends SingleLevelVisitor {
            MultiLevelVisitor(List<DebugInfoProvider.DebugLocationInfo> locationInfos, int frameSize) {
                super(locationInfos, frameSize);
            }

            @Override
            public void apply(CompilationResultFrameTree.FrameNode node, Object ... args) {
                if (NativeImageDebugCodeInfo.this.skipNode(node)) {
                    node.visitChildren(this, args);
                } else {
                    NativeImageDebugLocationInfo callerInfo = (NativeImageDebugLocationInfo)args[0];
                    CompilationResultFrameTree.CallNode nodeToEmbed = (CompilationResultFrameTree.CallNode)args[1];
                    if (nodeToEmbed != null) {
                        if (NativeImageDebugCodeInfo.this.embedWithChildren(nodeToEmbed, node)) {
                            NativeImageDebugLocationInfo embeddedLocationInfo = NativeImageDebugCodeInfo.this.createEmbeddedParentLocationInfo(nodeToEmbed, node, callerInfo, this.frameSize);
                            this.locationInfos.add(embeddedLocationInfo);
                            NativeImageDebugCodeInfo.this.initMerge(embeddedLocationInfo, args);
                        }
                        nodeToEmbed = null;
                        args[1] = null;
                    }
                    NativeImageDebugLocationInfo locationInfo = this.process(node, callerInfo);
                    if (node instanceof CompilationResultFrameTree.CallNode) {
                        CompilationResultFrameTree.CallNode callNode = (CompilationResultFrameTree.CallNode)node;
                        this.locationInfos.add(locationInfo);
                        NativeImageDebugCodeInfo.this.invalidateMerge(args);
                        if (NativeImageDebugCodeInfo.this.hasChildren(callNode)) {
                            callNode.visitChildren(this, locationInfo, callNode, null);
                        } else {
                            locationInfo = NativeImageDebugCodeInfo.this.createEmbeddedParentLocationInfo(callNode, null, locationInfo, this.frameSize);
                            this.locationInfos.add(locationInfo);
                        }
                    } else if ((locationInfo = NativeImageDebugCodeInfo.this.tryMerge(locationInfo, args)) != null) {
                        this.locationInfos.add(locationInfo);
                    }
                }
            }
        }

        private abstract class SingleLevelVisitor
        implements CompilationResultFrameTree.Visitor {
            protected final List<DebugInfoProvider.DebugLocationInfo> locationInfos;
            protected final int frameSize;

            SingleLevelVisitor(List<DebugInfoProvider.DebugLocationInfo> locationInfos, int frameSize) {
                this.locationInfos = locationInfos;
                this.frameSize = frameSize;
            }

            public NativeImageDebugLocationInfo process(CompilationResultFrameTree.FrameNode node, NativeImageDebugLocationInfo callerInfo) {
                NativeImageDebugLocationInfo locationInfo = node instanceof CompilationResultFrameTree.CallNode ? NativeImageDebugCodeInfo.this.createCallLocationInfo((CompilationResultFrameTree.CallNode)node, callerInfo, this.frameSize) : (NativeImageDebugCodeInfo.this.isBadLeaf(node, callerInfo) ? NativeImageDebugCodeInfo.this.createBadLeafLocationInfo(node, callerInfo, this.frameSize) : NativeImageDebugCodeInfo.this.createLeafLocationInfo(node, callerInfo, this.frameSize));
                return locationInfo;
            }
        }
    }

    private class NativeImageDebugFrameSizeChange
    implements DebugInfoProvider.DebugFrameSizeChange {
        private int offset;
        private DebugInfoProvider.DebugFrameSizeChange.Type type;

        NativeImageDebugFrameSizeChange(int offset, DebugInfoProvider.DebugFrameSizeChange.Type type) {
            this.offset = offset;
            this.type = type;
        }

        public int getOffset() {
            return this.offset;
        }

        public DebugInfoProvider.DebugFrameSizeChange.Type getType() {
            return this.type;
        }
    }

    public static final class NativeImageDebugConstantValue
    extends NativeImageDebugLocalValue {
        private static EconomicMap<JavaConstant, NativeImageDebugConstantValue> constantValues = EconomicMap.create();
        private JavaConstant value;
        private long heapoffset;

        private NativeImageDebugConstantValue(JavaConstant value, long heapoffset) {
            this.value = value;
            this.heapoffset = heapoffset;
        }

        static NativeImageDebugConstantValue create(JavaConstant value) {
            return NativeImageDebugConstantValue.create(value, -1L);
        }

        static NativeImageDebugConstantValue create(JavaConstant value, long heapoffset) {
            NativeImageDebugConstantValue c = (NativeImageDebugConstantValue)constantValues.get((Object)value);
            if (c == null) {
                c = new NativeImageDebugConstantValue(value, heapoffset);
                constantValues.put((Object)value, (Object)c);
            }
            assert (c.heapoffset == heapoffset);
            return c;
        }

        public JavaConstant getConstant() {
            return this.value;
        }

        public long getHeapOffset() {
            return this.heapoffset;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NativeImageDebugConstantValue)) {
                return false;
            }
            NativeImageDebugConstantValue that = (NativeImageDebugConstantValue)o;
            return this.heapoffset == that.heapoffset && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value) * 31 + (int)this.heapoffset;
        }
    }

    public static final class NativeImageDebugStackValue
    extends NativeImageDebugLocalValue {
        private static EconomicMap<Integer, NativeImageDebugStackValue> stackValues = EconomicMap.create();
        private int offset;

        private NativeImageDebugStackValue(int offset) {
            this.offset = offset;
        }

        private static NativeImageDebugStackValue create(StackSlot value, int framesize) {
            return NativeImageDebugStackValue.create(value.getOffset(framesize));
        }

        private static NativeImageDebugStackValue create(int offset) {
            NativeImageDebugStackValue value = (NativeImageDebugStackValue)stackValues.get((Object)offset);
            if (value == null) {
                value = new NativeImageDebugStackValue(offset);
                stackValues.put((Object)offset, (Object)value);
            }
            return value;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NativeImageDebugStackValue)) {
                return false;
            }
            NativeImageDebugStackValue that = (NativeImageDebugStackValue)o;
            return this.offset == that.offset;
        }

        public int hashCode() {
            return this.offset * 31;
        }
    }

    public static final class NativeImageDebugRegisterValue
    extends NativeImageDebugLocalValue {
        private static EconomicMap<Integer, NativeImageDebugRegisterValue> registerValues = EconomicMap.create();
        private int number;

        private NativeImageDebugRegisterValue(int number) {
            this.number = number;
        }

        static NativeImageDebugRegisterValue create(RegisterValue value) {
            return NativeImageDebugRegisterValue.create(value.getRegister().number);
        }

        static NativeImageDebugRegisterValue create(int number) {
            NativeImageDebugRegisterValue value = (NativeImageDebugRegisterValue)registerValues.get((Object)number);
            if (value == null) {
                value = new NativeImageDebugRegisterValue(number);
                registerValues.put((Object)number, (Object)value);
            }
            return value;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NativeImageDebugRegisterValue)) {
                return false;
            }
            NativeImageDebugRegisterValue that = (NativeImageDebugRegisterValue)o;
            return this.number == that.number;
        }

        public int hashCode() {
            return this.number * 31;
        }
    }

    public static abstract class NativeImageDebugLocalValue {
    }

    public class NativeImageDebugLocalValueInfo
    extends NativeImageDebugLocalInfo
    implements DebugInfoProvider.DebugLocalValueInfo {
        private final NativeImageDebugLocalValue value;
        private DebugInfoProvider.DebugLocalValueInfo.LocalKind localKind;

        NativeImageDebugLocalValueInfo(String name, JavaValue value, int framesize, JavaKind kind, ResolvedJavaType resolvedType, int slot, int line) {
            super(name, kind, resolvedType, slot, line);
            if (value instanceof RegisterValue) {
                this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.REGISTER;
                this.value = NativeImageDebugRegisterValue.create((RegisterValue)value);
            } else if (value instanceof StackSlot) {
                this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.STACKSLOT;
                this.value = NativeImageDebugStackValue.create((StackSlot)value, framesize);
            } else if (value instanceof JavaConstant) {
                JavaConstant constant = (JavaConstant)value;
                if (constant instanceof PrimitiveConstant || constant.isNull()) {
                    this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.CONSTANT;
                    this.value = NativeImageDebugConstantValue.create(constant);
                } else {
                    long heapOffset = NativeImageDebugInfoProvider.this.objectOffset(constant);
                    if (heapOffset >= 0L) {
                        this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.CONSTANT;
                        this.value = new NativeImageDebugConstantValue(constant, heapOffset);
                    } else {
                        this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.UNDEFINED;
                        this.value = null;
                    }
                }
            } else {
                this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.UNDEFINED;
                this.value = null;
            }
        }

        NativeImageDebugLocalValueInfo(String name, NativeImageDebugLocalValue value, JavaKind kind, ResolvedJavaType type, int slot, int line) {
            super(name, kind, type, slot, line);
            if (value == null) {
                this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.UNDEFINED;
            } else if (value instanceof NativeImageDebugRegisterValue) {
                this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.REGISTER;
            } else if (value instanceof NativeImageDebugStackValue) {
                this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.STACKSLOT;
            } else if (value instanceof NativeImageDebugConstantValue) {
                this.localKind = DebugInfoProvider.DebugLocalValueInfo.LocalKind.CONSTANT;
            }
            this.value = value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NativeImageDebugLocalValueInfo)) {
                return false;
            }
            NativeImageDebugLocalValueInfo that = (NativeImageDebugLocalValueInfo)o;
            if (!this.name().equals(that.name())) {
                return false;
            }
            if (this.line != that.line) {
                return false;
            }
            if (this.localKind != that.localKind) {
                return false;
            }
            switch (this.localKind) {
                case REGISTER: 
                case STACKSLOT: 
                case CONSTANT: {
                    return this.value.equals(that.value);
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.name(), this.value) * 31 + this.line;
        }

        public String toString() {
            switch (this.localKind) {
                case REGISTER: {
                    return "reg[" + this.regIndex() + "]";
                }
                case STACKSLOT: {
                    return "stack[" + this.stackSlot() + "]";
                }
                case CONSTANT: {
                    return "constant[" + (this.constantValue() != null ? this.constantValue().toValueString() : "null") + "]";
                }
            }
            return "-";
        }

        public DebugInfoProvider.DebugLocalValueInfo.LocalKind localKind() {
            return this.localKind;
        }

        public int regIndex() {
            return ((NativeImageDebugRegisterValue)this.value).getNumber();
        }

        public int stackSlot() {
            return ((NativeImageDebugStackValue)this.value).getOffset();
        }

        public long heapOffset() {
            return ((NativeImageDebugConstantValue)this.value).getHeapOffset();
        }

        public JavaConstant constantValue() {
            return ((NativeImageDebugConstantValue)this.value).getConstant();
        }
    }

    class ParamLocationProducer {
        Register[] gpregs;
        Register[] fregs;
        int nextGPRegIdx;
        int nextFPregIdx;
        int nextStackIdx;
        int stackParamCount;
        int stackOffset;

        ParamLocationProducer(ResolvedJavaMethod method) {
            Architecture arch = ConfigurationValues.getTarget().arch;
            assert (arch instanceof AMD64 || arch instanceof AArch64) : "unexpected architecture";
            OS os = OS.getCurrent();
            assert (os == OS.LINUX || os == OS.WINDOWS) : "unexpected os";
            if (arch instanceof AArch64) {
                assert (os == OS.LINUX) : "unexpected os/architecture";
                this.gpregs = AARCH64_GPREG;
                this.fregs = AARCH64_FREG;
                this.stackOffset = 8;
            } else {
                if (os == OS.LINUX) {
                    this.gpregs = AMD64_GPREG_LINUX;
                    this.fregs = AMD64_FREG_LINUX;
                } else {
                    this.gpregs = AMD64_GPREG_WINDOWS;
                    this.fregs = AMD64_FREG_WINDOWS;
                }
                this.stackOffset = 16;
            }
            this.nextGPRegIdx = 0;
            this.nextFPregIdx = 0;
            this.nextStackIdx = 0;
            this.stackParamCount = this.computeStackCount(method);
        }

        public NativeImageDebugLocalValue nextLocation(JavaKind kind) {
            switch (kind) {
                case Float: 
                case Double: {
                    return this.nextFloatingLocation();
                }
                case Void: 
                case Illegal: {
                    assert (false) : "unexpected parameter kind in next location request";
                    return null;
                }
            }
            return this.nextIntegerLocation();
        }

        public NativeImageDebugLocalValue nextFloatingLocation() {
            if (this.nextFPregIdx < this.fregs.length) {
                return NativeImageDebugRegisterValue.create(this.fregs[this.nextFPregIdx++].number);
            }
            return this.nextStackLocation();
        }

        public NativeImageDebugLocalValue nextIntegerLocation() {
            if (this.nextGPRegIdx < this.gpregs.length) {
                return NativeImageDebugRegisterValue.create(this.gpregs[this.nextGPRegIdx++].number);
            }
            return this.nextStackLocation();
        }

        public NativeImageDebugLocalValue nextStackLocation() {
            assert (this.nextStackIdx < this.stackParamCount) : "encountered too many stack params";
            int stackIdx = this.nextStackIdx++;
            return NativeImageDebugStackValue.create(stackIdx * 8 + this.stackOffset);
        }

        public boolean usesStack() {
            return this.stackParamCount > 0;
        }

        private int computeStackCount(ResolvedJavaMethod method) {
            int numIntegerParams = 0;
            int numFloatingParams = 0;
            Signature signature = method.getSignature();
            int parameterCount = signature.getParameterCount(false);
            if (!method.isStatic()) {
                ++numIntegerParams;
            }
            block4: for (int i = 0; i < parameterCount; ++i) {
                switch (signature.getParameterKind(i)) {
                    case Float: 
                    case Double: {
                        ++numFloatingParams;
                        continue block4;
                    }
                    case Void: 
                    case Illegal: {
                        assert (false) : "unexpected parameter kind in method sig";
                        continue block4;
                    }
                    default: {
                        ++numIntegerParams;
                    }
                }
            }
            int excessParams = 0;
            if (numIntegerParams > this.gpregs.length) {
                excessParams += numIntegerParams - this.gpregs.length;
            }
            if (numFloatingParams > this.fregs.length) {
                excessParams += numFloatingParams - this.fregs.length;
            }
            return excessParams;
        }
    }

    private class NativeImageDebugLocationInfo
    extends NativeImageDebugBaseMethodInfo
    implements DebugInfoProvider.DebugLocationInfo {
        private final int bci;
        private int lo;
        private int hi;
        private DebugInfoProvider.DebugLocationInfo callersLocationInfo;
        private List<DebugInfoProvider.DebugLocalValueInfo> localInfoList;
        private boolean isLeaf;

        NativeImageDebugLocationInfo(CompilationResultFrameTree.FrameNode frameNode, NativeImageDebugLocationInfo callersLocationInfo, int framesize) {
            this(frameNode.frame, frameNode.getStartPos(), frameNode.getEndPos() + 1, callersLocationInfo, framesize);
        }

        NativeImageDebugLocationInfo(BytecodePosition bcpos, int lo, int hi, NativeImageDebugLocationInfo callersLocationInfo, int framesize) {
            super(bcpos.getMethod());
            this.bci = bcpos.getBCI();
            this.lo = lo;
            this.hi = hi;
            this.callersLocationInfo = callersLocationInfo;
            this.localInfoList = this.initLocalInfoList(bcpos, framesize);
            this.isLeaf = true;
            if (callersLocationInfo != null) {
                callersLocationInfo.isLeaf = false;
            }
        }

        NativeImageDebugLocationInfo(ResolvedJavaMethod method, int hi, ParamLocationProducer locProducer) {
            super(method);
            this.bci = 0;
            this.lo = 0;
            this.hi = hi;
            this.callersLocationInfo = null;
            this.localInfoList = this.initSyntheticInfoList(locProducer);
            this.isLeaf = true;
        }

        NativeImageDebugLocationInfo(NativeImageDebugLocationInfo toSplit, int stackDecrement, int frameSize) {
            super(toSplit.method);
            this.lo = stackDecrement;
            this.hi = toSplit.hi;
            toSplit.hi = this.lo;
            this.bci = toSplit.bci;
            this.callersLocationInfo = toSplit.callersLocationInfo;
            this.isLeaf = toSplit.isLeaf;
            toSplit.isLeaf = true;
            this.localInfoList = new ArrayList<DebugInfoProvider.DebugLocalValueInfo>(toSplit.localInfoList.size());
            for (DebugInfoProvider.DebugLocalValueInfo localInfo : toSplit.localInfoList) {
                if (localInfo.localKind() == DebugInfoProvider.DebugLocalValueInfo.LocalKind.STACKSLOT) {
                    int newSlot = localInfo.stackSlot() + frameSize;
                    NativeImageDebugStackValue value = NativeImageDebugStackValue.create(newSlot);
                    NativeImageDebugLocalValueInfo nativeLocalInfo = (NativeImageDebugLocalValueInfo)localInfo;
                    NativeImageDebugLocalValueInfo newLocalinfo = new NativeImageDebugLocalValueInfo(nativeLocalInfo.name, value, nativeLocalInfo.kind, nativeLocalInfo.type, nativeLocalInfo.slot, nativeLocalInfo.line);
                    this.localInfoList.add(newLocalinfo);
                    continue;
                }
                this.localInfoList.add(localInfo);
            }
        }

        private List<DebugInfoProvider.DebugLocalValueInfo> initLocalInfoList(BytecodePosition bcpos, int framesize) {
            if (!(bcpos instanceof BytecodeFrame)) {
                return null;
            }
            BytecodeFrame frame = (BytecodeFrame)bcpos;
            if (frame.numLocals == 0) {
                return null;
            }
            LineNumberTable lineNumberTable = frame.getMethod().getLineNumberTable();
            Local[] localsBySlot = this.getLocalsBySlot();
            if (localsBySlot == null) {
                return Collections.emptyList();
            }
            int count = Integer.min(localsBySlot.length, frame.numLocals);
            ArrayList<DebugInfoProvider.DebugLocalValueInfo> localInfos = new ArrayList<DebugInfoProvider.DebugLocalValueInfo>(count);
            for (int i = 0; i < count; ++i) {
                int firstLine;
                Local l = localsBySlot[i];
                if (l == null) continue;
                String name = l.getName();
                ResolvedJavaType ownerType = this.method.getDeclaringClass();
                ResolvedJavaType type = l.getType().resolve(ownerType);
                JavaKind kind = type.getJavaKind();
                int slot = l.getSlot();
                NativeImageDebugInfoProvider.this.debugContext.log(4, "locals[%d] %s type %s slot %d", (Object)i, (Object)name, (Object)type.getName(), (Object)slot);
                AllocatableValue value = slot < frame.numLocals ? frame.getLocalValue(slot) : Value.ILLEGAL;
                JavaKind storageKind = slot < frame.numLocals ? frame.getLocalValueKind(slot) : JavaKind.Illegal;
                NativeImageDebugInfoProvider.this.debugContext.log(4, "  =>  %s kind %s", (Object)value, (Object)storageKind);
                int bciStart = l.getStartBCI();
                int n = firstLine = lineNumberTable != null ? lineNumberTable.getLineNumber(bciStart) : -1;
                if (storageKind == kind || NativeImageDebugInfoProvider.isIntegralKindPromotion(storageKind, kind) || NativeImageDebugInfoProvider.this.isForeignWordType((JavaType)type, ownerType) && kind == JavaKind.Object && storageKind == JavaKind.Long) {
                    localInfos.add(new NativeImageDebugLocalValueInfo(name, (JavaValue)value, framesize, storageKind, type, slot, firstLine));
                    continue;
                }
                if (storageKind == JavaKind.Illegal) continue;
                NativeImageDebugInfoProvider.this.debugContext.log(4, "  value kind incompatible with var kind %s!", (Object)type.getJavaKind());
            }
            return localInfos;
        }

        private List<DebugInfoProvider.DebugLocalValueInfo> initSyntheticInfoList(ParamLocationProducer locProducer) {
            Signature signature = this.method.getSignature();
            int parameterCount = signature.getParameterCount(false);
            ArrayList<DebugInfoProvider.DebugLocalValueInfo> localInfos = new ArrayList<DebugInfoProvider.DebugLocalValueInfo>();
            LocalVariableTable table = this.method.getLocalVariableTable();
            LineNumberTable lineNumberTable = this.method.getLineNumberTable();
            int firstLine = lineNumberTable != null ? lineNumberTable.getLineNumber(0) : -1;
            int slot = 0;
            int localIdx = 0;
            ResolvedJavaType ownerType = this.method.getDeclaringClass();
            if (!this.method.isStatic()) {
                JavaKind storageKind;
                String name = "this";
                JavaKind kind = ownerType.getJavaKind();
                JavaKind javaKind = storageKind = NativeImageDebugInfoProvider.this.isForeignWordType((JavaType)ownerType, ownerType) ? JavaKind.Long : kind;
                assert (kind == JavaKind.Object) : "must be an object";
                NativeImageDebugLocalValue value = locProducer.nextLocation(kind);
                NativeImageDebugInfoProvider.this.debugContext.log(4, "locals[%d] %s type %s slot %d", (Object)localIdx, (Object)name, (Object)ownerType.getName(), (Object)slot);
                NativeImageDebugInfoProvider.this.debugContext.log(4, "  =>  %s kind %s", (Object)value, (Object)storageKind);
                localInfos.add(new NativeImageDebugLocalValueInfo(name, value, storageKind, ownerType, slot, firstLine));
                slot += storageKind.getSlotCount();
                ++localIdx;
            }
            for (int i = 0; i < parameterCount; ++i) {
                Local local = table == null ? null : table.getLocal(slot, 0);
                Object name = local != null ? local.getName() : "__" + i;
                ResolvedJavaType paramType = (ResolvedJavaType)signature.getParameterType(i, ownerType);
                JavaKind kind = paramType.getJavaKind();
                JavaKind storageKind = NativeImageDebugInfoProvider.this.isForeignWordType((JavaType)paramType, ownerType) ? JavaKind.Long : kind;
                NativeImageDebugLocalValue value = locProducer.nextLocation(kind);
                NativeImageDebugInfoProvider.this.debugContext.log(4, "locals[%d] %s type %s slot %d", (Object)localIdx, name, (Object)ownerType.getName(), (Object)slot);
                NativeImageDebugInfoProvider.this.debugContext.log(4, "  =>  %s kind %s", (Object)value, (Object)storageKind);
                localInfos.add(new NativeImageDebugLocalValueInfo((String)name, value, storageKind, paramType, slot, firstLine));
                slot += storageKind.getSlotCount();
                ++localIdx;
            }
            return localInfos;
        }

        private Local[] getLocalsBySlot() {
            Local[] locals;
            LocalVariableTable lvt = this.method.getLocalVariableTable();
            Local[] nonEmptySortedLocals = null;
            if (lvt != null && (locals = lvt.getLocalsAt(this.bci)) != null && locals.length > 0) {
                nonEmptySortedLocals = Arrays.copyOf(locals, locals.length);
                Arrays.sort(nonEmptySortedLocals, (l1, l2) -> l1.getSlot() - l2.getSlot());
            }
            return nonEmptySortedLocals;
        }

        public int addressLo() {
            return this.lo;
        }

        public int addressHi() {
            return this.hi;
        }

        public int line() {
            LineNumberTable lineNumberTable = this.method.getLineNumberTable();
            if (lineNumberTable != null && this.bci >= 0) {
                return lineNumberTable.getLineNumber(this.bci);
            }
            return -1;
        }

        public DebugInfoProvider.DebugLocationInfo getCaller() {
            return this.callersLocationInfo;
        }

        public DebugInfoProvider.DebugLocalValueInfo[] getLocalValueInfo() {
            if (this.localInfoList != null) {
                return this.localInfoList.toArray(new DebugInfoProvider.DebugLocalValueInfo[this.localInfoList.size()]);
            }
            return EMPTY_LOCAL_VALUE_INFOS;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public int depth() {
            int depth = 1;
            for (DebugInfoProvider.DebugLocationInfo caller = this.getCaller(); caller != null; caller = caller.getCaller()) {
                ++depth;
            }
            return depth;
        }

        private int localsSize() {
            if (this.localInfoList != null) {
                return this.localInfoList.size();
            }
            return 0;
        }

        NativeImageDebugLocationInfo merge(NativeImageDebugLocationInfo that) {
            assert (this.callersLocationInfo == that.callersLocationInfo);
            assert (this.isLeaf == that.isLeaf);
            assert (this.depth() == that.depth()) : "should only compare sibling ranges";
            assert (this.hi <= that.lo) : "later nodes should not overlap earlier ones";
            if (this.hi != that.lo) {
                return null;
            }
            if (!this.method.equals(that.method)) {
                return null;
            }
            if (this.line() != that.line()) {
                return null;
            }
            int size = this.localsSize();
            if (size != that.localsSize()) {
                return null;
            }
            for (int i = 0; i < size; ++i) {
                NativeImageDebugLocalValueInfo thatLocal;
                NativeImageDebugLocalValueInfo thisLocal = (NativeImageDebugLocalValueInfo)this.localInfoList.get(i);
                if (thisLocal.equals(thatLocal = (NativeImageDebugLocalValueInfo)that.localInfoList.get(i))) continue;
                return null;
            }
            NativeImageDebugInfoProvider.this.debugContext.log(4, "Merge  leaf Location Info : %s depth %d (%d, %d) into (%d, %d)", (Object)that.name(), (Object)that.depth(), (Object)that.lo, (Object)(that.hi - 1), (Object)this.lo, (Object)(this.hi - 1));
            this.hi = that.hi;
            return this;
        }

        public NativeImageDebugLocationInfo split(int stackDecrement, int adjustment) {
            assert (this.lo == 0 && this.lo < stackDecrement && stackDecrement < this.hi) : "invalid split request";
            return new NativeImageDebugLocationInfo(this, stackDecrement, adjustment);
        }
    }

    protected abstract class NativeImageDebugHostedMethodInfo
    extends NativeImageDebugBaseMethodInfo {
        protected final HostedMethod hostedMethod;

        NativeImageDebugHostedMethodInfo(HostedMethod method) {
            super(method);
            this.hostedMethod = method;
        }

        public int line() {
            return this.line;
        }

        @Override
        public boolean isVirtual() {
            return this.hostedMethod.hasVTableIndex();
        }

        @Override
        public int vtableOffset() {
            return this.hostedMethod.hasVTableIndex() ? this.hostedMethod.getVTableIndex() : -1;
        }

        @Override
        public boolean isOverride() {
            return NativeImageDebugInfoProvider.this.allOverrides.contains(this.hostedMethod);
        }
    }

    protected abstract class NativeImageDebugBaseMethodInfo
    extends NativeImageDebugFileInfo
    implements DebugInfoProvider.DebugMethodInfo {
        protected final ResolvedJavaMethod method;
        protected int line;
        protected final List<DebugInfoProvider.DebugLocalInfo> paramInfo;
        protected final DebugInfoProvider.DebugLocalInfo thisParamInfo;

        NativeImageDebugBaseMethodInfo(ResolvedJavaMethod m) {
            super(m);
            this.method = this.promoteAnalysisToHosted(m);
            LineNumberTable lineNumberTable = this.method.getLineNumberTable();
            this.line = lineNumberTable != null ? lineNumberTable.getLineNumber(0) : 0;
            this.paramInfo = NativeImageDebugInfoProvider.this.createParamInfo(this.method, this.line);
            this.thisParamInfo = Modifier.isStatic(this.modifiers()) ? null : this.paramInfo.remove(0);
        }

        private ResolvedJavaMethod promoteAnalysisToHosted(ResolvedJavaMethod m) {
            if (m instanceof AnalysisMethod) {
                return NativeImageDebugInfoProvider.this.heap.hUniverse.lookup((JavaMethod)m);
            }
            if (!(m instanceof HostedMethod)) {
                NativeImageDebugInfoProvider.this.debugContext.log(4, "Method is neither Hosted nor Analysis : %s.%s%s", (Object)m.getDeclaringClass().getName(), (Object)m.getName(), (Object)m.getSignature().toMethodDescriptor());
            }
            return m;
        }

        private ResolvedJavaMethod originalMethod() {
            ResolvedJavaMethod targetMethod = this.method;
            while (targetMethod instanceof WrappedJavaMethod) {
                targetMethod = ((WrappedJavaMethod)targetMethod).getWrapped();
            }
            if (targetMethod instanceof SubstitutionMethod) {
                targetMethod = ((SubstitutionMethod)targetMethod).getOriginal();
            }
            return targetMethod;
        }

        public ResolvedJavaType ownerType() {
            ResolvedJavaType result = this.method instanceof HostedMethod ? NativeImageDebugInfoProviderBase.getDeclaringClass((HostedMethod)this.method, true) : this.method.getDeclaringClass();
            while (result instanceof WrappedJavaType) {
                result = ((WrappedJavaType)result).getWrapped();
            }
            return result;
        }

        public ResolvedJavaMethod idMethod() {
            return this.originalMethod();
        }

        public String name() {
            ResolvedJavaMethod targetMethod = this.originalMethod();
            String name = targetMethod.getName();
            if (name.equals("<init>")) {
                if (this.method instanceof HostedMethod) {
                    name = NativeImageDebugInfoProviderBase.getDeclaringClass((HostedMethod)this.method, true).toJavaName();
                    if (name.indexOf(46) >= 0) {
                        name = name.substring(name.lastIndexOf(46) + 1);
                    }
                    if (name.indexOf(36) >= 0) {
                        name = name.substring(name.lastIndexOf(36) + 1);
                    }
                } else {
                    name = targetMethod.format("%h");
                    if (name.indexOf(36) >= 0) {
                        name = name.substring(name.lastIndexOf(36) + 1);
                    }
                }
            }
            return name;
        }

        public ResolvedJavaType valueType() {
            ResolvedJavaType resultType = (ResolvedJavaType)this.method.getSignature().getReturnType(null);
            if (resultType instanceof HostedType) {
                return NativeImageDebugInfoProviderBase.getOriginal((HostedType)resultType);
            }
            return resultType;
        }

        public DebugInfoProvider.DebugLocalInfo[] getParamInfo() {
            return this.paramInfo.toArray(new DebugInfoProvider.DebugLocalInfo[this.paramInfo.size()]);
        }

        public DebugInfoProvider.DebugLocalInfo getThisParamInfo() {
            return this.thisParamInfo;
        }

        public String symbolNameForMethod() {
            return NativeImage.localSymbolNameForMethod(this.method);
        }

        public boolean isDeoptTarget() {
            if (this.method instanceof HostedMethod) {
                return ((HostedMethod)this.method).isDeoptTarget();
            }
            return this.name().endsWith("%%");
        }

        public int modifiers() {
            if (this.method instanceof HostedMethod) {
                return NativeImageDebugInfoProviderBase.getOriginalModifiers((HostedMethod)this.method);
            }
            return this.method.getModifiers();
        }

        public boolean isConstructor() {
            return this.method.isConstructor();
        }

        public boolean isVirtual() {
            return this.method instanceof HostedMethod && ((HostedMethod)this.method).hasVTableIndex();
        }

        public boolean isOverride() {
            return this.method instanceof HostedMethod && NativeImageDebugInfoProvider.this.allOverrides.contains(this.method);
        }

        public int vtableOffset() {
            return this.isVirtual() ? ((HostedMethod)this.method).getVTableIndex() : -1;
        }
    }

    private class NativeImageDebugForeignFieldInfo
    extends NativeImageDebugFileInfo
    implements DebugInfoProvider.DebugFieldInfo {
        StructFieldInfo structFieldInfo;

        NativeImageDebugForeignFieldInfo(HostedType hostedType, StructFieldInfo structFieldInfo) {
            super(hostedType);
            this.structFieldInfo = structFieldInfo;
        }

        public int size() {
            return this.structFieldInfo.getSizeInfo().getProperty();
        }

        public int offset() {
            return this.structFieldInfo.getOffsetInfo().getProperty();
        }

        public String name() {
            return this.structFieldInfo.getName();
        }

        public ResolvedJavaType valueType() {
            return NativeImageDebugInfoProviderBase.getOriginal(NativeImageDebugInfoProvider.this.getFieldType(this.structFieldInfo));
        }

        public boolean isEmbedded() {
            return NativeImageDebugInfoProviderBase.fieldTypeIsEmbedded(this.structFieldInfo);
        }

        public int modifiers() {
            return 0;
        }
    }

    private class NativeImageDebugHeaderFieldInfo
    implements DebugInfoProvider.DebugFieldInfo {
        private final String name;
        private final ResolvedJavaType valueType;
        private final int offset;
        private final int size;
        private final int modifiers;

        NativeImageDebugHeaderFieldInfo(String name, ResolvedJavaType valueType, int offset, int size) {
            this.name = name;
            this.valueType = valueType;
            this.offset = offset;
            this.size = size;
            this.modifiers = 1;
        }

        public String name() {
            return this.name;
        }

        public ResolvedJavaType valueType() {
            if (this.valueType instanceof HostedType) {
                return NativeImageDebugInfoProviderBase.getOriginal((HostedType)this.valueType);
            }
            return this.valueType;
        }

        public int offset() {
            return this.offset;
        }

        public int size() {
            return this.size;
        }

        public boolean isEmbedded() {
            return false;
        }

        public int modifiers() {
            return this.modifiers;
        }

        public String fileName() {
            return "";
        }

        public Path filePath() {
            return null;
        }
    }

    private abstract class NativeImageDebugTypeInfo
    extends NativeImageDebugFileInfo
    implements DebugInfoProvider.DebugTypeInfo {
        protected final HostedType hostedType;

        protected NativeImageDebugTypeInfo(HostedType hostedType) {
            super(hostedType);
            this.hostedType = hostedType;
        }

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugTypeInfo", (Object)this.typeName());){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public String toJavaName(HostedType hostedType) {
            return NativeImageDebugInfoProviderBase.getDeclaringClass(hostedType, true).toJavaName();
        }

        public ResolvedJavaType idType() {
            return NativeImageDebugInfoProviderBase.getOriginal(this.hostedType);
        }

        public String typeName() {
            return this.toJavaName(this.hostedType);
        }

        public long classOffset() {
            NativeImageHeap.ObjectInfo objectInfo = NativeImageDebugInfoProvider.this.heap.getObjectInfo(this.hostedType.getHub());
            if (objectInfo != null) {
                return objectInfo.getOffset();
            }
            return -1L;
        }

        public int size() {
            if (this.hostedType instanceof HostedInstanceClass) {
                return ((HostedInstanceClass)this.hostedType).getInstanceSize();
            }
            if (this.hostedType instanceof HostedArrayClass) {
                return NativeImageDebugInfoProviderBase.getObjectLayout().getArrayBaseOffset(this.hostedType.getComponentType().getStorageKind());
            }
            if (this.hostedType instanceof HostedInterface) {
                return NativeImageDebugInfoProviderBase.getObjectLayout().getFirstFieldOffset();
            }
            assert (this.hostedType instanceof HostedPrimitiveType);
            JavaKind javaKind = this.hostedType.getStorageKind();
            return javaKind == JavaKind.Void ? 0 : javaKind.getByteCount();
        }
    }

    private abstract class NativeImageDebugFileInfo
    implements DebugInfoProvider.DebugFileInfo {
        private final Path fullFilePath;

        NativeImageDebugFileInfo(HostedType hostedType) {
            ResolvedJavaType javaType = NativeImageDebugInfoProviderBase.getDeclaringClass(hostedType, false);
            Class<?> clazz = hostedType.getJavaClass();
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugFileInfo", (Object)hostedType);){
                Path filePath = sourceManager.findAndCacheSource(javaType, clazz, NativeImageDebugInfoProvider.this.debugContext);
                if (filePath == null && (hostedType instanceof HostedInstanceClass || hostedType instanceof HostedInterface)) {
                    filePath = NativeImageDebugInfoProviderBase.fullFilePathFromClassName(hostedType);
                }
                this.fullFilePath = filePath;
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        NativeImageDebugFileInfo(ResolvedJavaMethod method) {
            ResolvedJavaType javaType = method instanceof HostedMethod ? NativeImageDebugInfoProviderBase.getDeclaringClass((HostedMethod)method, false) : method.getDeclaringClass();
            Class clazz = null;
            if (javaType instanceof OriginalClassProvider) {
                clazz = ((OriginalClassProvider)javaType).getJavaClass();
            }
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugFileInfo", (Object)javaType);){
                this.fullFilePath = sourceManager.findAndCacheSource(javaType, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        NativeImageDebugFileInfo(HostedField hostedField) {
            ResolvedJavaType javaType = NativeImageDebugInfoProviderBase.getDeclaringClass(hostedField, false);
            HostedType hostedType = hostedField.getDeclaringClass();
            Class<?> clazz = hostedType.getJavaClass();
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugFileInfo", (Object)hostedType);){
                this.fullFilePath = sourceManager.findAndCacheSource(javaType, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public String fileName() {
            Path filename;
            if (this.fullFilePath != null && (filename = this.fullFilePath.getFileName()) != null) {
                return filename.toString();
            }
            return "";
        }

        public Path filePath() {
            if (this.fullFilePath != null) {
                return this.fullFilePath.getParent();
            }
            return null;
        }
    }
}

