/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.code.SubstrateCompilationIdentifier;
import com.oracle.svm.core.graal.replacements.SubstrateGraphKit;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.phases.util.Providers;

public class HostedGraphKit
extends SubstrateGraphKit {
    public HostedGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method, GraphProvider.Purpose purpose) {
        super(debug, method, (Providers)providers, providers.getWordTypes(), providers.getGraphBuilderPlugins(), new SubstrateCompilationIdentifier(), purpose == GraphProvider.Purpose.ANALYSIS, SubstrateCompilationDirectives.isRuntimeCompiledMethod(method));
    }

    @Override
    protected MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, int bci) {
        ResolvedJavaMethod method = this.graph.method();
        if (method instanceof HostedMethod) {
            StaticAnalysisResults profilingInfo = ((HostedMethod)method).getProfilingInfo();
            return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, profilingInfo.getTypeProfile(bci), profilingInfo.getMethodProfile(bci), profilingInfo.getStaticTypeProfile(bci));
        }
        return super.createMethodCallTarget(invokeKind, targetMethod, args, returnStamp, bci);
    }

    public void emitEnsureInitializedCall(ResolvedJavaType type) {
        if (EnsureClassInitializedNode.needsRuntimeInitialization(this.graph.method().getDeclaringClass(), type)) {
            ConstantNode hub = this.createConstant((Constant)this.getConstantReflection().asJavaClass(type), JavaKind.Object);
            this.appendWithUnwind(new EnsureClassInitializedNode((ValueNode)hub));
        }
    }

    public <T extends WithExceptionNode> T appendWithUnwind(T withExceptionNode) {
        return this.appendWithUnwind(withExceptionNode, this.bci());
    }

    public LoadFieldNode createLoadFieldNode(ConstantNode receiver, Class<BoxedRelocatedPointer> clazz, String fieldName) {
        try {
            ResolvedJavaField field = this.getMetaAccess().lookupJavaField(clazz.getDeclaredField(fieldName));
            return LoadFieldNode.createOverrideStamp((StampPair)StampPair.createSingle((Stamp)this.wordStamp((ResolvedJavaType)field.getType())), (ValueNode)receiver, (ResolvedJavaField)field);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public GuardingNode createCheckThrowingBytecodeException(LogicNode condition, boolean failOnTrue, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... arguments) {
        ProfileData.BranchProbabilityData trueProbability = failOnTrue ? BranchProbabilityNode.SLOW_PATH_PROFILE : BranchProbabilityNode.FAST_PATH_PROFILE;
        IfNode ifNode = this.startIf(condition, trueProbability);
        if (failOnTrue) {
            this.thenPart();
        } else {
            this.elsePart();
        }
        BytecodeExceptionNode exception = this.createBytecodeExceptionObjectNode(exceptionKind, true, arguments);
        this.append((Node)new UnwindNode((ValueNode)exception));
        AbstractMergeNode merge = this.endIf();
        assert (merge == null);
        return failOnTrue ? ifNode.falseSuccessor() : ifNode.trueSuccessor();
    }

    public BytecodeExceptionNode createBytecodeExceptionObjectNode(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, boolean rethrow, ValueNode ... arguments) {
        BytecodeExceptionNode exception = (BytecodeExceptionNode)this.append((Node)new BytecodeExceptionNode(this.getMetaAccess(), exceptionKind, arguments));
        this.setStateAfterException(this.getFrameState(), this.bci(), (StateSplit)exception, rethrow);
        return exception;
    }

    public ValueNode maybeCreateExplicitNullCheck(ValueNode object) {
        assert (object.stamp(NodeView.DEFAULT).isPointerStamp());
        if (StampTool.isPointerNonNull((ValueNode)object)) {
            return object;
        }
        this.createCheckThrowingBytecodeException(IsNullNode.create((ValueNode)object), true, BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ValueNode[0]);
        return (ValueNode)this.append((Node)PiNode.create((ValueNode)object, (Stamp)StampFactory.objectNonNull()));
    }

    public List<ValueNode> loadArrayElements(ValueNode array, JavaKind[] elementKinds, int length) {
        assert (elementKinds.length == length);
        ArrayList<ValueNode> result = new ArrayList<ValueNode>();
        for (int i = 0; i < length; ++i) {
            ValueNode load = this.createLoadIndexed(array, i, elementKinds[i], null);
            this.append((Node)load);
            result.add(load);
        }
        return result;
    }

    public List<ValueNode> loadArrayElements(ValueNode array, JavaKind elementKind, int length) {
        Object[] elementKinds = new JavaKind[length];
        Arrays.fill(elementKinds, elementKind);
        return this.loadArrayElements(array, (JavaKind[])elementKinds, length);
    }
}

