/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.constraints.TypeInstantiationException;
import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.graal.nodes.DeoptEntryBeginNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptEntrySupport;
import com.oracle.svm.core.graal.nodes.DeoptProxyAnchorNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.DeoptimizationTargetBciBlockMapping;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.LambdaConversionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.word.WordTypes;

public abstract class SharedGraphBuilderPhase
extends GraphBuilderPhase.Instance {
    final WordTypes wordTypes;

    public SharedGraphBuilderPhase(CoreProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes) {
        super(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        this.wordTypes = wordTypes;
    }

    protected void run(StructuredGraph graph) {
        super.run(graph);
        assert (this.wordTypes == null || this.wordTypes.ensureGraphContainsNoWordTypeReferences(graph));
    }

    public static abstract class SharedBytecodeParser
    extends BytecodeParser {
        private int currentDeoptIndex;
        private final boolean explicitExceptionEdges;
        private final boolean linkAtBuildTime;

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges) {
            this(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, explicitExceptionEdges, LinkAtBuildTimeSupport.singleton().linkAtBuildTime(method.getDeclaringClass()));
        }

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges, boolean linkAtBuildTime) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
            this.explicitExceptionEdges = explicitExceptionEdges;
            this.linkAtBuildTime = linkAtBuildTime;
        }

        protected BciBlockMapping generateBlockMap() {
            if (SharedBytecodeParser.isDeoptimizationEnabled() && this.isMethodDeoptTarget()) {
                return DeoptimizationTargetBciBlockMapping.create(this.stream, this.code, this.options, this.graph.getDebug(), false);
            }
            return BciBlockMapping.create((BytecodeStream)this.stream, (Bytecode)this.code, (OptionValues)this.options, (DebugContext)this.graph.getDebug(), (boolean)this.asyncExceptionLiveness());
        }

        protected boolean shouldVerifyFrameStates() {
            return false;
        }

        protected void build(FixedWithNextNode startInstruction, FrameStateBuilder startFrameState) {
            if (!this.shouldVerifyFrameStates()) {
                startFrameState.disableStateVerification();
            }
            super.build(startInstruction, startFrameState);
            if (this.isMethodDeoptTarget()) {
                for (DeoptProxyNode deoptProxy : this.graph.getNodes(DeoptProxyNode.TYPE)) {
                    assert (deoptProxy.hasProxyPoint());
                }
            }
        }

        protected RuntimeException throwParserError(Throwable e) {
            if (e instanceof UserError.UserException) {
                throw (UserError.UserException)e;
            }
            if (e instanceof UnsupportedFeatureException) {
                throw (UnsupportedFeatureException)e;
            }
            throw super.throwParserError(e);
        }

        private WordTypes getWordTypes() {
            return ((SharedGraphBuilderPhase)this.getGraphBuilderInstance()).wordTypes;
        }

        private boolean checkWordTypes() {
            return this.getWordTypes() != null;
        }

        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.getSource().equals(Fold.class) || plugin.getSource().equals(Node.NodeIntrinsic.class);
        }

        protected JavaMethod lookupMethodInPool(int cpi, int opcode) {
            JavaMethod result = super.lookupMethodInPool(cpi, opcode);
            if (result == null) {
                throw VMError.shouldNotReachHere("Discovered an unresolved callee while parsing " + this.method.asStackTraceElement(this.bci()) + ".");
            }
            return result;
        }

        protected Object lookupConstant(int cpi, int opcode, boolean allowBootstrapMethodInvocation) {
            try {
                return super.lookupConstant(cpi, opcode, true);
            }
            catch (BootstrapMethodError | IllegalArgumentException | IncompatibleClassChangeError ex) {
                if (this.linkAtBuildTime) {
                    this.reportUnresolvedElement("constant", this.method.format("%H.%n(%P)"), ex);
                } else {
                    SharedBytecodeParser.replaceWithThrowingAtRuntime(this, ex);
                }
                return ex;
            }
        }

        protected Object loadReferenceTypeLock() {
            return null;
        }

        protected void maybeEagerlyResolve(int cpi, int bytecode) {
            block2: {
                try {
                    super.maybeEagerlyResolve(cpi, bytecode);
                }
                catch (UnresolvedElementException e) {
                    if (e.getCause() instanceof LambdaConversionException || e.getCause() instanceof LinkageError || e.getCause() instanceof IllegalAccessError) break block2;
                    throw e;
                }
            }
        }

        protected JavaType maybeEagerlyResolve(JavaType type, ResolvedJavaType accessingClass) {
            try {
                return super.maybeEagerlyResolve(type, accessingClass);
            }
            catch (LinkageError e) {
                return this.getMetaAccess().lookupJavaType(Object.class);
            }
        }

        protected void handleIllegalNewInstance(JavaType type) {
            if (this.linkAtBuildTime) {
                String message = "Cannot instantiate " + type.toJavaName() + ". " + LinkAtBuildTimeSupport.singleton().errorMessageFor(this.method.getDeclaringClass());
                throw new TypeInstantiationException(message);
            }
            ExceptionSynthesizer.throwException((GraphBuilderContext)this, InstantiationError.class, type.toJavaName());
        }

        protected void handleUnresolvedNewInstance(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewObjectArray(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewMultiArray(JavaType type) {
            this.handleUnresolvedType(type.getElementalType());
        }

        protected void handleUnresolvedInstanceOf(JavaType type, ValueNode object) {
            BeginNode nullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            BeginNode nonNullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            this.append((Node)new IfNode((LogicNode)this.graph.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)object)), (AbstractBeginNode)nullObj, (AbstractBeginNode)nonNullObj, BranchProbabilityNode.NOT_FREQUENT_PROFILE));
            this.lastInstr = nonNullObj;
            this.handleUnresolvedType(type);
            this.lastInstr = nullObj;
            this.frameState.push(JavaKind.Int, (ValueNode)this.appendConstant((JavaConstant)JavaConstant.INT_0));
        }

        protected void handleUnresolvedCheckCast(JavaType type, ValueNode object) {
            BeginNode nullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            BeginNode nonNullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            this.append((Node)new IfNode((LogicNode)this.graph.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)object)), (AbstractBeginNode)nullObj, (AbstractBeginNode)nonNullObj, BranchProbabilityNode.NOT_FREQUENT_PROFILE));
            this.lastInstr = nonNullObj;
            this.handleUnresolvedType(type);
            this.lastInstr = nullObj;
            this.frameState.push(JavaKind.Object, (ValueNode)this.appendConstant(JavaConstant.NULL_POINTER));
        }

        protected void handleUnresolvedLoadConstant(JavaType unresolvedType) {
            this.handleUnresolvedType(unresolvedType);
        }

        protected void handleUnresolvedExceptionType(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedStoreField(JavaField field) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedLoadField(JavaField field) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedInvoke(JavaMethod javaMethod, CallTargetNode.InvokeKind invokeKind) {
            this.handleUnresolvedMethod(javaMethod);
        }

        public static <T extends Throwable> void replaceWithThrowingAtRuntime(SharedBytecodeParser b, T throwable) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                UniverseMetaAccess metaAccess = (UniverseMetaAccess)b.getMetaAccess();
                Constructor causeCtor = ReflectionUtil.lookupConstructor(cause.getClass(), (Class[])new Class[]{String.class});
                ResolvedJavaMethod causeCtorMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)causeCtor), false);
                ConstantNode causeMessageNode = ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(cause.getMessage()), (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph());
                Invoke causeCtorInvoke = (Invoke)b.appendInvoke(CallTargetNode.InvokeKind.Static, causeCtorMethod, new ValueNode[]{causeMessageNode}, null);
                Constructor errorCtor = ReflectionUtil.lookupConstructor(throwable.getClass(), (Class[])new Class[]{String.class, Throwable.class});
                ResolvedJavaMethod throwingMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)errorCtor), true);
                ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(throwable.getMessage()), (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph());
                boolean verifyStates = b.getFrameStateBuilder().disableStateVerification();
                b.appendInvoke(CallTargetNode.InvokeKind.Static, throwingMethod, new ValueNode[]{messageNode, causeCtorInvoke.asNode()}, null);
                b.getFrameStateBuilder().setStateVerification(verifyStates);
                b.add((Node)new LoweredDeadEndNode());
            } else {
                SharedBytecodeParser.replaceWithThrowingAtRuntime(b, throwable.getClass(), throwable.getMessage());
            }
        }

        public static void replaceWithThrowingAtRuntime(SharedBytecodeParser b, Class<? extends Throwable> throwableClass, String throwableMessage) {
            Constructor errorCtor = ReflectionUtil.lookupConstructor(throwableClass, (Class[])new Class[]{String.class});
            UniverseMetaAccess metaAccess = (UniverseMetaAccess)b.getMetaAccess();
            ResolvedJavaMethod throwingMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)errorCtor), true);
            ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(throwableMessage), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
            boolean verifyStates = b.getFrameStateBuilder().disableStateVerification();
            b.appendInvoke(CallTargetNode.InvokeKind.Static, throwingMethod, new ValueNode[]{messageNode}, null);
            b.getFrameStateBuilder().setStateVerification(verifyStates);
            b.add((Node)new LoweredDeadEndNode());
        }

        private void handleUnresolvedType(JavaType type) {
            if (this.linkAtBuildTime) {
                this.reportUnresolvedElement("type", type.toJavaName());
            } else {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, NoClassDefFoundError.class, type.toJavaName());
            }
        }

        private void handleUnresolvedField(JavaField field) {
            JavaType declaringClass = field.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (this.linkAtBuildTime) {
                this.reportUnresolvedElement("field", field.format("%H.%n"));
            } else {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, NoSuchFieldError.class, field.format("%H.%n"));
            }
        }

        private void handleUnresolvedMethod(JavaMethod javaMethod) {
            JavaType declaringClass = javaMethod.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (this.linkAtBuildTime) {
                this.reportUnresolvedElement("method", javaMethod.format("%H.%n(%P)"));
            } else {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, SharedBytecodeParser.findResolutionError((ResolvedJavaType)declaringClass, javaMethod), javaMethod.format("%H.%n(%P)"));
            }
        }

        private static Class<? extends IncompatibleClassChangeError> findResolutionError(ResolvedJavaType declaringType, JavaMethod searchMethod) {
            Class declaringClass;
            Object[] searchSignature = SharedBytecodeParser.signatureToClasses(searchMethod);
            Class searchReturnType = null;
            if (searchMethod.getSignature().getReturnType(null) instanceof ResolvedJavaType) {
                searchReturnType = OriginalClassProvider.getJavaClass((ResolvedJavaType)((ResolvedJavaType)searchMethod.getSignature().getReturnType(null)));
            }
            for (Class cur = declaringClass = OriginalClassProvider.getJavaClass((ResolvedJavaType)declaringType); cur != null; cur = cur.getSuperclass()) {
                Executable[] methods = null;
                try {
                    methods = searchMethod.getName().equals("<init>") ? cur.getDeclaredConstructors() : cur.getDeclaredMethods();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (methods != null) {
                    for (Constructor<?> constructor : methods) {
                        if (!Arrays.equals(searchSignature, ((Executable)constructor).getParameterTypes()) || !(constructor instanceof Constructor) && (!searchMethod.getName().equals(((Executable)constructor).getName()) || searchReturnType != ((Method)((Object)constructor)).getReturnType())) continue;
                        if (Modifier.isAbstract(((Executable)constructor).getModifiers())) {
                            return AbstractMethodError.class;
                        }
                        return IllegalAccessError.class;
                    }
                }
                if (searchMethod.getName().equals("<init>")) break;
            }
            return NoSuchMethodError.class;
        }

        private static Class<?>[] signatureToClasses(JavaMethod method) {
            int paramCount = method.getSignature().getParameterCount(false);
            Class[] result = new Class[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                JavaType parameterType = method.getSignature().getParameterType(0, null);
                if (!(parameterType instanceof ResolvedJavaType)) continue;
                result[i] = OriginalClassProvider.getJavaClass((ResolvedJavaType)((ResolvedJavaType)parameterType));
            }
            return result;
        }

        private void reportUnresolvedElement(String elementKind, String elementAsString) {
            this.reportUnresolvedElement(elementKind, elementAsString, null);
        }

        private void reportUnresolvedElement(String elementKind, String elementAsString, Throwable cause) {
            String message = "Discovered unresolved " + elementKind + " during parsing: " + elementAsString + ". " + LinkAtBuildTimeSupport.singleton().errorMessageFor(this.method.getDeclaringClass());
            throw new UnresolvedElementException(message, cause);
        }

        protected void emitCheckForInvokeSuperSpecial(ValueNode[] args) {
        }

        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        protected void genIf(ValueNode x, Condition cond, ValueNode y) {
            if (this.checkWordTypes() && (x.getStackKind() == JavaKind.Object && y.getStackKind() == this.getWordTypes().getWordKind() || x.getStackKind() == this.getWordTypes().getWordKind() && y.getStackKind() == JavaKind.Object)) {
                throw UserError.abort("Should not compare Word to Object in condition at %s in %s", this.method, this.method.asStackTraceElement(this.bci()));
            }
            super.genIf(x, cond, y);
        }

        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
            boolean isStatic = targetMethod.isStatic();
            if (!isStatic) {
                this.checkWordType(args[0], (JavaType)targetMethod.getDeclaringClass(), "call receiver");
            }
            for (int i = 0; i < targetMethod.getSignature().getParameterCount(false); ++i) {
                this.checkWordType(args[i + (isStatic ? 0 : 1)], targetMethod.getSignature().getParameterType(i, null), "call argument");
            }
            return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, profile, null, profile);
        }

        protected void genReturn(ValueNode returnVal, JavaKind returnKind) {
            this.checkWordType(returnVal, this.method.getSignature().getReturnType(null), "return value");
            super.genReturn(returnVal, returnKind);
        }

        private void checkWordType(ValueNode value, JavaType expectedType, String reason) {
            if (expectedType.getJavaKind() == JavaKind.Object && this.checkWordTypes()) {
                boolean isWordValue;
                boolean isWordTypeExpected = this.getWordTypes().isWord(expectedType);
                boolean bl = isWordValue = value.getStackKind() == this.getWordTypes().getWordKind();
                if (isWordTypeExpected && !isWordValue) {
                    throw UserError.abort("Expected Word but got Object for %s in %s", reason, this.method.asStackTraceElement(this.bci()));
                }
                if (!isWordTypeExpected && isWordValue) {
                    throw UserError.abort("Expected Object but got Word for %s in %s. One possible cause for this error is when word values are passed into lambdas as parameters or from variables in an enclosing scope, which is not supported, but can be solved by instead using explicit classes (including anonymous classes).", reason, this.method.asStackTraceElement(this.bci()));
                }
            }
        }

        protected boolean needsExplicitNullCheckException(ValueNode object) {
            return this.needsExplicitException() && object.getStackKind() == JavaKind.Object;
        }

        protected boolean needsExplicitStoreCheckException(ValueNode array, ValueNode value) {
            return this.needsExplicitException() && value.getStackKind() == JavaKind.Object;
        }

        public boolean needsExplicitException() {
            return this.explicitExceptionEdges && !this.parsingIntrinsic();
        }

        protected boolean needsIncompatibleClassChangeErrorCheck() {
            return !this.parsingIntrinsic();
        }

        protected boolean needsExplicitIncompatibleClassChangeError() {
            return this.needsExplicitException();
        }

        public boolean isPluginEnabled(GraphBuilderPlugin plugin) {
            return true;
        }

        protected static boolean isDeoptimizationEnabled() {
            return DeoptimizationSupport.enabled() && !SubstrateUtil.isBuildingLibgraal();
        }

        protected final boolean isMethodDeoptTarget() {
            return MultiMethod.isDeoptTarget((ResolvedJavaMethod)this.method);
        }

        protected boolean asyncExceptionLiveness() {
            if (SubstrateOptions.parseOnce()) {
                if (this.method instanceof MultiMethod) {
                    return ((MultiMethod)this.method).getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
                }
            } else if (this.method instanceof HostedMethod) {
                return ((HostedMethod)this.method).canDeoptimize();
            }
            return SharedBytecodeParser.isDeoptimizationEnabled();
        }

        protected void clearNonLiveLocalsAtTargetCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
            if (!SharedBytecodeParser.isDeoptimizationEnabled() || !(block instanceof BciBlockMapping.ExceptionDispatchBlock) || this.isMethodDeoptTarget()) {
                super.clearNonLiveLocalsAtTargetCreation(block, state);
            }
        }

        protected void clearNonLiveLocalsAtLoopExitCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
            if (!SharedBytecodeParser.isDeoptimizationEnabled() || this.isMethodDeoptTarget()) {
                super.clearNonLiveLocalsAtLoopExitCreation(block, state);
            }
        }

        protected void createExceptionDispatch(BciBlockMapping.ExceptionDispatchBlock block) {
            if (block instanceof DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint) {
                assert (block instanceof DeoptimizationTargetBciBlockMapping.DeoptExceptionDispatchBlock);
                this.insertDeoptNode((DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint)block);
                List successors = block.getSuccessors();
                assert (successors.size() <= 1);
                BciBlockMapping.ExceptionDispatchBlock successor = successors.isEmpty() ? this.blockMap.getUnwindBlock() : (BciBlockMapping.BciBlock)successors.get(0);
                this.appendGoto((BciBlockMapping.BciBlock)successor);
            } else {
                super.createExceptionDispatch(block);
            }
        }

        protected void iterateBytecodesForBlock(BciBlockMapping.BciBlock block) {
            if (block instanceof DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint) {
                assert (block instanceof DeoptimizationTargetBciBlockMapping.DeoptBciBlock);
                assert (block.getSuccessors().size() == 1 || block.getSuccessors().size() == 2);
                assert (block.getSuccessor(0).isInstructionBlock());
                this.stream.setBCI(block.getStartBci());
                this.insertDeoptNode((DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint)block);
                this.appendGoto(block.getSuccessor(0));
            } else {
                super.iterateBytecodesForBlock(block);
            }
        }

        private void insertDeoptNode(DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint deopt) {
            boolean proxifysInvoke;
            if (deopt instanceof DeoptimizationTargetBciBlockMapping.DeoptBciBlock) {
                assert (!this.frameState.rethrowException());
            } else {
                assert (deopt instanceof DeoptimizationTargetBciBlockMapping.DeoptExceptionDispatchBlock);
                assert (this.frameState.rethrowException());
            }
            int proxifiedInvokeBci = deopt.proxifiedInvokeBci();
            boolean isProxy = deopt.isProxy();
            DeoptEntrySupport deoptNode = isProxy ? (DeoptEntrySupport)this.graph.add((Node)new DeoptProxyAnchorNode(proxifiedInvokeBci)) : (DeoptEntrySupport)this.graph.add((Node)((proxifysInvoke = deopt.proxifysInvoke()) ? DeoptEntryNode.create(proxifiedInvokeBci) : DeoptEntryNode.create()));
            FrameState stateAfter = this.frameState.create(deopt.frameStateBci(), (StateSplit)deoptNode);
            deoptNode.setStateAfter(stateAfter);
            if (this.lastInstr != null) {
                this.lastInstr.setNext(deoptNode.asFixedNode());
            }
            if (isProxy) {
                this.lastInstr = (DeoptProxyAnchorNode)deoptNode;
            } else {
                DeoptEntryNode deoptEntryNode = (DeoptEntryNode)deoptNode;
                deoptEntryNode.setNext((AbstractBeginNode)this.graph.add((Node)new DeoptEntryBeginNode()));
                if (!deopt.isExceptionDispatch()) {
                    FrameStateBuilder originalFrameState = this.frameState.copy();
                    ExceptionObjectNode newExceptionObject = (ExceptionObjectNode)this.graph.add((Node)new ExceptionObjectNode(this.getMetaAccess()));
                    this.frameState.clearStack();
                    this.frameState.push(JavaKind.Object, (ValueNode)newExceptionObject);
                    this.frameState.setRethrowException(true);
                    int bci = ((DeoptimizationTargetBciBlockMapping.DeoptBciBlock)deopt).getStartBci();
                    newExceptionObject.setStateAfter(this.frameState.create(bci, (StateSplit)newExceptionObject));
                    deoptEntryNode.setExceptionEdge((AbstractBeginNode)newExceptionObject);
                    this.insertProxies((FixedNode)newExceptionObject, this.frameState);
                    newExceptionObject.setNext((FixedNode)this.handleException((ValueNode)newExceptionObject, bci, false));
                    this.frameState = originalFrameState;
                } else {
                    AbstractBeginNode newExceptionEdge = (AbstractBeginNode)this.graph.add((Node)new UnreachableBeginNode());
                    newExceptionEdge.setNext((FixedNode)this.graph.add((Node)new LoweredDeadEndNode()));
                    deoptEntryNode.setExceptionEdge(newExceptionEdge);
                }
                this.lastInstr = deoptEntryNode.next();
            }
            this.insertProxies(deoptNode.asFixedNode(), this.frameState);
        }

        private void insertProxies(FixedNode deoptTarget, FrameStateBuilder state) {
            state.insertProxies(value -> this.createProxyNode((ValueNode)value, deoptTarget));
            ++this.currentDeoptIndex;
        }

        private ValueNode createProxyNode(ValueNode value, FixedNode deoptTarget) {
            ValueNode v = DeoptProxyNode.create(value, (ValueNode)deoptTarget, this.currentDeoptIndex);
            if (v.graph() != null) {
                return v;
            }
            return (ValueNode)this.graph.addOrUniqueWithInputs((Node)v);
        }

        protected boolean forceLoopPhis() {
            return this.isMethodDeoptTarget() || super.forceLoopPhis();
        }

        public boolean allowDeoptInPlugins() {
            return super.allowDeoptInPlugins();
        }

        protected ValueNode emitIncompatibleClassChangeCheck(ValueNode object, ResolvedJavaType checkedType) {
            try (DebugCloseable context = this.maybeDisableNodeSourcePositions();){
                ValueNode valueNode = super.emitIncompatibleClassChangeCheck(object, checkedType);
                return valueNode;
            }
        }

        private DebugCloseable maybeDisableNodeSourcePositions() {
            if (!SubstrateOptions.parseOnce() && this.graph.trackNodeSourcePosition()) {
                return this.graph.withNodeSourcePosition(new NodeSourcePosition(this.createBytecodePosition(), this.method, -1));
            }
            return null;
        }
    }
}

