/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;

public class DeletedMethod
extends CustomSubstitutionMethod {
    public static final String NATIVE_MESSAGE = String.format("Native method. If you intend to use the Java Native Interface (JNI), specify %1$s+JNI and see also %1$sJNIConfigurationFiles=<path> (use %1$s+PrintFlags for details)", "-H:");
    private final String message;
    private final AnnotationValue[] injectedAnnotations;
    public static final Method reportErrorMethod = ReflectionUtil.lookupMethod(VMError.class, (String)"unsupportedFeature", (Class[])new Class[]{String.class});

    public DeletedMethod(ResolvedJavaMethod original, Delete deleteAnnotation) {
        super(original);
        this.message = deleteAnnotation.value();
        this.injectedAnnotations = SubstrateAnnotationExtractor.prepareInjectedAnnotations(new Annotation[]{deleteAnnotation});
    }

    @Override
    public AnnotationValue[] getInjectedAnnotations() {
        return this.injectedAnnotations;
    }

    @Override
    public int getModifiers() {
        return this.original.getModifiers() & 0xFFFFFFDF;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        return DeletedMethod.buildGraph(debug, method, providers, this.message, purpose);
    }

    public static StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, String message, GraphProvider.Purpose purpose) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        StructuredGraph graph = kit.getGraph();
        FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
        state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
        int bci = 0;
        graph.start().setStateAfter(state.create(bci++, (StateSplit)graph.start()));
        String msg = AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)method, message, false);
        ConstantNode msgNode = ConstantNode.forConstant((JavaConstant)providers.getConstantReflection().forString(msg), (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graph);
        InvokeWithExceptionNode exceptionNode = kit.createInvokeWithExceptionAndUnwind(providers.getMetaAccess().lookupJavaMethod((Executable)reportErrorMethod), CallTargetNode.InvokeKind.Static, state, bci++, new ValueNode[]{msgNode});
        kit.append((Node)new UnwindNode((ValueNode)exceptionNode));
        return kit.finalizeGraph();
    }
}

