/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.type.TypedConstant;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.replacements.nodes.IdentityHashCodeNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Decided depending on identity hash code storage.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Decided depending on identity hash code storage.")
public final class SubstrateIdentityHashCodeNode
extends IdentityHashCodeNode {
    public static final NodeClass<SubstrateIdentityHashCodeNode> TYPE = NodeClass.create(SubstrateIdentityHashCodeNode.class);

    public static ValueNode create(ValueNode object, int bci) {
        return (ValueNode)new SubstrateIdentityHashCodeNode(object, bci).canonical(null);
    }

    protected SubstrateIdentityHashCodeNode(ValueNode object, int bci) {
        super(TYPE, object, bci);
    }

    public LocationIdentity getKilledLocationIdentity() {
        return SubstrateIdentityHashCodeNode.haveFixedField() ? IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION : LocationIdentity.any();
    }

    protected int getIdentityHashCode(JavaConstant constant) {
        return ((TypedConstant)constant).getIdentityHashCode();
    }

    public NodeCycles estimatedNodeCycles() {
        return SubstrateIdentityHashCodeNode.haveFixedField() ? NodeCycles.CYCLES_2 : NodeCycles.CYCLES_8;
    }

    protected NodeSize dynamicNodeSizeEstimate() {
        return SubstrateIdentityHashCodeNode.haveFixedField() ? NodeSize.SIZE_8 : NodeSize.SIZE_32;
    }

    @Fold
    static boolean haveFixedField() {
        return ConfigurationValues.getObjectLayout().hasFixedIdentityHashField();
    }
}

