/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class PthreadVMMutex
extends VMMutex {
    private final CIsolateData<Pthread.pthread_mutex_t> structPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PthreadVMMutex(String name) {
        super(name);
        this.structPointer = CIsolateDataFactory.createStruct("pthreadMutex_" + name, Pthread.pthread_mutex_t.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Pthread.pthread_mutex_t getStructPointer() {
        return this.structPointer.get();
    }

    @Override
    public VMMutex lock() {
        assert (!this.isOwner()) : "Recursive locking is not supported";
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_lock(this.getStructPointer()), "pthread_mutex_lock");
        this.setOwnerToCurrentThread();
        return this;
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransition() {
        assert (!this.isOwner()) : "Recursive locking is not supported";
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_lock_no_transition(this.getStructPointer()), "pthread_mutex_lock");
        this.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransitionUnspecifiedOwner() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_lock_no_transition(this.getStructPointer()), "pthread_mutex_lock");
        this.setOwnerToUnspecified();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlock() {
        this.clearCurrentThreadOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_unlock(this.getStructPointer()), "pthread_mutex_unlock");
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.")
    public void unlockNoTransitionUnspecifiedOwner() {
        this.clearUnspecifiedOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_unlock(this.getStructPointer()), "pthread_mutex_unlock");
    }
}

