/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.HeapSnapshotVerifier;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.heap.ImageHeapCollectionFeature;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class SVMImageHeapVerifier
extends HeapSnapshotVerifier {
    public SVMImageHeapVerifier(BigBang bb, ImageHeap imageHeap, ImageHeapScanner scanner) {
        super(bb, imageHeap, scanner);
    }

    public boolean requireAnalysisIteration(CompletionExecutor executor) throws InterruptedException {
        return super.requireAnalysisIteration(executor) || SVMImageHeapVerifier.imageStateModified();
    }

    private static boolean imageStateModified() {
        return ((ImageHeapCollectionFeature)ImageSingletons.lookup(ImageHeapCollectionFeature.class)).needsUpdate();
    }

    protected void scanTypes(ObjectScanner objectScanner) {
        SVMHost svmHost = this.svmHost();
        this.bb.getUniverse().getTypes().stream().filter(AnalysisType::isReachable).forEach(t -> this.verifyHub(svmHost, objectScanner, (AnalysisType)t));
    }

    private void verifyHub(SVMHost svmHost, ObjectScanner objectScanner, AnalysisType type) {
        JavaConstant hubConstant = this.bb.getSnippetReflectionProvider().forObject((Object)svmHost.dynamicHub((ResolvedJavaType)type));
        objectScanner.scanConstant(hubConstant, ObjectScanner.OtherReason.HUB);
    }

    private SVMHost svmHost() {
        return (SVMHost)this.bb.getHostVM();
    }
}

