/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.substitutions;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.hosted.RuntimeCompilationFeature;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.core.match.MatchRuleRegistry;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;

@TargetClass(value=MatchRuleRegistry.class, onlyWith={RuntimeCompilationFeature.IsEnabled.class})
final class Target_org_graalvm_compiler_core_match_MatchRuleRegistry {
    Target_org_graalvm_compiler_core_match_MatchRuleRegistry() {
    }

    @Substitute
    public static EconomicMap<Class<? extends Node>, List<MatchStatement>> lookup(Class<? extends NodeLIRBuilder> theClass, OptionValues options, DebugContext debug) {
        EconomicMap<Class<? extends Node>, List<MatchStatement>> result = GraalSupport.get().matchRuleRegistry.get(theClass);
        if (result == null) {
            throw VMError.shouldNotReachHere(String.format("MatchRuleRegistry.lookup(): unexpected class %s", theClass.getName()));
        }
        return result;
    }
}

