/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CFunctionOptions;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CFunctionCallStubMethod;
import com.oracle.svm.hosted.code.CFunctionLinkages;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.c.function.CFunction;

public class CFunctionSubstitutionProcessor
extends SubstitutionProcessor {
    private final Map<ResolvedJavaMethod, CFunctionCallStubMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, CFunctionCallStubMethod>();

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ResolvedJavaMethod wrapper = method;
        if (method.isNative() && method.isAnnotationPresent(CFunction.class)) {
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Uninterruptible.class)) {
                throw VMError.shouldNotReachHere("Native method '%s' incorrectly annotated with @Uninterruptible. Please use @CFunction(transition = NO_TRANSITION) instead.", method.format("%H.%n(%p)"));
            }
            wrapper = this.callWrappers.computeIfAbsent(method, m -> {
                CGlobalDataInfo linkage = CFunctionLinkages.singleton().addOrLookupMethod((ResolvedJavaMethod)m);
                return new CFunctionCallStubMethod((ResolvedJavaMethod)m, linkage, CFunctionSubstitutionProcessor.getNewThreadStatus(method));
            });
        }
        return wrapper;
    }

    private static int getNewThreadStatus(ResolvedJavaMethod method) {
        CFunctionOptions cFunctionOptions = (CFunctionOptions)method.getAnnotation(CFunctionOptions.class);
        if (cFunctionOptions != null) {
            return VMThreads.StatusSupport.getNewThreadStatus(cFunctionOptions.transition());
        }
        CFunction cFunctionAnnotation = (CFunction)method.getAnnotation(CFunction.class);
        if (cFunctionAnnotation != null) {
            return VMThreads.StatusSupport.getNewThreadStatus(cFunctionAnnotation.transition());
        }
        throw VMError.shouldNotReachHere("Method is not annotated with " + CFunction.class.getSimpleName());
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof CFunctionCallStubMethod) {
            return ((CFunctionCallStubMethod)method).getOriginal();
        }
        return method;
    }
}

