/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationParser;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JSONParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class ProxyConfigurationParser
extends ConfigurationParser {
    private final Consumer<ConditionalElement<List<String>>> interfaceListConsumer;

    public ProxyConfigurationParser(Consumer<ConditionalElement<List<String>>> interfaceListConsumer, boolean strictConfiguration) {
        super(strictConfiguration);
        this.interfaceListConsumer = interfaceListConsumer;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.parseTopLevelArray(ProxyConfigurationParser.asList(json, "First-level of document must be an array of interface lists"));
    }

    private void parseTopLevelArray(List<Object> proxyConfiguration) {
        boolean foundInterfaceLists = false;
        boolean foundProxyConfigurationObjects = false;
        for (Object proxyConfigurationObject : proxyConfiguration) {
            if (proxyConfigurationObject instanceof List) {
                foundInterfaceLists = true;
                this.parseInterfaceList(ConfigurationCondition.alwaysTrue(), ProxyConfigurationParser.asList(proxyConfigurationObject, "<shouldn't reach here>"));
            } else if (proxyConfigurationObject instanceof EconomicMap) {
                foundProxyConfigurationObjects = true;
                this.parseWithConditionalConfig(ProxyConfigurationParser.asMap(proxyConfigurationObject, "<shouldn't reach here>"));
            } else {
                throw new JSONParserException("Second-level must be composed of either interface lists or proxy configuration objects");
            }
            if (!foundInterfaceLists || !foundProxyConfigurationObjects) continue;
            throw new JSONParserException("Second-level can only be populated of either interface lists or proxy configuration objects, but these cannot be mixed");
        }
    }

    private void parseInterfaceList(ConfigurationCondition condition, List<?> data) {
        List interfaces = data.stream().map(ConfigurationParser::asString).collect(Collectors.toList());
        try {
            this.interfaceListConsumer.accept(new ConditionalElement(condition, interfaces));
        }
        catch (Exception e) {
            throw new JSONParserException(e.toString());
        }
    }

    private void parseWithConditionalConfig(EconomicMap<String, Object> proxyConfigObject) {
        this.checkAttributes(proxyConfigObject, "proxy descriptor object", Collections.singleton("interfaces"), Collections.singletonList("condition"));
        ConfigurationCondition condition = this.parseCondition(proxyConfigObject);
        this.parseInterfaceList(condition, ProxyConfigurationParser.asList(proxyConfigObject.get((Object)"interfaces"), "The interfaces property must be an array of fully qualified interface names"));
    }
}

