/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import jdk.graal.compiler.code.DataSection;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.core.common.type.TypedConstant;
import jdk.graal.compiler.lir.asm.DataBuilder;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SerializableConstant;
import jdk.vm.ci.meta.VMConstant;

public class SubstrateDataBuilder
extends DataBuilder {
    public DataSection.Data createDataItem(Constant constant) {
        if (constant instanceof VMConstant) {
            VMConstant vmConstant = (VMConstant)constant;
            assert (constant instanceof JavaConstant && constant instanceof CompressibleConstant && constant instanceof TypedConstant) : constant;
            return new ObjectData(vmConstant);
        }
        if (JavaConstant.isNull((Constant)constant)) {
            int size = SubstrateObjectConstant.isCompressed((JavaConstant)constant) ? ConfigurationValues.getObjectLayout().getReferenceSize() : FrameAccess.uncompressedReferenceSize();
            return this.createZeroData(size, size);
        }
        if (constant instanceof SerializableConstant) {
            SerializableConstant s = (SerializableConstant)constant;
            return this.createSerializableData(s);
        }
        throw new JVMCIError(String.valueOf(constant));
    }

    public int getMaxSupportedAlignment() {
        return SubstrateOptions.codeAlignment();
    }

    public static class ObjectData
    extends DataSection.Data {
        private final VMConstant constant;

        protected ObjectData(VMConstant constant) {
            super(ConfigurationValues.getObjectLayout().getReferenceSize(), ConfigurationValues.getObjectLayout().getReferenceSize());
            assert (((CompressibleConstant)constant).isCompressed() == ReferenceAccess.singleton().haveCompressedReferences()) : "Constant object references in compiled code must be compressed (base-relative)";
            this.constant = constant;
        }

        public JavaConstant getConstant() {
            return (JavaConstant)this.constant;
        }

        protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
            ObjectData.emit(buffer, patches, this.getSize(), this.constant);
        }

        public static void emit(ByteBuffer buffer, DataSection.Patches patches, int size, VMConstant constant) {
            int position = buffer.position();
            if (size == 4) {
                buffer.putInt(0);
            } else if (size == 8) {
                buffer.putLong(0L);
            } else {
                VMError.shouldNotReachHere("Unsupported object constant reference size: " + size);
            }
            patches.registerPatch(position, constant);
        }
    }
}

