/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.heap.PodReferenceMapDecoder;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.util.VMError;
import java.util.function.IntConsumer;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class InteriorObjRefWalker {
    @NeverInline(value="Non-performance critical version")
    public static boolean walkObject(Object obj, ObjectReferenceVisitor visitor) {
        return InteriorObjRefWalker.walkObjectInline(obj, visitor);
    }

    @AlwaysInline(value="Performance critical version")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkObjectInline(Object obj, ObjectReferenceVisitor visitor) {
        DynamicHub objHub = ObjectHeader.readDynamicHubFromObject(obj);
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        switch (objHub.getHubType()) {
            case 0: 
            case 1: {
                return InteriorObjRefWalker.walkInstance(obj, visitor, objHub, (Pointer)objPointer);
            }
            case 2: {
                return InteriorObjRefWalker.walkPod(obj, visitor, objHub, (Pointer)objPointer);
            }
            case 3: {
                return InteriorObjRefWalker.walkStoredContinuation(obj, visitor);
            }
            case 4: {
                return InteriorObjRefWalker.walkOther();
            }
            case 5: {
                return true;
            }
            case 6: {
                return InteriorObjRefWalker.walkObjectArray(obj, visitor, objHub, (Pointer)objPointer);
            }
        }
        throw VMError.shouldNotReachHere("Object with invalid hub type.");
    }

    public static boolean walkInstanceReferenceOffsets(DynamicHub objHub, final IntConsumer offsetConsumer) {
        if (objHub.getHubType() != 0 && objHub.getHubType() != 1) {
            throw new IllegalArgumentException("Unsupported hub type: " + objHub.getHubType());
        }
        NonmovableArray<Byte> referenceMapEncoding = DynamicHubSupport.getReferenceMapEncoding();
        long referenceMapIndex = objHub.getReferenceMapIndex();
        return InstanceReferenceMapDecoder.walkOffsetsFromPointer((Pointer)WordFactory.zero(), referenceMapEncoding, referenceMapIndex, new ObjectReferenceVisitor(){

            @Override
            public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
                offsetConsumer.accept((int)objRef.rawValue());
                return true;
            }
        }, null);
    }

    @AlwaysInline(value="Performance critical version")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean walkInstance(Object obj, ObjectReferenceVisitor visitor, DynamicHub objHub, Pointer objPointer) {
        NonmovableArray<Byte> referenceMapEncoding = DynamicHubSupport.getReferenceMapEncoding();
        long referenceMapIndex = objHub.getReferenceMapIndex();
        return InstanceReferenceMapDecoder.walkOffsetsFromPointer(objPointer, referenceMapEncoding, referenceMapIndex, visitor, obj);
    }

    @AlwaysInline(value="Performance critical version")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean walkPod(Object obj, ObjectReferenceVisitor visitor, DynamicHub objHub, Pointer objPointer) {
        if (!Pod.RuntimeSupport.isPresent()) {
            throw VMError.shouldNotReachHere("Pod objects cannot be in the heap if the pod support is disabled.");
        }
        return InteriorObjRefWalker.walkInstance(obj, visitor, objHub, objPointer) && PodReferenceMapDecoder.walkOffsetsFromPointer(objPointer, objHub.getLayoutEncoding(), visitor, obj);
    }

    @AlwaysInline(value="Performance critical version")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean walkStoredContinuation(Object obj, ObjectReferenceVisitor visitor) {
        if (!ContinuationSupport.isSupported()) {
            throw VMError.shouldNotReachHere("Stored continuation objects cannot be in the heap if the continuation support is disabled.");
        }
        return StoredContinuationAccess.walkReferences(obj, visitor);
    }

    @AlwaysInline(value="Performance critical version")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean walkOther() {
        throw VMError.shouldNotReachHere("Unexpected object with hub type 'other' in the heap.");
    }

    @AlwaysInline(value="Performance critical version")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean walkObjectArray(Object obj, ObjectReferenceVisitor visitor, DynamicHub objHub, Pointer objPointer) {
        int length = ArrayLengthNode.arrayLength((Object)obj);
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        boolean isCompressed = ReferenceAccess.singleton().haveCompressedReferences();
        Pointer pos = objPointer.add(LayoutEncoding.getArrayBaseOffset(objHub.getLayoutEncoding()));
        Pointer end = pos.add(WordFactory.unsigned((int)referenceSize).multiply(length));
        while (pos.belowThan((UnsignedWord)end)) {
            boolean visitResult = InteriorObjRefWalker.callVisitor(obj, visitor, isCompressed, pos);
            if (!visitResult) {
                return false;
            }
            pos = pos.add(referenceSize);
        }
        return true;
    }

    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean callVisitor(Object obj, ObjectReferenceVisitor visitor, boolean isCompressed, Pointer pos) {
        return visitor.visitObjectReferenceInline(pos, 0, isCompressed, obj);
    }
}

