/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.type.TypedConstant;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.replacements.nodes.IdentityHashCodeNode;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Decided depending on identity hash code storage.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Decided depending on identity hash code storage.")
public final class SubstrateIdentityHashCodeNode
extends IdentityHashCodeNode {
    public static final NodeClass<SubstrateIdentityHashCodeNode> TYPE = NodeClass.create(SubstrateIdentityHashCodeNode.class);

    public static ValueNode create(ValueNode object, int bci) {
        return (ValueNode)new SubstrateIdentityHashCodeNode(object, bci).canonical(null);
    }

    protected SubstrateIdentityHashCodeNode(ValueNode object, int bci) {
        super(TYPE, object, bci);
    }

    public LocationIdentity getKilledLocationIdentity() {
        return SubstrateIdentityHashCodeNode.isIdentityHashFieldOptional() ? LocationIdentity.any() : IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION;
    }

    protected int getIdentityHashCode(JavaConstant constant) {
        return ((TypedConstant)constant).getIdentityHashCode();
    }

    public NodeCycles estimatedNodeCycles() {
        return SubstrateIdentityHashCodeNode.isIdentityHashFieldOptional() ? NodeCycles.CYCLES_8 : NodeCycles.CYCLES_2;
    }

    protected NodeSize dynamicNodeSizeEstimate() {
        return SubstrateIdentityHashCodeNode.isIdentityHashFieldOptional() ? NodeSize.SIZE_32 : NodeSize.SIZE_8;
    }

    @Fold
    static boolean isIdentityHashFieldOptional() {
        return ConfigurationValues.getObjectLayout().isIdentityHashFieldOptional();
    }
}

