/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.ForeignDisabled;
import com.oracle.svm.core.jdk.ForeignDisabledSubstitutions;
import com.oracle.svm.core.jdk.JDK21OrEarlier;
import com.oracle.svm.core.jdk.JDK22OrLater;
import com.oracle.svm.core.jdk.ModuleUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@TargetClass(value=Module.class)
public final class Target_java_lang_Module {
    @Substitute
    @TargetElement(onlyWith={ForeignDisabled.class})
    public boolean isNativeAccessEnabled() {
        throw ForeignDisabledSubstitutions.fail();
    }

    @Alias
    @TargetElement(onlyWith={JDK21OrEarlier.class})
    public native void ensureNativeAccess(Class<?> var1, String var2);

    @Alias
    @TargetElement(onlyWith={JDK22OrLater.class})
    public native void ensureNativeAccess(Class<?> var1, String var2, Class<?> var3);

    @Substitute
    private static void defineModule0(Module module, boolean isOpen, String version, String location, Object[] pns) {
        if (Arrays.stream(pns).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Bad package name");
        }
        List<String> packages = Arrays.stream(pns).map(Object::toString).collect(Collectors.toUnmodifiableList());
        ModuleUtil.defineModule(module, isOpen, packages);
    }

    @Substitute
    private static void addReads0(Module from, Module to) {
        if (Objects.isNull(from)) {
            throw new NullPointerException("The from_module is null");
        }
    }

    @Substitute
    private static void addExports0(Module from, String pn, Module to) {
        if (Objects.isNull(to)) {
            throw new NullPointerException("The to_module is null");
        }
        ModuleUtil.checkFromModuleAndPackageNullability(from, pn);
        ModuleUtil.checkIsPackageContainedInModule(pn, from);
    }

    @Substitute
    private static void addExportsToAll0(Module from, String pn) {
        ModuleUtil.checkFromModuleAndPackageNullability(from, pn);
        ModuleUtil.checkIsPackageContainedInModule(pn, from);
    }

    @Substitute
    private static void addExportsToAllUnnamed0(Module from, String pn) {
        ModuleUtil.checkFromModuleAndPackageNullability(from, pn);
        if (from.isNamed()) {
            ModuleUtil.checkIsPackageContainedInModule(pn, from);
        }
    }
}

