/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.sampler;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.sampler.SamplerSampleWriterDataAccess;
import com.oracle.svm.core.sampler.SamplerStackWalkVisitor;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.util.PointerUtils;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractJfrExecutionSampler
extends JfrExecutionSampler
implements ThreadListener {
    private static final FastThreadLocalInt samplerState = FastThreadLocalFactory.createInt("JfrSampler.samplerState");
    private static final FastThreadLocalInt isDisabledForCurrentThread = FastThreadLocalFactory.createInt("JfrSampler.isDisabledForCurrentThread");
    private final UninterruptibleUtils.AtomicInteger isSignalHandlerDisabledGlobally = new UninterruptibleUtils.AtomicInteger(0);
    private final UninterruptibleUtils.AtomicInteger threadsInSignalHandler = new UninterruptibleUtils.AtomicInteger(0);
    private volatile boolean isSampling;
    private long curIntervalMillis;
    protected long newIntervalMillis;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractJfrExecutionSampler() {
    }

    @Fold
    public static AbstractJfrExecutionSampler singleton() {
        return (AbstractJfrExecutionSampler)ImageSingletons.lookup(JfrExecutionSampler.class);
    }

    @Fold
    protected static UninterruptibleUtils.AtomicInteger threadsInSignalHandler() {
        return AbstractJfrExecutionSampler.singleton().threadsInSignalHandler;
    }

    @Override
    public void setIntervalMillis(long intervalMillis) {
        this.newIntervalMillis = intervalMillis;
    }

    @Override
    @Uninterruptible(reason="Prevent VM operations that modify execution sampling.", callerMustBe=true)
    public boolean isSampling() {
        return this.isSampling;
    }

    @Override
    public void update() {
        UpdateJfrExecutionSamplerOperation op = new UpdateJfrExecutionSamplerOperation();
        op.enqueue();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void preventSamplingInCurrentThread() {
        int newValue = isDisabledForCurrentThread.get() + 1;
        assert (newValue >= 0);
        isDisabledForCurrentThread.set(newValue);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void allowSamplingInCurrentThread() {
        int newValue = isDisabledForCurrentThread.get() - 1;
        assert (newValue >= -1);
        isDisabledForCurrentThread.set(newValue);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void disallowThreadsInSamplerCode() {
        int value = this.isSignalHandlerDisabledGlobally.incrementAndGet();
        assert (value > 0);
        while (this.threadsInSignalHandler.get() > 0) {
            VMThreads.singleton().yield();
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void allowThreadsInSamplerCode() {
        int value = this.isSignalHandlerDisabledGlobally.decrementAndGet();
        assert (value >= 0);
    }

    @Override
    @Uninterruptible(reason="Prevent VM operations that modify execution sampler state.")
    public void afterThreadRun() {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        this.uninstall(thread);
        ExecutionSamplerInstallation.disallow(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static boolean isExecutionSamplingAllowedInCurrentThread() {
        boolean disallowed = AbstractJfrExecutionSampler.singleton().isSignalHandlerDisabledGlobally.get() > 0 || isDisabledForCurrentThread.get() > 0 || SubstrateJVM.getSamplerBufferPool().isLockedByCurrentThread();
        return ExecutionSamplerInstallation.isInstalled(CurrentIsolate.getCurrentThread()) && !disallowed;
    }

    protected abstract void startSampling();

    protected abstract void stopSampling();

    protected abstract void updateInterval();

    protected abstract void uninstall(IsolateThread var1);

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    protected static void tryUninterruptibleStackWalk(CodePointer ip, Pointer sp) {
        block7: {
            AbstractJfrExecutionSampler.threadsInSignalHandler().incrementAndGet();
            try {
                if (AbstractJfrExecutionSampler.isExecutionSamplingAllowedInCurrentThread()) {
                    JfrExecutionSampler.singleton().preventSamplingInCurrentThread();
                    try {
                        AbstractJfrExecutionSampler.doUninterruptibleStackWalk(ip, sp);
                        break block7;
                    }
                    finally {
                        JfrExecutionSampler.singleton().allowSamplingInCurrentThread();
                    }
                }
                JfrThreadLocal.increaseMissedSamples();
            }
            finally {
                AbstractJfrExecutionSampler.threadsInSignalHandler().decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    private static void doUninterruptibleStackWalk(CodePointer initialIp, Pointer initialSp) {
        SamplerSampleWriterData data;
        CodePointer ip = initialIp;
        Pointer sp = initialSp;
        if (!AbstractJfrExecutionSampler.isInAOTCompiledCode(ip)) {
            JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
            if (anchor.isNull()) {
                return;
            }
            ip = anchor.getLastJavaIP();
            sp = anchor.getLastJavaSP();
            if (ip.isNull() || sp.isNull()) {
                return;
            }
        }
        if (SamplerSampleWriterDataAccess.initialize(data = (SamplerSampleWriterData)StackValue.get(SamplerSampleWriterData.class), 0, false)) {
            JfrThreadLocal.setSamplerWriterData(data);
            try {
                AbstractJfrExecutionSampler.doUninterruptibleStackWalk(data, sp, ip);
            }
            finally {
                JfrThreadLocal.setSamplerWriterData((SamplerSampleWriterData)WordFactory.nullPointer());
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isInAOTCompiledCode(CodePointer ip) {
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        return CodeInfoAccess.contains(codeInfo, ip);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isSPOutsideStackBoundaries(Pointer sp) {
        UnsignedWord stackBase = VMThreads.StackBase.get();
        assert (stackBase.notEqual(0));
        Pointer returnAddressLocation = FrameAccess.singleton().getReturnAddressLocation(sp).add(FrameAccess.returnAddressSize());
        return returnAddressLocation.aboveThan(stackBase) || returnAddressLocation.belowOrEqual(VMThreads.StackEnd.get());
    }

    @Uninterruptible(reason="This method must be uninterruptible since it uses untethered code info.", callerMustBe=true)
    private static Pointer getCallerSP(CodeInfo codeInfo, Pointer sp, CodePointer ip) {
        long relativeIP = CodeInfoAccess.relativeIP(codeInfo, ip);
        long totalFrameSize = CodeInfoAccess.lookupTotalFrameSize(codeInfo, relativeIP);
        return sp.add(WordFactory.unsigned((long)totalFrameSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isSPAligned(Pointer sp) {
        return PointerUtils.isAMultiple((PointerBase)sp, WordFactory.unsigned((int)ConfigurationValues.getTarget().stackAlignment));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isEntryPoint(CodeInfo codeInfo, CodePointer ip) {
        long relativeIP = CodeInfoAccess.relativeIP(codeInfo, ip);
        SimpleCodeInfoQueryResult queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
        CodeInfoAccess.lookupCodeInfo(codeInfo, relativeIP, queryResult);
        return CodeInfoQueryResult.isEntryPoint(queryResult.getEncodedFrameSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JavaFrameAnchor findLastJavaFrameAnchor(Pointer callerSP) {
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
        while (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)callerSP)) {
            anchor = anchor.getPreviousAnchor();
        }
        assert (anchor.isNull() || anchor.getLastJavaSP().aboveThan((UnsignedWord)callerSP));
        return anchor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Uninterruptible(reason="This method must be uninterruptible since it uses untethered code info.", callerMustBe=true)
    private static void doUninterruptibleStackWalk(SamplerSampleWriterData data, Pointer sp, CodePointer ip) {
        Pointer callerSP;
        SamplerSampleWriter.begin(data);
        assert (AbstractJfrExecutionSampler.isInAOTCompiledCode(ip));
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        SamplerStackWalkVisitor visitor = (SamplerStackWalkVisitor)ImageSingletons.lookup(SamplerStackWalkVisitor.class);
        if (!visitor.visitFrame(sp, ip, codeInfo, null, null)) {
            SamplerSampleWriter.end(data, -2L);
            return;
        }
        if (AbstractJfrExecutionSampler.isSPAligned(sp)) {
            callerSP = AbstractJfrExecutionSampler.getCallerSP(codeInfo, sp, ip);
            if (SubstrateOptions.PreserveFramePointer.getValue().booleanValue() && (AbstractJfrExecutionSampler.isSPOutsideStackBoundaries(callerSP) || !AbstractJfrExecutionSampler.isInAOTCompiledCode(FrameAccess.singleton().readReturnAddress(callerSP)))) {
                callerSP = sp.add(FrameAccess.wordSize()).add(FrameAccess.singleton().savedBasePointerSize());
            }
        } else {
            callerSP = sp.add(FrameAccess.wordSize());
        }
        if (AbstractJfrExecutionSampler.isSPOutsideStackBoundaries(callerSP)) {
            JfrThreadLocal.increaseUnparseableStacks();
            return;
        }
        CodePointer returnAddressIP = FrameAccess.singleton().readReturnAddress(callerSP);
        if (!AbstractJfrExecutionSampler.isInAOTCompiledCode(returnAddressIP)) {
            if (!AbstractJfrExecutionSampler.isEntryPoint(codeInfo, ip)) {
                JfrThreadLocal.increaseUnparseableStacks();
                return;
            }
            JavaFrameAnchor anchor = AbstractJfrExecutionSampler.findLastJavaFrameAnchor(callerSP);
            if (!anchor.isNonNull()) {
                SamplerSampleWriter.end(data, -2L);
                return;
            }
            callerSP = anchor.getLastJavaSP();
            returnAddressIP = anchor.getLastJavaIP();
        }
        if (JavaStackWalker.walkCurrentThread(callerSP, returnAddressIP, visitor) || data.getTruncated()) {
            SamplerSampleWriter.end(data, -2L);
        }
    }

    private static class UpdateJfrExecutionSamplerOperation
    extends JavaVMOperation {
        UpdateJfrExecutionSamplerOperation() {
            super(VMOperationInfos.get(UpdateJfrExecutionSamplerOperation.class, "Update JFR sampler", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            AbstractJfrExecutionSampler sampler = AbstractJfrExecutionSampler.singleton();
            boolean shouldSample = UpdateJfrExecutionSamplerOperation.shouldSample();
            if (sampler.isSampling != shouldSample) {
                if (shouldSample) {
                    sampler.isSampling = true;
                    sampler.startSampling();
                } else {
                    sampler.stopSampling();
                    sampler.isSampling = false;
                }
            } else if (shouldSample && sampler.newIntervalMillis != sampler.curIntervalMillis) {
                sampler.updateInterval();
            }
            sampler.curIntervalMillis = sampler.newIntervalMillis;
        }

        @Uninterruptible(reason="Needed for calling JfrEvent.shouldEmit().")
        private static boolean shouldSample() {
            assert (VMOperation.isInProgressAtSafepoint());
            return JfrEvent.ExecutionSample.shouldEmit() && AbstractJfrExecutionSampler.singleton().newIntervalMillis > 0L;
        }
    }

    protected static class ExecutionSamplerInstallation {
        private static final int DISALLOWED = -1;
        private static final int ALLOWED = 0;
        private static final int INSTALLED = 1;

        protected ExecutionSamplerInstallation() {
        }

        @Uninterruptible(reason="Prevent VM operations that modify the execution sampler.", callerMustBe=true)
        public static void disallow(IsolateThread thread) {
            assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
            assert (samplerState.get(thread) == 0);
            samplerState.set(thread, -1);
        }

        @Uninterruptible(reason="Prevent VM operations that modify the execution sampler.", callerMustBe=true)
        public static void installed(IsolateThread thread) {
            assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
            assert (samplerState.get(thread) == 0);
            samplerState.set(thread, 1);
        }

        @Uninterruptible(reason="Prevent VM operations that modify the execution sampler.", callerMustBe=true)
        public static void uninstalled(IsolateThread thread) {
            assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
            assert (samplerState.get(thread) == 1);
            samplerState.set(thread, 0);
        }

        @Uninterruptible(reason="Prevent VM operations that modify the execution sampler.", callerMustBe=true)
        public static boolean isAllowed(IsolateThread thread) {
            assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
            return samplerState.get(thread) == 0;
        }

        @Uninterruptible(reason="Prevent VM operations that modify the execution sampler.", callerMustBe=true)
        public static boolean isInstalled(IsolateThread thread) {
            assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
            return samplerState.get(thread) == 1;
        }
    }
}

