/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.SubstrateOptionKey;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ValidateImageBuildOptionsFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        UnmodifiableMapCursor cursor = RuntimeOptionValues.singleton().getMap().getEntries();
        while (cursor.advance()) {
            ValidateImageBuildOptionsFeature.validate((OptionKey)cursor.getKey());
        }
        cursor = HostedOptionValues.singleton().getMap().getEntries();
        while (cursor.advance()) {
            ValidateImageBuildOptionsFeature.validate((OptionKey)cursor.getKey());
        }
    }

    private static void validate(OptionKey<?> option) {
        SubstrateOptionKey o;
        if (option instanceof SubstrateOptionKey && (o = (SubstrateOptionKey)option).hasBeenSet()) {
            o.validate();
        }
    }
}

