/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.UserError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public final class PosixSubstrateSigprofHandler
extends SubstrateSigprofHandler {
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(PosixSubstrateSigprofHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixSubstrateSigprofHandler() {
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in sigprof signal handler.")
    @Uninterruptible(reason="Signal handler may only execute uninterruptible code.")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (PosixSubstrateSigprofHandler.tryEnterIsolate()) {
            CodePointer ip = (CodePointer)RegisterDumper.singleton().getIP(uContext);
            Pointer sp = (Pointer)RegisterDumper.singleton().getSP(uContext);
            PosixSubstrateSigprofHandler.tryUninterruptibleStackWalk(ip, sp);
        }
    }

    private static void registerSigprofSignal(Signal.AdvancedSignalDispatcher dispatcher) {
        PosixUtils.installSignalHandler(Signal.SignalEnum.SIGPROF, dispatcher, Signal.SA_RESTART());
    }

    @Override
    protected void updateInterval() {
        PosixSubstrateSigprofHandler.updateInterval(TimeUtils.millisToMicros(this.newIntervalMillis));
    }

    public static void updateInterval(long us) {
        Time.itimerval newValue = UnsafeStackValue.get(Time.itimerval.class);
        newValue.it_value().set_tv_sec(us / 1000000L);
        newValue.it_value().set_tv_usec(us % 1000000L);
        newValue.it_interval().set_tv_sec(us / 1000000L);
        newValue.it_interval().set_tv_usec(us % 1000000L);
        int status = Time.NoTransitions.setitimer(Time.TimerTypeEnum.ITIMER_PROF, newValue, (Time.itimerval)WordFactory.nullPointer());
        PosixUtils.checkStatusIs0(status, "setitimer(which, newValue, oldValue): wrong arguments.");
    }

    @Override
    protected void installSignalHandler() {
        PosixSubstrateSigprofHandler.registerSigprofSignal((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
        this.updateInterval();
    }

    @Override
    protected void uninstallSignalHandler() {
        PosixSubstrateSigprofHandler.updateInterval(0L);
    }

    static boolean isSignalHandlerBasedExecutionSamplerEnabled() {
        if (Options.SignalHandlerBasedExecutionSampler.hasBeenSet()) {
            return Options.SignalHandlerBasedExecutionSampler.getValue();
        }
        return PosixSubstrateSigprofHandler.isPlatformSupported();
    }

    private static boolean isPlatformSupported() {
        return (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) && SubstrateOptions.EnableSignalHandling.getValue() != false;
    }

    private static void validateSamplerOption(HostedOptionKey<Boolean> isSamplerEnabled) {
        if (isSamplerEnabled.getValue().booleanValue()) {
            UserError.guarantee(PosixSubstrateSigprofHandler.isPlatformSupported(), "The %s cannot be used to profile on this platform.", SubstrateOptionsParser.commandArgument(isSamplerEnabled, "+"));
        }
    }

    static class Options {
        public static final HostedOptionKey<Boolean> SignalHandlerBasedExecutionSampler = new HostedOptionKey<Object>(null, PosixSubstrateSigprofHandler::validateSamplerOption);

        Options() {
        }
    }
}

