/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationListener;
import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public class VMOperationListenerSupport {
    private VMOperationListener[] listeners = new VMOperationListener[0];

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMOperationListenerSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(VMOperationListener listener) {
        assert (listener != null);
        int oldLength = this.listeners.length;
        this.listeners = Arrays.copyOf(this.listeners, oldLength + 1);
        this.listeners[oldLength] = listener;
    }

    @Fold
    public static VMOperationListenerSupport get() {
        return (VMOperationListenerSupport)ImageSingletons.lookup(VMOperationListenerSupport.class);
    }

    @Uninterruptible(reason="Force that all listeners are uninterruptible.")
    public void vmOperationChanged(VMOperation operation) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].vmOperationChanged(operation);
        }
    }
}

