/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyUtils;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class InlineBeforeAnalysisPolicyImpl
extends InlineBeforeAnalysisPolicy {
    private final SVMHost hostVM;
    private final InlineBeforeAnalysisPolicyUtils inliningUtils;

    public InlineBeforeAnalysisPolicyImpl(SVMHost hostVM, InlineBeforeAnalysisPolicyUtils inliningUtils) {
        super(new NodePlugin[]{new ConstantFoldLoadFieldPlugin(ParsingReason.PointsToAnalysis)});
        this.hostVM = hostVM;
        this.inliningUtils = inliningUtils;
    }

    protected boolean shouldInlineInvoke(GraphBuilderContext b, InlineBeforeAnalysisPolicy.AbstractPolicyScope policyScope, AnalysisMethod method, ValueNode[] args) {
        return this.inliningUtils.shouldInlineInvoke(b, this.hostVM, (InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope)policyScope, method);
    }

    protected InlineInvokePlugin.InlineInfo createInvokeInfo(AnalysisMethod method) {
        return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)method);
    }

    protected boolean needsExplicitExceptions() {
        return true;
    }

    protected boolean tryInvocationPlugins() {
        return true;
    }

    protected InlineBeforeAnalysisPolicy.AbstractPolicyScope createRootScope() {
        return null;
    }

    protected InlineBeforeAnalysisPolicy.AbstractPolicyScope openCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope outer, AnalysisMethod method) {
        return this.inliningUtils.createAccumulativeInlineScope((InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope)outer, method);
    }

    protected boolean shouldOmitIntermediateMethodInState(AnalysisMethod method) {
        return this.inliningUtils.shouldOmitIntermediateMethodInState(method);
    }

    protected FixedWithNextNode processInvokeArgs(AnalysisMethod targetMethod, FixedWithNextNode insertionPoint, ValueNode[] arguments, NodeSourcePosition sourcePosition) {
        return insertionPoint;
    }
}

